// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptography/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds replication Amazon Web Services Regions to an existing Amazon Web Services
// Payment Cryptography key, enabling the key to be used for cryptographic
// operations in additional Amazon Web Services Regions.
//
// [Multi-Region key replication]allow you to use the same key material across multiple Amazon Web Services
// Regions, providing lower latency for applications distributed across regions.
// When you add Replication Regions, Amazon Web Services Payment Cryptography
// securely replicates the key material to the specified Amazon Web Services
// Regions.
//
// The key must be in an active state to add Replication Regions. You can add
// multiple regions in a single operation, and the key will be available for use in
// those regions once replication is complete.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [RemoveKeyReplicationRegions]
//
// [EnableDefaultKeyReplicationRegions]
//
// [GetDefaultKeyReplicationRegions]
//
// [RemoveKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_RemoveKeyReplicationRegions.html
// [Multi-Region key replication]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html
// [EnableDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_EnableDefaultKeyReplicationRegions.html
// [GetDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetDefaultKeyReplicationRegions.html
func (c *Client) AddKeyReplicationRegions(ctx context.Context, params *AddKeyReplicationRegionsInput, optFns ...func(*Options)) (*AddKeyReplicationRegionsOutput, error) {
	if params == nil {
		params = &AddKeyReplicationRegionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AddKeyReplicationRegions", params, optFns, c.addOperationAddKeyReplicationRegionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AddKeyReplicationRegionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input parameters for adding replication regions to a specific key.
type AddKeyReplicationRegionsInput struct {

	// The key identifier (ARN or alias) of the key for which to add replication
	// regions.
	//
	// This key must exist and be in a valid state for replication operations.
	//
	// This member is required.
	KeyIdentifier *string

	// The list of Amazon Web Services Regions to add to the key's replication
	// configuration.
	//
	// Each region must be a valid Amazon Web Services Region where Amazon Web
	// Services Payment Cryptography is available. The key will be replicated to these
	// regions, allowing cryptographic operations to be performed closer to your
	// applications.
	//
	// This member is required.
	ReplicationRegions []string

	noSmithyDocumentSerde
}

// Output from adding replication regions to a key.
type AddKeyReplicationRegionsOutput struct {

	// The updated key metadata after adding the replication regions.
	//
	// This includes the current state of the key and its replication configuration.
	//
	// This member is required.
	Key *types.Key

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAddKeyReplicationRegionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAddKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAddKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AddKeyReplicationRegions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAddKeyReplicationRegionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAddKeyReplicationRegions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAddKeyReplicationRegions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AddKeyReplicationRegions",
	}
}
