// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the context information for an existing engagement with new or modified
// data.
func (c *Client) UpdateEngagementContext(ctx context.Context, params *UpdateEngagementContextInput, optFns ...func(*Options)) (*UpdateEngagementContextOutput, error) {
	if params == nil {
		params = &UpdateEngagementContextInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateEngagementContext", params, optFns, c.addOperationUpdateEngagementContextMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateEngagementContextOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateEngagementContextInput struct {

	// Specifies the catalog associated with the engagement context update request.
	// This field takes a string value from a predefined list: AWS or Sandbox . The
	// catalog determines which environment the engagement context is updated in.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the specific engagement context to be updated. This
	// ensures that the correct context within the engagement is modified.
	//
	// This member is required.
	ContextIdentifier *string

	// The unique identifier of the Engagement containing the context to be updated.
	// This parameter ensures the context update is applied to the correct engagement.
	//
	// This member is required.
	EngagementIdentifier *string

	// The timestamp when the engagement was last modified, used for optimistic
	// concurrency control. This helps prevent conflicts when multiple users attempt to
	// update the same engagement simultaneously.
	//
	// This member is required.
	EngagementLastModifiedAt *time.Time

	// Contains the updated contextual information for the engagement. The structure
	// of this payload varies based on the context type specified in the Type field.
	//
	// This member is required.
	Payload types.UpdateEngagementContextPayload

	// Specifies the type of context being updated within the engagement. This field
	// determines the structure and content of the context payload being modified.
	//
	// This member is required.
	Type types.EngagementContextType

	noSmithyDocumentSerde
}

type UpdateEngagementContextOutput struct {

	// The unique identifier of the engagement context that was updated.
	//
	// This member is required.
	ContextId *string

	// The Amazon Resource Name (ARN) of the updated engagement.
	//
	// This member is required.
	EngagementArn *string

	// The unique identifier of the engagement that was updated.
	//
	// This member is required.
	EngagementId *string

	// The timestamp when the engagement context was last modified.
	//
	// This member is required.
	EngagementLastModifiedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateEngagementContextMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateEngagementContext{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateEngagementContext{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateEngagementContext"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateEngagementContextValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateEngagementContext(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateEngagementContext(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateEngagementContext",
	}
}
