// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This action starts the engagement by accepting an EngagementInvitation . The
// task is asynchronous and involves the following steps: accepting the invitation,
// creating an opportunity in the partner’s account from the AWS opportunity, and
// copying details for tracking. When completed, an Opportunity Created event is
// generated, indicating that the opportunity has been successfully created in the
// partner's account.
func (c *Client) StartEngagementByAcceptingInvitationTask(ctx context.Context, params *StartEngagementByAcceptingInvitationTaskInput, optFns ...func(*Options)) (*StartEngagementByAcceptingInvitationTaskOutput, error) {
	if params == nil {
		params = &StartEngagementByAcceptingInvitationTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartEngagementByAcceptingInvitationTask", params, optFns, c.addOperationStartEngagementByAcceptingInvitationTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartEngagementByAcceptingInvitationTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartEngagementByAcceptingInvitationTaskInput struct {

	// Specifies the catalog related to the task. Use AWS for production engagements
	// and Sandbox for testing scenarios.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier provided by the client that helps to ensure
	// the idempotency of the request. This can be a random or meaningful string but
	// must be unique for each request.
	//
	// This member is required.
	ClientToken *string

	// Specifies the unique identifier of the EngagementInvitation to be accepted.
	// Providing the correct identifier helps ensure that the correct engagement is
	// processed.
	//
	// This member is required.
	Identifier *string

	// A map of the key-value pairs of the tag or tags to assign.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type StartEngagementByAcceptingInvitationTaskOutput struct {

	// Returns the identifier of the engagement invitation that was accepted and used
	// to create the opportunity.
	EngagementInvitationId *string

	// If the task fails, this field contains a detailed message describing the
	// failure and possible recovery steps.
	Message *string

	// Returns the original opportunity identifier passed in the request. This is the
	// unique identifier for the opportunity.
	OpportunityId *string

	// Indicates the reason for task failure using an enumerated code.
	ReasonCode types.ReasonCode

	// The identifier of the Resource Snapshot Job created as part of this task.
	ResourceSnapshotJobId *string

	// The timestamp indicating when the task was initiated. The format follows RFC
	// 3339 section 5.6.
	StartTime *time.Time

	// The Amazon Resource Name (ARN) of the task, used for tracking and managing the
	// task within AWS.
	TaskArn *string

	// The unique identifier of the task, used to track the task’s progress.
	TaskId *string

	// Indicates the current status of the task.
	TaskStatus types.TaskStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartEngagementByAcceptingInvitationTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartEngagementByAcceptingInvitationTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartEngagementByAcceptingInvitationTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartEngagementByAcceptingInvitationTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartEngagementByAcceptingInvitationTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartEngagementByAcceptingInvitationTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartEngagementByAcceptingInvitationTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartEngagementByAcceptingInvitationTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartEngagementByAcceptingInvitationTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartEngagementByAcceptingInvitationTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartEngagementByAcceptingInvitationTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartEngagementByAcceptingInvitationTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartEngagementByAcceptingInvitationTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartEngagementByAcceptingInvitationTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartEngagementByAcceptingInvitationTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartEngagementByAcceptingInvitationTask",
	}
}
