// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all in-progress, completed, or failed opportunity creation tasks from
// engagements that were initiated by the caller's account.
func (c *Client) ListOpportunityFromEngagementTasks(ctx context.Context, params *ListOpportunityFromEngagementTasksInput, optFns ...func(*Options)) (*ListOpportunityFromEngagementTasksOutput, error) {
	if params == nil {
		params = &ListOpportunityFromEngagementTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOpportunityFromEngagementTasks", params, optFns, c.addOperationListOpportunityFromEngagementTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOpportunityFromEngagementTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOpportunityFromEngagementTasksInput struct {

	// Specifies the catalog related to the request. Valid values are AWS for
	// production environments and Sandbox for testing or development purposes. The
	// catalog determines which environment the task data is retrieved from.
	//
	// This member is required.
	Catalog *string

	// Filters tasks by the identifiers of the engagement contexts associated with the
	// opportunity creation. Use this to find tasks related to specific contextual
	// information within engagements that are being converted to opportunities.
	ContextIdentifier []string

	// Filters tasks by the identifiers of the engagements from which opportunities
	// are being created. Use this to find all opportunity creation tasks associated
	// with a specific engagement.
	EngagementIdentifier []string

	// Specifies the maximum number of results to return in a single page of the
	// response. Use this parameter to control the number of items returned in each
	// request, which can be useful for performance tuning and managing large result
	// sets.
	MaxResults *int32

	// The token for requesting the next page of results. This value is obtained from
	// the NextToken field in the response of a previous call to this API. Use this
	// parameter for pagination when the result set spans multiple pages.
	NextToken *string

	// Filters tasks by the identifiers of the opportunities they created or are
	// associated with. Use this to find tasks related to specific opportunity creation
	// processes.
	OpportunityIdentifier []string

	//  Defines the sorting parameters for listing tasks. This structure allows for
	// specifying the field to sort by and the order of sorting.
	Sort *types.ListTasksSortBase

	// Filters tasks by their unique identifiers. Use this when you want to retrieve
	// information about specific tasks. Provide the task ID to get details about a
	// particular opportunity creation task.
	TaskIdentifier []string

	// Filters the tasks based on their current status. This allows you to focus on
	// tasks in specific states. Valid values are COMPLETE for tasks that have
	// finished successfully, INPROGRESS for tasks that are currently running, and
	// FAILED for tasks that have encountered an error and failed to complete.
	TaskStatus []types.TaskStatus

	noSmithyDocumentSerde
}

type ListOpportunityFromEngagementTasksOutput struct {

	// A token used for pagination to retrieve the next page of results. If there are
	// more results available, this field will contain a token that can be used in a
	// subsequent API call to retrieve the next page. If there are no more results,
	// this field will be null or an empty string.
	NextToken *string

	// An array of ListOpportunityFromEngagementTaskSummary objects, each representing
	// a task that matches the specified filters. The array may be empty if no tasks
	// match the criteria.
	TaskSummaries []types.ListOpportunityFromEngagementTaskSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOpportunityFromEngagementTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListOpportunityFromEngagementTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListOpportunityFromEngagementTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOpportunityFromEngagementTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListOpportunityFromEngagementTasksValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOpportunityFromEngagementTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOpportunityFromEngagementTasksPaginatorOptions is the paginator options for
// ListOpportunityFromEngagementTasks
type ListOpportunityFromEngagementTasksPaginatorOptions struct {
	// Specifies the maximum number of results to return in a single page of the
	// response. Use this parameter to control the number of items returned in each
	// request, which can be useful for performance tuning and managing large result
	// sets.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOpportunityFromEngagementTasksPaginator is a paginator for
// ListOpportunityFromEngagementTasks
type ListOpportunityFromEngagementTasksPaginator struct {
	options   ListOpportunityFromEngagementTasksPaginatorOptions
	client    ListOpportunityFromEngagementTasksAPIClient
	params    *ListOpportunityFromEngagementTasksInput
	nextToken *string
	firstPage bool
}

// NewListOpportunityFromEngagementTasksPaginator returns a new
// ListOpportunityFromEngagementTasksPaginator
func NewListOpportunityFromEngagementTasksPaginator(client ListOpportunityFromEngagementTasksAPIClient, params *ListOpportunityFromEngagementTasksInput, optFns ...func(*ListOpportunityFromEngagementTasksPaginatorOptions)) *ListOpportunityFromEngagementTasksPaginator {
	if params == nil {
		params = &ListOpportunityFromEngagementTasksInput{}
	}

	options := ListOpportunityFromEngagementTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOpportunityFromEngagementTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOpportunityFromEngagementTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOpportunityFromEngagementTasks page.
func (p *ListOpportunityFromEngagementTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOpportunityFromEngagementTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOpportunityFromEngagementTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOpportunityFromEngagementTasksAPIClient is a client that implements the
// ListOpportunityFromEngagementTasks operation.
type ListOpportunityFromEngagementTasksAPIClient interface {
	ListOpportunityFromEngagementTasks(context.Context, *ListOpportunityFromEngagementTasksInput, ...func(*Options)) (*ListOpportunityFromEngagementTasksOutput, error)
}

var _ ListOpportunityFromEngagementTasksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOpportunityFromEngagementTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOpportunityFromEngagementTasks",
	}
}
