// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Use this action to retrieves information about a specific resource snapshot job.
func (c *Client) GetResourceSnapshotJob(ctx context.Context, params *GetResourceSnapshotJobInput, optFns ...func(*Options)) (*GetResourceSnapshotJobOutput, error) {
	if params == nil {
		params = &GetResourceSnapshotJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceSnapshotJob", params, optFns, c.addOperationGetResourceSnapshotJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceSnapshotJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceSnapshotJobInput struct {

	// Specifies the catalog related to the request. Valid values are:
	//
	//   - AWS: Retrieves the snapshot job from the production AWS environment.
	//
	//   - Sandbox: Retrieves the snapshot job from a sandbox environment used for
	//   testing or development purposes.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the resource snapshot job to be retrieved. This
	// identifier is crucial for pinpointing the specific job you want to query.
	//
	// This member is required.
	ResourceSnapshotJobIdentifier *string

	noSmithyDocumentSerde
}

type GetResourceSnapshotJobOutput struct {

	// The catalog in which the snapshot job was created. This will match the Catalog
	// specified in the request.
	//
	// This member is required.
	Catalog *string

	// The Amazon Resource Name (ARN) of the snapshot job. This globally unique
	// identifier can be used for resource-specific operations across AWS services.
	Arn *string

	// The date and time when the snapshot job was created in ISO 8601 format (UTC).
	// Example: "2023-05-01T20:37:46Z"
	CreatedAt *time.Time

	// The identifier of the engagement associated with this snapshot job. This links
	// the job to a specific engagement context.
	EngagementId *string

	// The unique identifier of the snapshot job. This matches the
	// ResourceSnapshotJobIdentifier provided in the request.
	Id *string

	// If the job has encountered any failures, this field contains the error message
	// from the most recent failure. This can be useful for troubleshooting issues with
	// the job.
	LastFailure *string

	// The date and time of the last successful execution of the job, in ISO 8601
	// format (UTC). Example: "2023-05-01T20:37:46Z"
	LastSuccessfulExecutionDate *time.Time

	// The Amazon Resource Name (ARN) of the resource being snapshotted. This provides
	// a globally unique identifier for the resource across AWS.
	ResourceArn *string

	// The identifier of the specific resource being snapshotted. The format might
	// vary depending on the ResourceType.
	ResourceId *string

	// The name of the template used for creating the snapshot. This is the same as
	// the template name. It defines the structure and content of the snapshot.
	ResourceSnapshotTemplateName *string

	// The type of resource being snapshotted. This would have "Opportunity" as a
	// value as it is dependent on the supported resource type.
	ResourceType types.ResourceType

	// The current status of the snapshot job. Valid values:
	//
	//   - STOPPED: The job is not currently running.
	//
	//   - RUNNING: The job is actively executing.
	Status types.ResourceSnapshotJobStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceSnapshotJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetResourceSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetResourceSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetResourceSnapshotJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetResourceSnapshotJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceSnapshotJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetResourceSnapshotJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetResourceSnapshotJob",
	}
}
