// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralchannel

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralchannel/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists partner relationships based on specified criteria.
func (c *Client) ListRelationships(ctx context.Context, params *ListRelationshipsInput, optFns ...func(*Options)) (*ListRelationshipsOutput, error) {
	if params == nil {
		params = &ListRelationshipsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRelationships", params, optFns, c.addOperationListRelationshipsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRelationshipsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRelationshipsInput struct {

	// The catalog identifier to filter relationships.
	//
	// This member is required.
	Catalog *string

	// Filter by associated AWS account IDs.
	AssociatedAccountIds []string

	// Filter by association types.
	AssociationTypes []types.AssociationType

	// Filter by display names.
	DisplayNames []string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// Token for retrieving the next page of results.
	NextToken *string

	// Filter by program management account identifiers.
	ProgramManagementAccountIdentifiers []string

	// Sorting options for the results.
	Sort *types.ListRelationshipsSortBase

	noSmithyDocumentSerde
}

type ListRelationshipsOutput struct {

	// List of relationships matching the criteria.
	Items []types.RelationshipSummary

	// Token for retrieving the next page of results, if available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRelationshipsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListRelationships{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListRelationships{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRelationships"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRelationshipsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRelationships(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRelationshipsPaginatorOptions is the paginator options for ListRelationships
type ListRelationshipsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRelationshipsPaginator is a paginator for ListRelationships
type ListRelationshipsPaginator struct {
	options   ListRelationshipsPaginatorOptions
	client    ListRelationshipsAPIClient
	params    *ListRelationshipsInput
	nextToken *string
	firstPage bool
}

// NewListRelationshipsPaginator returns a new ListRelationshipsPaginator
func NewListRelationshipsPaginator(client ListRelationshipsAPIClient, params *ListRelationshipsInput, optFns ...func(*ListRelationshipsPaginatorOptions)) *ListRelationshipsPaginator {
	if params == nil {
		params = &ListRelationshipsInput{}
	}

	options := ListRelationshipsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRelationshipsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRelationshipsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRelationships page.
func (p *ListRelationshipsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRelationshipsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRelationships(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRelationshipsAPIClient is a client that implements the ListRelationships
// operation.
type ListRelationshipsAPIClient interface {
	ListRelationships(context.Context, *ListRelationshipsInput, ...func(*Options)) (*ListRelationshipsOutput, error)
}

var _ ListRelationshipsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRelationships(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRelationships",
	}
}
