// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about access-based benefit fulfillment, such as service
// permissions or feature access.
type AccessDetails struct {

	// A description of the access privileges or permissions granted by this benefit.
	Description *string

	noSmithyDocumentSerde
}

// Represents a specific change to be made to a benefit application field.
type Amendment struct {

	// The JSON path or field identifier specifying which field in the benefit
	// application to modify.
	//
	// This member is required.
	FieldPath *string

	// The new value to set for the specified field in the benefit application.
	//
	// This member is required.
	NewValue *string

	noSmithyDocumentSerde
}

// Represents an AWS resource that is associated with a benefit application for
// tracking and management.
type AssociatedResource struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the AWS resource.
	ResourceArn *string

	// The unique identifier of the AWS resource within its service.
	//
	// Deprecated: This field is no longer used
	ResourceIdentifier *string

	// The type of AWS resource (e.g., EC2 instance, S3 bucket, Lambda function).
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// A summary view of a benefit allocation containing key information for list
// operations.
type BenefitAllocationSummary struct {

	// The identifiers of the benefits applicable for this allocation.
	ApplicableBenefitIds []string

	// The Amazon Resource Name (ARN) of the benefit allocation.
	Arn *string

	// The identifier of the benefit application that resulted in this allocation.
	BenefitApplicationId *string

	// The identifier of the benefit that this allocation is based on.
	BenefitId *string

	// The catalog identifier that the benefit allocation belongs to.
	Catalog *string

	// The timestamp when the benefit allocation was created.
	CreatedAt *time.Time

	// The timestamp when the benefit allocation expires.
	ExpiresAt *time.Time

	// The fulfillment types used for this benefit allocation.
	FulfillmentTypes []FulfillmentType

	// The unique identifier of the benefit allocation.
	Id *string

	// The human-readable name of the benefit allocation.
	Name *string

	// The current status of the benefit allocation.
	Status BenefitAllocationStatus

	// Additional information explaining the current status of the benefit allocation.
	StatusReason *string

	noSmithyDocumentSerde
}

// A summary view of a benefit application containing key information for list
// operations.
type BenefitApplicationSummary struct {

	// The Amazon Resource Name (ARN) of the benefit application.
	Arn *string

	// AWS resources that are associated with this benefit application.
	AssociatedResources []string

	// Additional attributes and metadata associated with the benefit application.
	BenefitApplicationDetails map[string]string

	// The identifier of the benefit being requested in this application.
	BenefitId *string

	// The catalog identifier that the benefit application belongs to.
	Catalog *string

	// The timestamp when the benefit application was created.
	CreatedAt *time.Time

	// The fulfillment types requested for this benefit application.
	FulfillmentTypes []FulfillmentType

	// The unique identifier of the benefit application.
	Id *string

	// The human-readable name of the benefit application.
	Name *string

	// The AWS partner programs associated with this benefit application.
	Programs []string

	// The current stage in the benefit application processing workflow..
	Stage *string

	// The current processing status of the benefit application.
	Status BenefitApplicationStatus

	// The timestamp when the benefit application was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// A summary view of a benefit containing key information for list operations.
type BenefitSummary struct {

	// The Amazon Resource Name (ARN) of the benefit.
	Arn *string

	// The catalog identifier that the benefit belongs to.
	Catalog *string

	// A brief description of the benefit and its purpose.
	Description *string

	// The available fulfillment types for this benefit.
	FulfillmentTypes []FulfillmentType

	// The unique identifier of the benefit.
	Id *string

	// The human-readable name of the benefit.
	Name *string

	// The AWS partner programs that this benefit is associated with.
	Programs []string

	// The current status of the benefit.
	Status BenefitStatus

	noSmithyDocumentSerde
}

// Contains information about consumable benefit fulfillment, such as usage quotas
// or service limits.
type ConsumableDetails struct {

	// The total amount of the consumable benefit that has been allocated.
	AllocatedAmount *MonetaryValue

	// Detailed information about how the consumable benefit was issued and
	// distributed.
	IssuanceDetails *IssuanceDetail

	// The remaining amount of the consumable benefit that is still available for use.
	RemainingAmount *MonetaryValue

	// The amount of the consumable benefit that has already been used.
	UtilizedAmount *MonetaryValue

	noSmithyDocumentSerde
}

// Represents contact information for a partner representative.
type Contact struct {

	// The business title or role of the contact person within the organization.
	BusinessTitle *string

	// The email address of the contact person.
	Email *string

	// The first name of the contact person.
	FirstName *string

	// The last name of the contact person.
	LastName *string

	// The phone number of the contact person.
	Phone *string

	noSmithyDocumentSerde
}

// Represents an AWS credit code that can be applied to an AWS account for billing
// purposes.
type CreditCode struct {

	// The AWS account ID that the credit code is associated with or can be applied to.
	//
	// This member is required.
	AwsAccountId *string

	// The actual credit code string that can be redeemed in the AWS billing console.
	//
	// This member is required.
	AwsCreditCode *string

	// The timestamp when the credit code expires and can no longer be redeemed.
	//
	// This member is required.
	ExpiresAt *time.Time

	// The timestamp when the credit code was issued.
	//
	// This member is required.
	IssuedAt *time.Time

	// The current status of the credit code (e.g., active, redeemed, expired).
	//
	// This member is required.
	Status BenefitAllocationStatus

	// The monetary value of the credit code.
	//
	// This member is required.
	Value *MonetaryValue

	noSmithyDocumentSerde
}

// Contains information about credit-based benefit fulfillment, including AWS
// promotional credits.
type CreditDetails struct {

	// The total amount of credits that have been allocated for this benefit.
	//
	// This member is required.
	AllocatedAmount *MonetaryValue

	// A list of credit codes that have been generated for this benefit allocation.
	//
	// This member is required.
	Codes []CreditCode

	// The amount of credits that have actually been issued and are available for use.
	//
	// This member is required.
	IssuedAmount *MonetaryValue

	noSmithyDocumentSerde
}

// Contains information about disbursement-based benefit fulfillment, such as
// direct payments or reimbursements.
type DisbursementDetails struct {

	// The total amount that has been disbursed for this benefit allocation.
	DisbursedAmount *MonetaryValue

	// Detailed information about how the disbursement was issued and processed.
	IssuanceDetails *IssuanceDetail

	noSmithyDocumentSerde
}

// Represents detailed information about a file attached to a benefit application.
type FileDetail struct {

	// The URI or location where the file is stored.
	//
	// This member is required.
	FileURI *string

	// The business purpose or use case that this file supports in the benefit
	// application.
	BusinessUseCase *string

	// The timestamp when the file was uploaded.
	CreatedAt *time.Time

	// The identifier of the user who uploaded the file.
	CreatedBy *string

	// The original name of the uploaded file.
	FileName *string

	// The current processing status of the file (e.g., uploaded, processing,
	// approved, rejected).
	FileStatus *string

	// The reason for that particulat file status.
	FileStatusReason *string

	// The type or category of the file (e.g., document, image, spreadsheet).
	FileType FileType

	noSmithyDocumentSerde
}

// Represents input information for uploading a file to a benefit application.
type FileInput struct {

	// The URI or location where the file should be stored or has been uploaded.
	//
	// This member is required.
	FileURI *string

	// The business purpose or use case that this file supports in the benefit
	// application.
	BusinessUseCase *string

	noSmithyDocumentSerde
}

// Contains comprehensive information about how a benefit allocation is fulfilled
// across different fulfillment types.
//
// The following types satisfy this interface:
//
//	FulfillmentDetailsMemberAccessDetails
//	FulfillmentDetailsMemberConsumableDetails
//	FulfillmentDetailsMemberCreditDetails
//	FulfillmentDetailsMemberDisbursementDetails
type FulfillmentDetails interface {
	isFulfillmentDetails()
}

// Details about access-based fulfillment, if applicable to this benefit
// allocation.
type FulfillmentDetailsMemberAccessDetails struct {
	Value AccessDetails

	noSmithyDocumentSerde
}

func (*FulfillmentDetailsMemberAccessDetails) isFulfillmentDetails() {}

// Details about consumable-based fulfillment, if applicable to this benefit
// allocation.
type FulfillmentDetailsMemberConsumableDetails struct {
	Value ConsumableDetails

	noSmithyDocumentSerde
}

func (*FulfillmentDetailsMemberConsumableDetails) isFulfillmentDetails() {}

// Details about credit-based fulfillment, if applicable to this benefit
// allocation.
type FulfillmentDetailsMemberCreditDetails struct {
	Value CreditDetails

	noSmithyDocumentSerde
}

func (*FulfillmentDetailsMemberCreditDetails) isFulfillmentDetails() {}

// Details about disbursement-based fulfillment, if applicable to this benefit
// allocation.
type FulfillmentDetailsMemberDisbursementDetails struct {
	Value DisbursementDetails

	noSmithyDocumentSerde
}

func (*FulfillmentDetailsMemberDisbursementDetails) isFulfillmentDetails() {}

// Represents detailed information about a specific issuance of benefit value.
type IssuanceDetail struct {

	// The monetary amount or value that was issued in this specific issuance.
	IssuanceAmount *MonetaryValue

	// The unique identifier for this specific issuance.
	IssuanceId *string

	// The timestamp when this specific issuance was processed.
	IssuedAt *time.Time

	noSmithyDocumentSerde
}

// Represents a monetary amount with its associated currency.
type MonetaryValue struct {

	// The numeric amount of the monetary value.
	//
	// This member is required.
	Amount *string

	// The ISO 4217 currency code (e.g., USD, EUR) for the monetary amount.
	//
	// This member is required.
	CurrencyCode CurrencyCode

	noSmithyDocumentSerde
}

// Represents a key-value pair used for categorizing and organizing AWS resources.
type Tag struct {

	// The tag key, which acts as a category or label for the tag.
	//
	// This member is required.
	Key *string

	// The tag value, which provides additional information or context for the tag key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Represents a field-specific validation error with detailed information.
type ValidationExceptionField struct {

	// A detailed message explaining why the field validation failed.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	// An error code explaining why the field validation failed.
	Code ValidationExceptionErrorCode

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isFulfillmentDetails() {}
