// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a paginated list of benefit applications based on specified filter
// criteria.
func (c *Client) ListBenefitApplications(ctx context.Context, params *ListBenefitApplicationsInput, optFns ...func(*Options)) (*ListBenefitApplicationsOutput, error) {
	if params == nil {
		params = &ListBenefitApplicationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBenefitApplications", params, optFns, c.addOperationListBenefitApplicationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBenefitApplicationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBenefitApplicationsInput struct {

	// The catalog identifier to filter benefit applications by catalog.
	//
	// This member is required.
	Catalog *string

	// Filter benefit applications by specific AWS resource ARNs.
	AssociatedResourceArns []string

	// Filter benefit applications by associated AWS resources.
	//
	// Deprecated: This field is no longer used.
	AssociatedResources []types.AssociatedResource

	// Filter benefit applications by specific benefit identifiers.
	BenefitIdentifiers []string

	// Filter benefit applications by specific fulfillment types.
	FulfillmentTypes []types.FulfillmentType

	// The maximum number of benefit applications to return in a single response.
	MaxResults *int32

	// A pagination token to retrieve the next set of results from a previous request.
	NextToken *string

	// Filter benefit applications by specific AWS partner programs.
	Programs []string

	// Filter benefit applications by their current processing stage.
	Stages []string

	// Filter benefit applications by their current processing status.
	Status []types.BenefitApplicationStatus

	noSmithyDocumentSerde
}

type ListBenefitApplicationsOutput struct {

	// A list of benefit application summaries matching the specified criteria.
	BenefitApplicationSummaries []types.BenefitApplicationSummary

	// A pagination token to retrieve the next set of results, if more results are
	// available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBenefitApplicationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBenefitApplications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBenefitApplications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBenefitApplications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBenefitApplicationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBenefitApplications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBenefitApplicationsPaginatorOptions is the paginator options for
// ListBenefitApplications
type ListBenefitApplicationsPaginatorOptions struct {
	// The maximum number of benefit applications to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBenefitApplicationsPaginator is a paginator for ListBenefitApplications
type ListBenefitApplicationsPaginator struct {
	options   ListBenefitApplicationsPaginatorOptions
	client    ListBenefitApplicationsAPIClient
	params    *ListBenefitApplicationsInput
	nextToken *string
	firstPage bool
}

// NewListBenefitApplicationsPaginator returns a new
// ListBenefitApplicationsPaginator
func NewListBenefitApplicationsPaginator(client ListBenefitApplicationsAPIClient, params *ListBenefitApplicationsInput, optFns ...func(*ListBenefitApplicationsPaginatorOptions)) *ListBenefitApplicationsPaginator {
	if params == nil {
		params = &ListBenefitApplicationsInput{}
	}

	options := ListBenefitApplicationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBenefitApplicationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBenefitApplicationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBenefitApplications page.
func (p *ListBenefitApplicationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBenefitApplicationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBenefitApplications(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBenefitApplicationsAPIClient is a client that implements the
// ListBenefitApplications operation.
type ListBenefitApplicationsAPIClient interface {
	ListBenefitApplications(context.Context, *ListBenefitApplicationsInput, ...func(*Options)) (*ListBenefitApplicationsOutput, error)
}

var _ ListBenefitApplicationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBenefitApplications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBenefitApplications",
	}
}
