// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a paginated list of benefit allocations based on specified filter
// criteria.
func (c *Client) ListBenefitAllocations(ctx context.Context, params *ListBenefitAllocationsInput, optFns ...func(*Options)) (*ListBenefitAllocationsOutput, error) {
	if params == nil {
		params = &ListBenefitAllocationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBenefitAllocations", params, optFns, c.addOperationListBenefitAllocationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBenefitAllocationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBenefitAllocationsInput struct {

	// The catalog identifier to filter benefit allocations by catalog.
	//
	// This member is required.
	Catalog *string

	// Filter benefit allocations by specific benefit application identifiers.
	BenefitApplicationIdentifiers []string

	// Filter benefit allocations by specific benefit identifiers.
	BenefitIdentifiers []string

	// Filter benefit allocations by specific fulfillment types.
	FulfillmentTypes []types.FulfillmentType

	// The maximum number of benefit allocations to return in a single response.
	MaxResults *int32

	// A pagination token to retrieve the next set of results from a previous request.
	NextToken *string

	// Filter benefit allocations by their current status.
	Status []types.BenefitAllocationStatus

	noSmithyDocumentSerde
}

type ListBenefitAllocationsOutput struct {

	// A list of benefit allocation summaries matching the specified criteria.
	BenefitAllocationSummaries []types.BenefitAllocationSummary

	// A pagination token to retrieve the next set of results, if more results are
	// available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBenefitAllocationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBenefitAllocations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBenefitAllocations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBenefitAllocations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBenefitAllocationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBenefitAllocations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBenefitAllocationsPaginatorOptions is the paginator options for
// ListBenefitAllocations
type ListBenefitAllocationsPaginatorOptions struct {
	// The maximum number of benefit allocations to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBenefitAllocationsPaginator is a paginator for ListBenefitAllocations
type ListBenefitAllocationsPaginator struct {
	options   ListBenefitAllocationsPaginatorOptions
	client    ListBenefitAllocationsAPIClient
	params    *ListBenefitAllocationsInput
	nextToken *string
	firstPage bool
}

// NewListBenefitAllocationsPaginator returns a new ListBenefitAllocationsPaginator
func NewListBenefitAllocationsPaginator(client ListBenefitAllocationsAPIClient, params *ListBenefitAllocationsInput, optFns ...func(*ListBenefitAllocationsPaginatorOptions)) *ListBenefitAllocationsPaginator {
	if params == nil {
		params = &ListBenefitAllocationsInput{}
	}

	options := ListBenefitAllocationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBenefitAllocationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBenefitAllocationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBenefitAllocations page.
func (p *ListBenefitAllocationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBenefitAllocationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBenefitAllocations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBenefitAllocationsAPIClient is a client that implements the
// ListBenefitAllocations operation.
type ListBenefitAllocationsAPIClient interface {
	ListBenefitAllocations(context.Context, *ListBenefitAllocationsInput, ...func(*Options)) (*ListBenefitAllocationsOutput, error)
}

var _ ListBenefitAllocationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBenefitAllocations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBenefitAllocations",
	}
}
