// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/document"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific benefit application.
func (c *Client) GetBenefitApplication(ctx context.Context, params *GetBenefitApplicationInput, optFns ...func(*Options)) (*GetBenefitApplicationOutput, error) {
	if params == nil {
		params = &GetBenefitApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBenefitApplication", params, optFns, c.addOperationGetBenefitApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBenefitApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBenefitApplicationInput struct {

	// The catalog identifier that specifies which benefit catalog to query.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the benefit application to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetBenefitApplicationOutput struct {

	// The Amazon Resource Name (ARN) of the benefit application.
	Arn *string

	// AWS resources that are associated with this benefit application.
	AssociatedResources []string

	// Detailed information and requirements specific to the benefit being requested.
	BenefitApplicationDetails document.Interface

	// The identifier of the benefit being requested in this application.
	BenefitId *string

	// The catalog identifier that the benefit application belongs to.
	Catalog *string

	// The timestamp when the benefit application was created.
	CreatedAt *time.Time

	// A detailed description of the benefit application.
	Description *string

	// Supporting documents and files attached to the benefit application.
	FileDetails []types.FileDetail

	// The fulfillment types requested for this benefit application.
	FulfillmentTypes []types.FulfillmentType

	// The unique identifier of the benefit application.
	Id *string

	// The human-readable name of the benefit application.
	Name *string

	// Contact information for partner representatives responsible for this benefit
	// application.
	PartnerContacts []types.Contact

	// The AWS partner programs associated with this benefit application.
	Programs []string

	// The current revision number of the benefit application.
	Revision *string

	// The current stage in the benefit application processing workflow.
	Stage *string

	// The current processing status of the benefit application.
	Status types.BenefitApplicationStatus

	// Additional information explaining the current status of the benefit application.
	StatusReason *string

	// A standardized code representing the reason for the current status.
	//
	// Deprecated: This field is no longer used
	StatusReasonCode *string

	// The list of standardized codes representing the reason for the current status.
	StatusReasonCodes []string

	// The timestamp when the benefit application was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBenefitApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBenefitApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBenefitApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBenefitApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBenefitApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBenefitApplication",
	}
}
