// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific benefit allocation that has
// been granted to a partner.
func (c *Client) GetBenefitAllocation(ctx context.Context, params *GetBenefitAllocationInput, optFns ...func(*Options)) (*GetBenefitAllocationOutput, error) {
	if params == nil {
		params = &GetBenefitAllocationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBenefitAllocation", params, optFns, c.addOperationGetBenefitAllocationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBenefitAllocationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBenefitAllocationInput struct {

	// The catalog identifier that specifies which benefit catalog to query.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the benefit allocation to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetBenefitAllocationOutput struct {

	// A list of benefit identifiers that this allocation can be applied to.
	ApplicableBenefitIds []string

	// The Amazon Resource Name (ARN) of the benefit allocation.
	Arn *string

	// The identifier of the benefit application that resulted in this allocation.
	BenefitApplicationId *string

	// The identifier of the benefit that this allocation is based on.
	BenefitId *string

	// The catalog identifier that the benefit allocation belongs to.
	Catalog *string

	// The timestamp when the benefit allocation was created.
	CreatedAt *time.Time

	// A detailed description of the benefit allocation.
	Description *string

	// The timestamp when the benefit allocation expires and is no longer usable.
	ExpiresAt *time.Time

	// Detailed information about how the benefit allocation is fulfilled.
	FulfillmentDetail types.FulfillmentDetails

	// The fulfillment type used for this benefit allocation.
	FulfillmentType types.FulfillmentType

	// The unique identifier of the benefit allocation.
	Id *string

	// The human-readable name of the benefit allocation.
	Name *string

	// The timestamp when the benefit allocation becomes active and usable.
	StartsAt *time.Time

	// The current status of the benefit allocation (e.g., active, expired, consumed).
	Status types.BenefitAllocationStatus

	// Additional information explaining the current status of the benefit allocation.
	StatusReason *string

	// The timestamp when the benefit allocation was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBenefitAllocationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetBenefitAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetBenefitAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBenefitAllocation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBenefitAllocationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBenefitAllocation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBenefitAllocation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBenefitAllocation",
	}
}
