// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes the association between an AWS resource and a benefit application.
func (c *Client) DisassociateBenefitApplicationResource(ctx context.Context, params *DisassociateBenefitApplicationResourceInput, optFns ...func(*Options)) (*DisassociateBenefitApplicationResourceOutput, error) {
	if params == nil {
		params = &DisassociateBenefitApplicationResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateBenefitApplicationResource", params, optFns, c.addOperationDisassociateBenefitApplicationResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateBenefitApplicationResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateBenefitApplicationResourceInput struct {

	// The unique identifier of the benefit application to disassociate the resource
	// from.
	//
	// This member is required.
	BenefitApplicationIdentifier *string

	// The catalog identifier that specifies which benefit catalog the application
	// belongs to.
	//
	// This member is required.
	Catalog *string

	// The Amazon Resource Name (ARN) of the AWS resource to disassociate from the
	// benefit application.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

type DisassociateBenefitApplicationResourceOutput struct {

	// The Amazon Resource Name (ARN) of the benefit application after the resource
	// disassociation.
	Arn *string

	// The unique identifier of the benefit application after the resource
	// disassociation.
	Id *string

	// The updated revision number of the benefit application after the resource
	// disassociation.
	Revision *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateBenefitApplicationResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDisassociateBenefitApplicationResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDisassociateBenefitApplicationResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateBenefitApplicationResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateBenefitApplicationResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateBenefitApplicationResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisassociateBenefitApplicationResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateBenefitApplicationResource",
	}
}
