// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Links an AWS resource to an existing benefit application for tracking and
// management purposes.
func (c *Client) AssociateBenefitApplicationResource(ctx context.Context, params *AssociateBenefitApplicationResourceInput, optFns ...func(*Options)) (*AssociateBenefitApplicationResourceOutput, error) {
	if params == nil {
		params = &AssociateBenefitApplicationResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateBenefitApplicationResource", params, optFns, c.addOperationAssociateBenefitApplicationResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateBenefitApplicationResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateBenefitApplicationResourceInput struct {

	// The unique identifier of the benefit application to associate the resource with.
	//
	// This member is required.
	BenefitApplicationIdentifier *string

	// The catalog identifier that specifies which benefit catalog the application
	// belongs to.
	//
	// This member is required.
	Catalog *string

	// The Amazon Resource Name (ARN) of the AWS resource to associate with the
	// benefit application.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

type AssociateBenefitApplicationResourceOutput struct {

	// The Amazon Resource Name (ARN) of the benefit application after the resource
	// association.
	Arn *string

	// The unique identifier of the benefit application after the resource association.
	Id *string

	// The updated revision number of the benefit application after the resource
	// association.
	Revision *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateBenefitApplicationResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAssociateBenefitApplicationResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAssociateBenefitApplicationResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateBenefitApplicationResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateBenefitApplicationResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateBenefitApplicationResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateBenefitApplicationResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateBenefitApplicationResource",
	}
}
