// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies an existing benefit application by applying amendments to specific
// fields while maintaining revision control.
func (c *Client) AmendBenefitApplication(ctx context.Context, params *AmendBenefitApplicationInput, optFns ...func(*Options)) (*AmendBenefitApplicationOutput, error) {
	if params == nil {
		params = &AmendBenefitApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AmendBenefitApplication", params, optFns, c.addOperationAmendBenefitApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AmendBenefitApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AmendBenefitApplicationInput struct {

	// A descriptive reason explaining why the benefit application is being amended.
	//
	// This member is required.
	AmendmentReason *string

	// A list of specific field amendments to apply to the benefit application.
	//
	// This member is required.
	Amendments []types.Amendment

	// The catalog identifier that specifies which benefit catalog the application
	// belongs to.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier to ensure idempotent processing of the
	// amendment request.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the benefit application to be amended.
	//
	// This member is required.
	Identifier *string

	// The current revision number of the benefit application to ensure optimistic
	// concurrency control.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

type AmendBenefitApplicationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAmendBenefitApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAmendBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAmendBenefitApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AmendBenefitApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAmendBenefitApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAmendBenefitApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAmendBenefitApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AmendBenefitApplication",
	}
}
