// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Initiates a profile update task to modify partner profile information
// asynchronously.
func (c *Client) StartProfileUpdateTask(ctx context.Context, params *StartProfileUpdateTaskInput, optFns ...func(*Options)) (*StartProfileUpdateTaskOutput, error) {
	if params == nil {
		params = &StartProfileUpdateTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartProfileUpdateTask", params, optFns, c.addOperationStartProfileUpdateTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartProfileUpdateTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartProfileUpdateTaskInput struct {

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Identifier *string

	// The details of the profile updates to be performed.
	//
	// This member is required.
	TaskDetails *types.TaskDetails

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	noSmithyDocumentSerde
}

type StartProfileUpdateTaskOutput struct {

	// The Amazon Resource Name (ARN) of the started profile update task.
	//
	// This member is required.
	Arn *string

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Id *string

	// The timestamp when the profile update task was started.
	//
	// This member is required.
	StartedAt *time.Time

	// The current status of the profile update task (in progress).
	//
	// This member is required.
	Status types.ProfileTaskStatus

	// The details of the profile update task that was started.
	//
	// This member is required.
	TaskDetails *types.TaskDetails

	// The unique identifier of the started profile update task.
	//
	// This member is required.
	TaskId *string

	// The timestamp when the profile update task ended (null for in-progress tasks).
	EndedAt *time.Time

	// A list of error details if any errors occurred during the profile update task.
	ErrorDetailList []types.ErrorDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartProfileUpdateTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartProfileUpdateTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartProfileUpdateTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartProfileUpdateTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartProfileUpdateTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartProfileUpdateTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartProfileUpdateTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartProfileUpdateTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartProfileUpdateTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartProfileUpdateTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartProfileUpdateTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartProfileUpdateTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartProfileUpdateTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartProfileUpdateTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartProfileUpdateTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartProfileUpdateTask",
	}
}
