// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the settings of an Oracle Database@Amazon Web Services peering
// connection. You can update the display name and add or remove CIDR blocks from
// the peering connection.
func (c *Client) UpdateOdbPeeringConnection(ctx context.Context, params *UpdateOdbPeeringConnectionInput, optFns ...func(*Options)) (*UpdateOdbPeeringConnectionOutput, error) {
	if params == nil {
		params = &UpdateOdbPeeringConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOdbPeeringConnection", params, optFns, c.addOperationUpdateOdbPeeringConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOdbPeeringConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOdbPeeringConnectionInput struct {

	// The identifier of the Oracle Database@Amazon Web Services peering connection to
	// update.
	//
	// This member is required.
	OdbPeeringConnectionId *string

	// A new display name for the peering connection.
	DisplayName *string

	// A list of CIDR blocks to add to the peering connection. These CIDR blocks
	// define the IP address ranges that can communicate through the peering
	// connection. The CIDR blocks must not overlap with existing CIDR blocks in the
	// Oracle Database@Amazon Web Services network.
	PeerNetworkCidrsToBeAdded []string

	// A list of CIDR blocks to remove from the peering connection. The CIDR blocks
	// must currently exist in the peering connection.
	PeerNetworkCidrsToBeRemoved []string

	noSmithyDocumentSerde
}

type UpdateOdbPeeringConnectionOutput struct {

	// The identifier of the Oracle Database@Amazon Web Services peering connection
	// that was updated.
	//
	// This member is required.
	OdbPeeringConnectionId *string

	// The display name of the peering connection.
	DisplayName *string

	// The status of the peering connection update operation.
	Status types.ResourceStatus

	// Additional information about the status of the peering connection update
	// operation.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOdbPeeringConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateOdbPeeringConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateOdbPeeringConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateOdbPeeringConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateOdbPeeringConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOdbPeeringConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateOdbPeeringConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateOdbPeeringConnection",
	}
}
