// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
func (c *Client) ListCloudAutonomousVmClusters(ctx context.Context, params *ListCloudAutonomousVmClustersInput, optFns ...func(*Options)) (*ListCloudAutonomousVmClustersOutput, error) {
	if params == nil {
		params = &ListCloudAutonomousVmClustersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCloudAutonomousVmClusters", params, optFns, c.addOperationListCloudAutonomousVmClustersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCloudAutonomousVmClustersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCloudAutonomousVmClustersInput struct {

	// The unique identifier of the Cloud Exadata Infrastructure that hosts the
	// Autonomous VM clusters to be listed.
	CloudExadataInfrastructureId *string

	// The maximum number of items to return per page.
	MaxResults *int32

	// The pagination token to continue listing from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCloudAutonomousVmClustersOutput struct {

	// The list of Autonomous VM clusters in the specified Cloud Exadata
	// Infrastructure.
	//
	// This member is required.
	CloudAutonomousVmClusters []types.CloudAutonomousVmClusterSummary

	// The pagination token to continue listing from.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCloudAutonomousVmClustersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListCloudAutonomousVmClusters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListCloudAutonomousVmClusters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCloudAutonomousVmClusters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCloudAutonomousVmClusters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCloudAutonomousVmClustersPaginatorOptions is the paginator options for
// ListCloudAutonomousVmClusters
type ListCloudAutonomousVmClustersPaginatorOptions struct {
	// The maximum number of items to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCloudAutonomousVmClustersPaginator is a paginator for
// ListCloudAutonomousVmClusters
type ListCloudAutonomousVmClustersPaginator struct {
	options   ListCloudAutonomousVmClustersPaginatorOptions
	client    ListCloudAutonomousVmClustersAPIClient
	params    *ListCloudAutonomousVmClustersInput
	nextToken *string
	firstPage bool
}

// NewListCloudAutonomousVmClustersPaginator returns a new
// ListCloudAutonomousVmClustersPaginator
func NewListCloudAutonomousVmClustersPaginator(client ListCloudAutonomousVmClustersAPIClient, params *ListCloudAutonomousVmClustersInput, optFns ...func(*ListCloudAutonomousVmClustersPaginatorOptions)) *ListCloudAutonomousVmClustersPaginator {
	if params == nil {
		params = &ListCloudAutonomousVmClustersInput{}
	}

	options := ListCloudAutonomousVmClustersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCloudAutonomousVmClustersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCloudAutonomousVmClustersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCloudAutonomousVmClusters page.
func (p *ListCloudAutonomousVmClustersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCloudAutonomousVmClustersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCloudAutonomousVmClusters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCloudAutonomousVmClustersAPIClient is a client that implements the
// ListCloudAutonomousVmClusters operation.
type ListCloudAutonomousVmClustersAPIClient interface {
	ListCloudAutonomousVmClusters(context.Context, *ListCloudAutonomousVmClustersInput, ...func(*Options)) (*ListCloudAutonomousVmClustersOutput, error)
}

var _ ListCloudAutonomousVmClustersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCloudAutonomousVmClusters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCloudAutonomousVmClusters",
	}
}
