// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Exadata infrastructure.
func (c *Client) CreateCloudExadataInfrastructure(ctx context.Context, params *CreateCloudExadataInfrastructureInput, optFns ...func(*Options)) (*CreateCloudExadataInfrastructureOutput, error) {
	if params == nil {
		params = &CreateCloudExadataInfrastructureInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCloudExadataInfrastructure", params, optFns, c.addOperationCreateCloudExadataInfrastructureMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCloudExadataInfrastructureOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCloudExadataInfrastructureInput struct {

	// The number of database servers for the Exadata infrastructure. Valid values for
	// this parameter depend on the shape. To get information about the minimum and
	// maximum values, use the ListDbSystemShapes operation.
	//
	// This member is required.
	ComputeCount *int32

	// A user-friendly name for the Exadata infrastructure.
	//
	// This member is required.
	DisplayName *string

	// The model name of the Exadata infrastructure. For the list of valid model
	// names, use the ListDbSystemShapes operation.
	//
	// This member is required.
	Shape *string

	// The number of storage servers to activate for this Exadata infrastructure.
	// Valid values for this parameter depend on the shape. To get information about
	// the minimum and maximum values, use the ListDbSystemShapes operation.
	//
	// This member is required.
	StorageCount *int32

	// The name of the Availability Zone (AZ) where the Exadata infrastructure is
	// located.
	//
	// This operation requires that you specify a value for either availabilityZone or
	// availabilityZoneId .
	//
	// Example: us-east-1a
	AvailabilityZone *string

	// The AZ ID of the AZ where the Exadata infrastructure is located.
	//
	// This operation requires that you specify a value for either availabilityZone or
	// availabilityZoneId .
	//
	// Example: use1-az1
	AvailabilityZoneId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, the Amazon Web Services SDK
	// automatically generates a client token and uses it for the request to ensure
	// idempotency. The client token is valid for up to 24 hours after it's first used.
	ClientToken *string

	// The email addresses of contacts to receive notification from Oracle about
	// maintenance updates for the Exadata infrastructure.
	CustomerContactsToSendToOCI []types.CustomerContact

	// The database server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	DatabaseServerType *string

	// The maintenance window configuration for the Exadata Cloud infrastructure.
	//
	// This allows you to define when maintenance operations such as patching and
	// updates can be performed on the infrastructure.
	MaintenanceWindow *types.MaintenanceWindow

	// The storage server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	StorageServerType *string

	// The list of resource tags to apply to the Exadata infrastructure.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateCloudExadataInfrastructureOutput struct {

	// The unique identifier of the Exadata infrastructure.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The user-friendly name for the Exadata infrastructure.
	DisplayName *string

	// The current status of the Exadata infrastructure.
	Status types.ResourceStatus

	// Additional information about the status of the Exadata infrastructure.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCloudExadataInfrastructureMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateCloudExadataInfrastructure{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateCloudExadataInfrastructure{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCloudExadataInfrastructure"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateCloudExadataInfrastructureMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCloudExadataInfrastructureValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCloudExadataInfrastructure(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateCloudExadataInfrastructure struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateCloudExadataInfrastructure) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateCloudExadataInfrastructure) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateCloudExadataInfrastructureInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateCloudExadataInfrastructureInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateCloudExadataInfrastructureMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateCloudExadataInfrastructure{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateCloudExadataInfrastructure(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCloudExadataInfrastructure",
	}
}
