// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Condition that matches based on the specific WAF action taken on the request.
type ActionCondition struct {

	//  The WAF action to match against (ALLOW, BLOCK, COUNT, CAPTCHA, CHALLENGE,
	// EXCLUDED_AS_COUNT).
	Action Action

	noSmithyDocumentSerde
}

// Advanced event selectors let you create fine-grained selectors for management,
// data, and network activity events.
type AdvancedEventSelector struct {

	// Contains all selector statements in an advanced event selector.
	//
	// This member is required.
	FieldSelectors []AdvancedFieldSelector

	// An optional, descriptive name for an advanced event selector, such as "Log data
	// events for only two S3 buckets".
	Name *string

	noSmithyDocumentSerde
}

// Defines criteria for selecting resources based on field values.
type AdvancedFieldSelector struct {

	//  The name of the field to use for selection.
	//
	// This member is required.
	Field *string

	//  Matches if the field value ends with the specified value.
	EndsWith []string

	//  Matches if the field value equals the specified value.
	Equals []string

	//  Matches if the field value does not end with the specified value.
	NotEndsWith []string

	//  Matches if the field value does not equal the specified value.
	NotEquals []string

	//  Matches if the field value does not start with the specified value.
	NotStartsWith []string

	//  Matches if the field value starts with the specified value.
	StartsWith []string

	noSmithyDocumentSerde
}

// Defines how telemetry data should be centralized across an Amazon Web Services
// Organization, including source and destination configurations.
type CentralizationRule struct {

	// Configuration determining where the telemetry data should be centralized,
	// backed up, as well as encryption configuration for the primary and backup
	// destinations.
	//
	// This member is required.
	Destination *CentralizationRuleDestination

	// Configuration determining the source of the telemetry data to be centralized.
	//
	// This member is required.
	Source *CentralizationRuleSource

	noSmithyDocumentSerde
}

// Configuration specifying the primary destination for centralized telemetry data.
type CentralizationRuleDestination struct {

	// The primary destination region to which telemetry data should be centralized.
	//
	// This member is required.
	Region *string

	// The destination account (within the organization) to which the telemetry data
	// should be centralized.
	Account *string

	// Log specific configuration for centralization destination log groups.
	DestinationLogsConfiguration *DestinationLogsConfiguration

	noSmithyDocumentSerde
}

// Configuration specifying the source of telemetry data to be centralized.
type CentralizationRuleSource struct {

	// The list of source regions from which telemetry data should be centralized.
	//
	// This member is required.
	Regions []string

	// The organizational scope from which telemetry data should be centralized,
	// specified using organization id, accounts or organizational unit ids.
	Scope *string

	// Log specific configuration for centralization source log groups.
	SourceLogsConfiguration *SourceLogsConfiguration

	noSmithyDocumentSerde
}

// A summary of a centralization rule's key properties and status.
type CentralizationRuleSummary struct {

	// The Amazon Web Services region where the organization centralization rule was
	// created.
	CreatedRegion *string

	// The timestamp when the organization centralization rule was created.
	CreatedTimeStamp *int64

	// The Amazon Web Services Account that created the organization centralization
	// rule.
	CreatorAccountId *string

	// The primary destination account of the organization centralization rule.
	DestinationAccountId *string

	// The primary destination region of the organization centralization rule.
	DestinationRegion *string

	// The reason why an organization centralization rule is marked UNHEALTHY.
	FailureReason CentralizationFailureReason

	// The timestamp when the organization centralization rule was last updated.
	LastUpdateTimeStamp *int64

	// The Amazon Resource Name (ARN) of the organization centralization rule.
	RuleArn *string

	// The health status of the organization centralization rule.
	RuleHealth RuleHealth

	// The name of the organization centralization rule.
	RuleName *string

	noSmithyDocumentSerde
}

// Parameters specific to Amazon Web Services CloudTrail telemetry configuration.
type CloudtrailParameters struct {

	//  The advanced event selectors to use for filtering Amazon Web Services
	// CloudTrail events.
	//
	// This member is required.
	AdvancedEventSelectors []AdvancedEventSelector

	noSmithyDocumentSerde
}

// A single condition that can match based on WAF rule action or label name.
type Condition struct {

	//  Matches log records based on the WAF rule action taken (ALLOW, BLOCK, COUNT,
	// etc.).
	ActionCondition *ActionCondition

	//  Matches log records based on WAF rule labels applied to the request.
	LabelNameCondition *LabelNameCondition

	noSmithyDocumentSerde
}

// Provides a summary of pipeline configuration components including sources,
// processors, and destinations.
type ConfigurationSummary struct {

	// The list of data sources that provide telemetry data to the pipeline.
	DataSources []DataSource

	// The total number of processors configured in the pipeline.
	ProcessorCount *int32

	// The list of processors configured in the pipeline for data transformation.
	Processors []string

	// The list of destinations where processed data is sent.
	Sinks []string

	// The list of data sources configured in the pipeline.
	Sources []Source

	noSmithyDocumentSerde
}

// Information about a data source associated with the telemetry pipeline. For
// CloudWatch Logs sources, this includes both a name and type extracted from the
// log event metadata. For third-party sources (such as S3), this includes only a
// name, with the type field left empty.
type DataSource struct {

	// The name of the data source. For CloudWatch Logs sources, this corresponds to
	// the data_source_name from the log event metadata. For third-party sources, this
	// is either the configured data_source_name or defaults to the plugin name if not
	// specified.
	Name *string

	// The type of the data source. For CloudWatch Logs sources, this corresponds to
	// the data_source_type from the log event metadata. For third-party sources, this
	// field is empty.
	Type *string

	noSmithyDocumentSerde
}

// Configuration for centralization destination log groups, including encryption
// and backup settings.
type DestinationLogsConfiguration struct {

	// Configuration defining the backup region and an optional KMS key for the backup
	// destination.
	BackupConfiguration *LogsBackupConfiguration

	// The encryption configuration for centralization destination log groups.
	LogsEncryptionConfiguration *LogsEncryptionConfiguration

	noSmithyDocumentSerde
}

//	Configuration parameters for ELB load balancer logging, including output
//
// format and field delimiter settings.
type ELBLoadBalancerLoggingParameters struct {

	//  The delimiter character used to separate fields in ELB access log entries when
	// using plain text format.
	FieldDelimiter *string

	//  The format for ELB access log entries (plain text or JSON format).
	OutputFormat OutputFormat

	noSmithyDocumentSerde
}

// Defines the encryption configuration for S3 Table integrations, including the
// encryption algorithm and KMS key settings.
type Encryption struct {

	// The server-side encryption algorithm used for encrypting data in the S3 Table
	// integration.
	//
	// This member is required.
	SseAlgorithm SSEAlgorithm

	// The Amazon Resource Name (ARN) of the KMS key used for encryption when using
	// customer-managed keys.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

//	Specifies a field in the request to redact from WAF logs, such as headers,
//
// query parameters, or body content.
type FieldToMatch struct {

	//  Redacts the HTTP method from WAF logs.
	Method *string

	//  Redacts the entire query string from WAF logs.
	QueryString *string

	//  Redacts a specific header field by name from WAF logs.
	SingleHeader *SingleHeader

	//  Redacts the URI path from WAF logs.
	UriPath *string

	noSmithyDocumentSerde
}

//	A single filter condition that specifies behavior, requirement, and matching
//
// conditions for WAF log records.
type Filter struct {

	//  The action to take for log records matching this filter (KEEP or DROP).
	Behavior FilterBehavior

	//  The list of conditions that determine if a log record matches this filter.
	Conditions []Condition

	//  Whether the log record must meet all conditions (MEETS_ALL) or any condition
	// (MEETS_ANY) to match this filter.
	Requirement FilterRequirement

	noSmithyDocumentSerde
}

// Contains summary information about an S3 Table integration for listing
// operations.
type IntegrationSummary struct {

	// The Amazon Resource Name (ARN) of the S3 Table integration.
	Arn *string

	// The current status of the S3 Table integration.
	Status IntegrationStatus

	noSmithyDocumentSerde
}

//	Condition that matches based on WAF rule labels, with label names limited to
//
// 1024 characters.
type LabelNameCondition struct {

	//  The label name to match, supporting alphanumeric characters, underscores,
	// hyphens, and colons.
	LabelName *string

	noSmithyDocumentSerde
}

// Configuration parameters for Amazon Bedrock AgentCore logging, including logType
// settings.
type LogDeliveryParameters struct {

	// The type of log that the source is sending.
	LogTypes []LogType

	noSmithyDocumentSerde
}

//	Configuration that determines which WAF log records to keep or drop based on
//
// specified conditions.
type LoggingFilter struct {

	//  The default action (KEEP or DROP) for log records that don't match any filter
	// conditions.
	DefaultBehavior FilterBehavior

	//  A list of filter conditions that determine log record handling behavior.
	Filters []Filter

	noSmithyDocumentSerde
}

// Configuration for backing up centralized log data to a secondary region.
type LogsBackupConfiguration struct {

	// Logs specific backup destination region within the primary destination account
	// to which log data should be centralized.
	//
	// This member is required.
	Region *string

	// KMS Key ARN belonging to the primary destination account and backup region, to
	// encrypt newly created central log groups in the backup destination.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Configuration for encrypting centralized log groups. This configuration is only
// applied to destination log groups for which the corresponding source log groups
// are encrypted using Customer Managed KMS Keys.
type LogsEncryptionConfiguration struct {

	// Configuration that determines the encryption strategy of the destination log
	// groups. CUSTOMER_MANAGED uses the configured KmsKeyArn to encrypt newly created
	// destination log groups.
	//
	// This member is required.
	EncryptionStrategy EncryptionStrategy

	// Conflict resolution strategy for centralization if the encryption strategy is
	// set to CUSTOMER_MANAGED and the destination log group is encrypted with an
	// AWS_OWNED KMS Key. ALLOW lets centralization go through while SKIP prevents
	// centralization into the destination log group.
	EncryptionConflictResolutionStrategy EncryptionConflictResolutionStrategy

	// KMS Key ARN belonging to the primary destination account and region, to encrypt
	// newly created central log groups in the primary destination.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains the output from pipeline test operations, including processed records
// and any errors encountered.
type PipelineOutput struct {

	// Any error that occurred during the pipeline test operation for this record.
	Error *PipelineOutputError

	// The processed record output from the pipeline test operation.
	Record *Record

	noSmithyDocumentSerde
}

// Contains detailed error information from pipeline test operations, providing
// structured error responses for better debugging and troubleshooting
// capabilities.
type PipelineOutputError struct {

	// The detailed error message describing what went wrong during the pipeline test
	// operation for this record.
	Message *string

	noSmithyDocumentSerde
}

// Represents a test record structure used for pipeline testing operations to
// validate data processing.
type Record struct {

	// The data content of the test record used for pipeline validation.
	Data *string

	// The type of the test record, indicating the format or category of the data.
	Type RecordFormat

	noSmithyDocumentSerde
}

//	Structure containing a name field limited to 64 characters for header or query
//
// parameter identification.
type SingleHeader struct {

	//  The name value, limited to 64 characters.
	Name *string

	noSmithyDocumentSerde
}

// A list of source plugin types used in the pipeline configuration (such as
// cloudwatch_logs or s3 ). Currently supports a single source per pipeline, but is
// structured as a list to accommodate multiple pipelines in the configuration.
type Source struct {

	// The plugin name of the source, such as cloudwatch_logs or s3 .
	Type *string

	noSmithyDocumentSerde
}

// Configuration for selecting and handling source log groups for centralization.
type SourceLogsConfiguration struct {

	// A strategy determining whether to centralize source log groups that are
	// encrypted with customer managed KMS keys (CMK). ALLOW will consider CMK
	// encrypted source log groups for centralization while SKIP will skip CMK
	// encrypted source log groups from centralization.
	//
	// This member is required.
	EncryptedLogGroupStrategy EncryptedLogGroupStrategy

	// The selection criteria that specifies which source log groups to centralize.
	// The selection criteria uses the same format as OAM link filters.
	//
	// This member is required.
	LogGroupSelectionCriteria *string

	noSmithyDocumentSerde
}

//	A model representing the state of a resource within an account according to
//
// telemetry config.
type TelemetryConfiguration struct {

	//  The account ID which contains the resource managed in telemetry configuration.
	// An example of a valid account ID is 012345678901 .
	AccountIdentifier *string

	//  The timestamp of the last change to the telemetry configuration for the
	// resource. For example, 1728679196318 .
	LastUpdateTimeStamp *int64

	//  The identifier of the resource, for example for Amazon VPC, it would be
	// vpc-1a2b3c4d5e6f1a2b3 .
	ResourceIdentifier *string

	//  Tags associated with the resource, for example { Name: "ExampleInstance",
	// Environment: "Development" } .
	ResourceTags map[string]string

	//  The type of resource, for example Amazon Web Services::EC2::Instance , or
	// Amazon Web Services::EKS::Cluster , etc.
	ResourceType ResourceType

	//  The configuration state for the resource, for example { Logs: NotApplicable;
	// Metrics: Enabled; Traces: NotApplicable; } .
	TelemetryConfigurationState map[string]TelemetryState

	noSmithyDocumentSerde
}

//	Configuration specifying where and how telemetry data should be delivered for
//
// Amazon Web Services resources.
type TelemetryDestinationConfiguration struct {

	//  Configuration parameters specific to Amazon Web Services CloudTrail when
	// CloudTrail is the source type.
	CloudtrailParameters *CloudtrailParameters

	//  The pattern used to generate the destination path or name, supporting macros
	// like <resourceId> and <accountId>.
	DestinationPattern *string

	//  The type of destination for the telemetry data (e.g., "Amazon CloudWatch
	// Logs", "S3").
	DestinationType DestinationType

	//  Configuration parameters specific to ELB load balancer logging when ELB is the
	// resource type.
	ELBLoadBalancerLoggingParameters *ELBLoadBalancerLoggingParameters

	// Configuration parameters specific to Amazon Bedrock AgentCore logging when
	// Amazon Bedrock AgentCore is the resource type.
	LogDeliveryParameters *LogDeliveryParameters

	//  The number of days to retain the telemetry data in the destination.
	RetentionInDays *int32

	//  Configuration parameters specific to VPC Flow Logs when VPC is the resource
	// type.
	VPCFlowLogParameters *VPCFlowLogParameters

	//  Configuration parameters specific to WAF logging when WAF is the resource
	// type.
	WAFLoggingParameters *WAFLoggingParameters

	noSmithyDocumentSerde
}

// Represents a complete telemetry pipeline resource with configuration, status,
// and metadata for data processing and transformation.
type TelemetryPipeline struct {

	// The Amazon Resource Name (ARN) of the telemetry pipeline.
	Arn *string

	// The configuration that defines how the telemetry pipeline processes data.
	Configuration *TelemetryPipelineConfiguration

	// The timestamp when the telemetry pipeline was created.
	CreatedTimeStamp *int64

	// The timestamp when the telemetry pipeline was last updated.
	LastUpdateTimeStamp *int64

	// The name of the telemetry pipeline.
	Name *string

	// The current status of the telemetry pipeline.
	Status TelemetryPipelineStatus

	// Additional information about the pipeline status, including reasons for failure
	// states.
	StatusReason *TelemetryPipelineStatusReason

	// The key-value pairs associated with the telemetry pipeline resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Defines the configuration for a telemetry pipeline, including how data flows
// from sources through processors to destinations.
type TelemetryPipelineConfiguration struct {

	// The pipeline configuration body that defines the data processing rules and
	// transformations.
	//
	// This member is required.
	Body *string

	noSmithyDocumentSerde
}

// Provides detailed information about the status of a telemetry pipeline,
// including reasons for specific states.
type TelemetryPipelineStatusReason struct {

	// A description of the pipeline status reason, providing additional context about
	// the current state.
	Description *string

	noSmithyDocumentSerde
}

// Contains summary information about a telemetry pipeline for listing operations.
type TelemetryPipelineSummary struct {

	// The Amazon Resource Name (ARN) of the telemetry pipeline.
	Arn *string

	// A summary of the pipeline configuration components.
	ConfigurationSummary *ConfigurationSummary

	// The timestamp when the telemetry pipeline was created.
	CreatedTimeStamp *int64

	// The timestamp when the telemetry pipeline was last updated.
	LastUpdateTimeStamp *int64

	// The name of the telemetry pipeline.
	Name *string

	// The current status of the telemetry pipeline.
	Status TelemetryPipelineStatus

	// The key-value pairs associated with the telemetry pipeline resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

//	Defines how telemetry should be configured for specific Amazon Web Services
//
// resources.
type TelemetryRule struct {

	//  The type of telemetry to collect (Logs, Metrics, or Traces).
	//
	// This member is required.
	TelemetryType TelemetryType

	//  Configuration specifying where and how the telemetry data should be delivered.
	DestinationConfiguration *TelemetryDestinationConfiguration

	//  The type of Amazon Web Services resource to configure telemetry for (e.g.,
	// "AWS::EC2::VPC", "AWS::EKS::Cluster", "AWS::WAFv2::WebACL").
	ResourceType ResourceType

	//  The organizational scope to which the rule applies, specified using accounts
	// or organizational units.
	Scope *string

	//  Criteria for selecting which resources the rule applies to, such as resource
	// tags.
	SelectionCriteria *string

	//  The specific telemetry source types to configure for the resource, such as
	// VPC_FLOW_LOGS or EKS_AUDIT_LOGS. TelemetrySourceTypes must be correlated with
	// the specific resource type.
	TelemetrySourceTypes []TelemetrySourceType

	noSmithyDocumentSerde
}

// A summary of a telemetry rule's key properties.
type TelemetryRuleSummary struct {

	//  The timestamp when the telemetry rule was created.
	CreatedTimeStamp *int64

	//  The timestamp when the telemetry rule was last modified.
	LastUpdateTimeStamp *int64

	//  The type of Amazon Web Services resource the rule applies to.
	ResourceType ResourceType

	//  The Amazon Resource Name (ARN) of the telemetry rule.
	RuleArn *string

	//  The name of the telemetry rule.
	RuleName *string

	//  The types of telemetry sources configured for this rule, such as VPC Flow Logs
	// or EKS audit logs. TelemetrySourceTypes must be correlated with the specific
	// resource type.
	TelemetrySourceTypes []TelemetrySourceType

	//  The type of telemetry (Logs, Metrics, or Traces) the rule configures.
	TelemetryType TelemetryType

	noSmithyDocumentSerde
}

// Represents a detailed validation error with message, reason, and field mapping
// for comprehensive error reporting.
type ValidationError struct {

	// A mapping of field names to specific validation issues within the configuration.
	FieldMap map[string]string

	// The error message describing the validation issue.
	Message *string

	// The reason code or category for the validation error.
	Reason *string

	noSmithyDocumentSerde
}

// Configuration parameters specific to VPC Flow Logs.
type VPCFlowLogParameters struct {

	//  The format in which VPC Flow Log entries should be logged.
	LogFormat *string

	//  The maximum interval in seconds between the capture of flow log records.
	MaxAggregationInterval *int32

	//  The type of traffic to log (ACCEPT, REJECT, or ALL).
	TrafficType *string

	noSmithyDocumentSerde
}

//	Configuration parameters for WAF logging, including redacted fields and
//
// logging filters.
type WAFLoggingParameters struct {

	//  The type of WAF logs to collect (currently supports WAF_LOGS).
	LogType WAFLogType

	//  A filter configuration that determines which WAF log records to include or
	// exclude.
	LoggingFilter *LoggingFilter

	//  The fields to redact from WAF logs to protect sensitive information.
	RedactedFields []FieldToMatch

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
