// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all centralization rules in your organization. This operation can only be
// called by the organization's management account or a delegated administrator
// account.
func (c *Client) ListCentralizationRulesForOrganization(ctx context.Context, params *ListCentralizationRulesForOrganizationInput, optFns ...func(*Options)) (*ListCentralizationRulesForOrganizationOutput, error) {
	if params == nil {
		params = &ListCentralizationRulesForOrganizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCentralizationRulesForOrganization", params, optFns, c.addOperationListCentralizationRulesForOrganizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCentralizationRulesForOrganizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCentralizationRulesForOrganizationInput struct {

	// A flag determining whether to return organization centralization rules from all
	// regions or only the current region.
	AllRegions *bool

	// The maximum number of organization centralization rules to return in a single
	// call.
	MaxResults *int32

	// The token for the next set of results. A previous call generates this token.
	NextToken *string

	// A string to filter organization centralization rules whose names begin with the
	// specified prefix.
	RuleNamePrefix *string

	noSmithyDocumentSerde
}

type ListCentralizationRulesForOrganizationOutput struct {

	// A list of centralization rule summaries.
	CentralizationRuleSummaries []types.CentralizationRuleSummary

	// A token to resume pagination of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCentralizationRulesForOrganizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCentralizationRulesForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCentralizationRulesForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCentralizationRulesForOrganization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCentralizationRulesForOrganization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCentralizationRulesForOrganizationPaginatorOptions is the paginator options
// for ListCentralizationRulesForOrganization
type ListCentralizationRulesForOrganizationPaginatorOptions struct {
	// The maximum number of organization centralization rules to return in a single
	// call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCentralizationRulesForOrganizationPaginator is a paginator for
// ListCentralizationRulesForOrganization
type ListCentralizationRulesForOrganizationPaginator struct {
	options   ListCentralizationRulesForOrganizationPaginatorOptions
	client    ListCentralizationRulesForOrganizationAPIClient
	params    *ListCentralizationRulesForOrganizationInput
	nextToken *string
	firstPage bool
}

// NewListCentralizationRulesForOrganizationPaginator returns a new
// ListCentralizationRulesForOrganizationPaginator
func NewListCentralizationRulesForOrganizationPaginator(client ListCentralizationRulesForOrganizationAPIClient, params *ListCentralizationRulesForOrganizationInput, optFns ...func(*ListCentralizationRulesForOrganizationPaginatorOptions)) *ListCentralizationRulesForOrganizationPaginator {
	if params == nil {
		params = &ListCentralizationRulesForOrganizationInput{}
	}

	options := ListCentralizationRulesForOrganizationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCentralizationRulesForOrganizationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCentralizationRulesForOrganizationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCentralizationRulesForOrganization page.
func (p *ListCentralizationRulesForOrganizationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCentralizationRulesForOrganizationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCentralizationRulesForOrganization(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCentralizationRulesForOrganizationAPIClient is a client that implements the
// ListCentralizationRulesForOrganization operation.
type ListCentralizationRulesForOrganizationAPIClient interface {
	ListCentralizationRulesForOrganization(context.Context, *ListCentralizationRulesForOrganizationInput, ...func(*Options)) (*ListCentralizationRulesForOrganizationOutput, error)
}

var _ ListCentralizationRulesForOrganizationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCentralizationRulesForOrganization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCentralizationRulesForOrganization",
	}
}
