// Code generated by smithy-go-codegen DO NOT EDIT.

package novaact

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/novaact/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/novaact/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/novaact/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateAct struct {
}

func (*awsRestjson1_serializeOpCreateAct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateActInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateActInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateActInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateActInput(v *CreateActInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateActInput(v *CreateActInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Task != nil {
		ok := object.Key("task")
		ok.String(*v.Task)
	}

	if v.ToolSpecs != nil {
		ok := object.Key("toolSpecs")
		if err := awsRestjson1_serializeDocumentToolSpecs(v.ToolSpecs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSession struct {
}

func (*awsRestjson1_serializeOpCreateSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSessionInput(v *CreateSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSessionInput(v *CreateSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkflowDefinition struct {
}

func (*awsRestjson1_serializeOpCreateWorkflowDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkflowDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkflowDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkflowDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkflowDefinitionInput(v *CreateWorkflowDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkflowDefinitionInput(v *CreateWorkflowDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExportConfig != nil {
		ok := object.Key("exportConfig")
		if err := awsRestjson1_serializeDocumentWorkflowExportConfig(v.ExportConfig, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkflowRun struct {
}

func (*awsRestjson1_serializeOpCreateWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWorkflowRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkflowRunInput(v *CreateWorkflowRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkflowRunInput(v *CreateWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientInfo != nil {
		ok := object.Key("clientInfo")
		if err := awsRestjson1_serializeDocumentClientInfo(v.ClientInfo, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	if v.ModelId != nil {
		ok := object.Key("modelId")
		ok.String(*v.ModelId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkflowDefinition struct {
}

func (*awsRestjson1_serializeOpDeleteWorkflowDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkflowDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkflowDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkflowDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkflowDefinitionInput(v *DeleteWorkflowDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkflowRun struct {
}

func (*awsRestjson1_serializeOpDeleteWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkflowRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkflowRunInput(v *DeleteWorkflowRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkflowDefinition struct {
}

func (*awsRestjson1_serializeOpGetWorkflowDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkflowDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkflowDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkflowDefinitionInput(v *GetWorkflowDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkflowRun struct {
}

func (*awsRestjson1_serializeOpGetWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkflowRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkflowRunInput(v *GetWorkflowRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInvokeActStep struct {
}

func (*awsRestjson1_serializeOpInvokeActStep) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeActStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeActStepInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts/{actId}/invoke-step/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeActStepInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentInvokeActStepInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeActStepInput(v *InvokeActStepInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActId == nil || len(*v.ActId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actId must not be empty")}
	}
	if v.ActId != nil {
		if err := encoder.SetURI("actId").String(*v.ActId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentInvokeActStepInput(v *InvokeActStepInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallResults != nil {
		ok := object.Key("callResults")
		if err := awsRestjson1_serializeDocumentCallResults(v.CallResults, ok); err != nil {
			return err
		}
	}

	if v.PreviousStepId != nil {
		ok := object.Key("previousStepId")
		ok.String(*v.PreviousStepId)
	}

	return nil
}

type awsRestjson1_serializeOpListActs struct {
}

func (*awsRestjson1_serializeOpListActs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListActs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListActsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/acts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListActsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListActsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListActsInput(v *ListActsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SessionId != nil {
		encoder.SetQuery("sessionId").String(*v.SessionId)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId != nil {
		encoder.SetQuery("workflowRunId").String(*v.WorkflowRunId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListActsInput(v *ListActsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListModels struct {
}

func (*awsRestjson1_serializeOpListModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelsInput(v *ListModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientCompatibilityVersion != nil {
		encoder.SetQuery("clientCompatibilityVersion").Integer(*v.ClientCompatibilityVersion)
	}

	return nil
}

type awsRestjson1_serializeOpListSessions struct {
}

func (*awsRestjson1_serializeOpListSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionsInput(v *ListSessionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListSessionsInput(v *ListSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListWorkflowDefinitions struct {
}

func (*awsRestjson1_serializeOpListWorkflowDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkflowDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkflowDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkflowDefinitionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListWorkflowDefinitionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkflowDefinitionsInput(v *ListWorkflowDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListWorkflowDefinitionsInput(v *ListWorkflowDefinitionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListWorkflowRuns struct {
}

func (*awsRestjson1_serializeOpListWorkflowRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkflowRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkflowRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkflowRunsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListWorkflowRunsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkflowRunsInput(v *ListWorkflowRunsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListWorkflowRunsInput(v *ListWorkflowRunsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAct struct {
}

func (*awsRestjson1_serializeOpUpdateAct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateActInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}/sessions/{sessionId}/acts/{actId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateActInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateActInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateActInput(v *UpdateActInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActId == nil || len(*v.ActId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actId must not be empty")}
	}
	if v.ActId != nil {
		if err := encoder.SetURI("actId").String(*v.ActId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateActInput(v *UpdateActInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Error != nil {
		ok := object.Key("error")
		if err := awsRestjson1_serializeDocumentActError(v.Error, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkflowRun struct {
}

func (*awsRestjson1_serializeOpUpdateWorkflowRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkflowRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkflowRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workflow-definitions/{workflowDefinitionName}/workflow-runs/{workflowRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkflowRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkflowRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkflowRunInput(v *UpdateWorkflowRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkflowDefinitionName == nil || len(*v.WorkflowDefinitionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowDefinitionName must not be empty")}
	}
	if v.WorkflowDefinitionName != nil {
		if err := encoder.SetURI("workflowDefinitionName").String(*v.WorkflowDefinitionName); err != nil {
			return err
		}
	}

	if v.WorkflowRunId == nil || len(*v.WorkflowRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workflowRunId must not be empty")}
	}
	if v.WorkflowRunId != nil {
		if err := encoder.SetURI("workflowRunId").String(*v.WorkflowRunId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkflowRunInput(v *UpdateWorkflowRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentActError(v *types.ActError, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("message")
		ok.String(*v.Message)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentCallResult(v *types.CallResult, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallId != nil {
		ok := object.Key("callId")
		ok.String(*v.CallId)
	}

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentCallResultContents(v.Content, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCallResultContent(v types.CallResultContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CallResultContentMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCallResultContents(v []types.CallResultContent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentCallResultContent(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCallResults(v []types.CallResult, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCallResult(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentClientInfo(v *types.ClientInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompatibilityVersion != nil {
		ok := object.Key("compatibilityVersion")
		ok.Integer(*v.CompatibilityVersion)
	}

	if v.SdkVersion != nil {
		ok := object.Key("sdkVersion")
		ok.String(*v.SdkVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentToolInputSchema(v types.ToolInputSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ToolInputSchemaMemberJson:
		av := object.Key("json")
		if err := awsRestjson1_serializeDocumentToolInputSchemaDocument(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentToolInputSchemaDocument(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentToolSpec(v *types.ToolSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InputSchema != nil {
		ok := object.Key("inputSchema")
		if err := awsRestjson1_serializeDocumentToolInputSchema(v.InputSchema, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentToolSpecs(v []types.ToolSpec, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentToolSpec(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkflowExportConfig(v *types.WorkflowExportConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("s3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	return nil
}
