// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the prefix list associations for a core network.
func (c *Client) ListCoreNetworkPrefixListAssociations(ctx context.Context, params *ListCoreNetworkPrefixListAssociationsInput, optFns ...func(*Options)) (*ListCoreNetworkPrefixListAssociationsOutput, error) {
	if params == nil {
		params = &ListCoreNetworkPrefixListAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCoreNetworkPrefixListAssociations", params, optFns, c.addOperationListCoreNetworkPrefixListAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCoreNetworkPrefixListAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCoreNetworkPrefixListAssociationsInput struct {

	// The ID of the core network to list prefix list associations for.
	//
	// This member is required.
	CoreNetworkId *string

	// The maximum number of results to return in a single page.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The ARN of a specific prefix list to filter the associations.
	PrefixListArn *string

	noSmithyDocumentSerde
}

type ListCoreNetworkPrefixListAssociationsOutput struct {

	// The token for the next page of results.
	NextToken *string

	// The list of prefix list associations for the core network.
	PrefixListAssociations []types.PrefixListAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCoreNetworkPrefixListAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCoreNetworkPrefixListAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCoreNetworkPrefixListAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCoreNetworkPrefixListAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCoreNetworkPrefixListAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCoreNetworkPrefixListAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCoreNetworkPrefixListAssociationsPaginatorOptions is the paginator options
// for ListCoreNetworkPrefixListAssociations
type ListCoreNetworkPrefixListAssociationsPaginatorOptions struct {
	// The maximum number of results to return in a single page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCoreNetworkPrefixListAssociationsPaginator is a paginator for
// ListCoreNetworkPrefixListAssociations
type ListCoreNetworkPrefixListAssociationsPaginator struct {
	options   ListCoreNetworkPrefixListAssociationsPaginatorOptions
	client    ListCoreNetworkPrefixListAssociationsAPIClient
	params    *ListCoreNetworkPrefixListAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListCoreNetworkPrefixListAssociationsPaginator returns a new
// ListCoreNetworkPrefixListAssociationsPaginator
func NewListCoreNetworkPrefixListAssociationsPaginator(client ListCoreNetworkPrefixListAssociationsAPIClient, params *ListCoreNetworkPrefixListAssociationsInput, optFns ...func(*ListCoreNetworkPrefixListAssociationsPaginatorOptions)) *ListCoreNetworkPrefixListAssociationsPaginator {
	if params == nil {
		params = &ListCoreNetworkPrefixListAssociationsInput{}
	}

	options := ListCoreNetworkPrefixListAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCoreNetworkPrefixListAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCoreNetworkPrefixListAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCoreNetworkPrefixListAssociations page.
func (p *ListCoreNetworkPrefixListAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCoreNetworkPrefixListAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCoreNetworkPrefixListAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCoreNetworkPrefixListAssociationsAPIClient is a client that implements the
// ListCoreNetworkPrefixListAssociations operation.
type ListCoreNetworkPrefixListAssociationsAPIClient interface {
	ListCoreNetworkPrefixListAssociations(context.Context, *ListCoreNetworkPrefixListAssociationsInput, ...func(*Options)) (*ListCoreNetworkPrefixListAssociationsOutput, error)
}

var _ ListCoreNetworkPrefixListAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCoreNetworkPrefixListAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCoreNetworkPrefixListAssociations",
	}
}
