// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Create a query with the Network Flow Monitor query interface that you can run
// to return data for workload insights top contributors. Specify the scope that
// you want to create a query for.
//
// The call returns a query ID that you can use with [GetQueryResultsWorkloadInsightsTopContributorsData] to run the query and return
// the data for the top contributors for the workload insights for a scope.
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type. Top contributors can be across all workload
// insights, for a given scope, or for a specific monitor. Use the applicable call
// for the top contributors that you want to be returned.
//
// [GetQueryResultsWorkloadInsightsTopContributorsData]: https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html
func (c *Client) StartQueryWorkloadInsightsTopContributorsData(ctx context.Context, params *StartQueryWorkloadInsightsTopContributorsDataInput, optFns ...func(*Options)) (*StartQueryWorkloadInsightsTopContributorsDataOutput, error) {
	if params == nil {
		params = &StartQueryWorkloadInsightsTopContributorsDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartQueryWorkloadInsightsTopContributorsData", params, optFns, c.addOperationStartQueryWorkloadInsightsTopContributorsDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartQueryWorkloadInsightsTopContributorsDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartQueryWorkloadInsightsTopContributorsDataInput struct {

	// The destination category for a top contributors. Destination categories can be
	// one of the following:
	//
	//   - INTRA_AZ : Top contributor network flows within a single Availability Zone
	//
	//   - INTER_AZ : Top contributor network flows between Availability Zones
	//
	//   - INTER_REGION : Top contributor network flows between Regions (to the edge of
	//   another Region)
	//
	//   - INTER_VPC : Top contributor network flows between VPCs
	//
	//   - AWS_SERVICES : Top contributor network flows to or from Amazon Web Services
	//   services
	//
	//   - UNCLASSIFIED : Top contributor network flows that do not have a bucket
	//   classification
	//
	// This member is required.
	DestinationCategory types.DestinationCategory

	// The timestamp that is the date and time end of the period that you want to
	// retrieve results for with your query.
	//
	// This member is required.
	EndTime *time.Time

	// The metric that you want to query top contributors for. That is, you can
	// specify this metric to return the top contributor network flows, for this type
	// of metric, for a monitor and (optionally) within a specific category, such as
	// network flows between Availability Zones.
	//
	// This member is required.
	MetricName types.WorkloadInsightsMetric

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	// The timestamp that is the date and time that is the beginning of the period
	// that you want to retrieve results for with your query.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type StartQueryWorkloadInsightsTopContributorsDataOutput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to start a query.
	//
	// This member is required.
	QueryId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartQueryWorkloadInsightsTopContributorsDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartQueryWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartQueryWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartQueryWorkloadInsightsTopContributorsData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartQueryWorkloadInsightsTopContributorsDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartQueryWorkloadInsightsTopContributorsData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartQueryWorkloadInsightsTopContributorsData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartQueryWorkloadInsightsTopContributorsData",
	}
}
