// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Return the data for a query with the Network Flow Monitor query interface.
// Specify the query that you want to return results for by providing a query ID
// and a monitor name. This query returns the top contributors for workload
// insights.
//
// When you start a query, use this call to check the status of the query to make
// sure that it has has SUCCEEDED before you review the results. Use the same
// query ID that you used for the corresponding API call to start the query,
// StartQueryWorkloadInsightsTopContributors .
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type. Top contributors can be across all workload
// insights, for a given scope, or for a specific monitor. Use the applicable call
// for the top contributors that you want to be returned.
func (c *Client) GetQueryStatusWorkloadInsightsTopContributors(ctx context.Context, params *GetQueryStatusWorkloadInsightsTopContributorsInput, optFns ...func(*Options)) (*GetQueryStatusWorkloadInsightsTopContributorsOutput, error) {
	if params == nil {
		params = &GetQueryStatusWorkloadInsightsTopContributorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQueryStatusWorkloadInsightsTopContributors", params, optFns, c.addOperationGetQueryStatusWorkloadInsightsTopContributorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQueryStatusWorkloadInsightsTopContributorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQueryStatusWorkloadInsightsTopContributorsInput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to start a query.
	//
	// This member is required.
	QueryId *string

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	noSmithyDocumentSerde
}

type GetQueryStatusWorkloadInsightsTopContributorsOutput struct {

	// When you run a query, use this call to check the status of the query to make
	// sure that the query has SUCCEEDED before you review the results.
	//
	//   - QUEUED : The query is scheduled to run.
	//
	//   - RUNNING : The query is in progress but not complete.
	//
	//   - SUCCEEDED : The query completed sucessfully.
	//
	//   - FAILED : The query failed due to an error.
	//
	//   - CANCELED : The query was canceled.
	//
	// This member is required.
	Status types.QueryStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQueryStatusWorkloadInsightsTopContributorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetQueryStatusWorkloadInsightsTopContributors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetQueryStatusWorkloadInsightsTopContributors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQueryStatusWorkloadInsightsTopContributors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetQueryStatusWorkloadInsightsTopContributorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQueryStatusWorkloadInsightsTopContributors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetQueryStatusWorkloadInsightsTopContributors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQueryStatusWorkloadInsightsTopContributors",
	}
}
