// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Create a monitor for specific network flows between local and remote resources,
// so that you can monitor network performance for one or several of your
// workloads. For each monitor, Network Flow Monitor publishes detailed end-to-end
// performance metrics and a network health indicator (NHI) that informs you
// whether there were Amazon Web Services network issues for one or more of the
// network flows tracked by a monitor, during a time period that you choose.
func (c *Client) CreateMonitor(ctx context.Context, params *CreateMonitorInput, optFns ...func(*Options)) (*CreateMonitorOutput, error) {
	if params == nil {
		params = &CreateMonitorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMonitor", params, optFns, c.addOperationCreateMonitorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMonitorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMonitorInput struct {

	// The local resources to monitor. A local resource in a workload is the location
	// of the host, or hosts, where the Network Flow Monitor agent is installed. For
	// example, if a workload consists of an interaction between a web service and a
	// backend database (for example, Amazon Dynamo DB), the subnet with the EC2
	// instance that hosts the web service, which also runs the agent, is the local
	// resource.
	//
	// Be aware that all local resources must belong to the current Region.
	//
	// This member is required.
	LocalResources []types.MonitorLocalResource

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The Amazon Resource Name (ARN) of the scope for the monitor.
	//
	// This member is required.
	ScopeArn *string

	// A unique, case-sensitive string of up to 64 ASCII characters that you specify
	// to make an idempotent API request. Don't reuse the same client token for other
	// API requests.
	ClientToken *string

	// The remote resources to monitor. A remote resource is the other endpoint in the
	// bi-directional flow of a workload, with a local resource. For example, Amazon
	// Dynamo DB can be a remote resource.
	//
	// When you specify remote resources, be aware that specific combinations of
	// resources are allowed and others are not, including the following constraints:
	//
	//   - All remote resources that you specify must all belong to a single Region.
	//
	//   - If you specify Amazon Web Services services as remote resources, any other
	//   remote resources that you specify must be in the current Region.
	//
	//   - When you specify a remote resource for another Region, you can only specify
	//   the Region resource type. You cannot specify a subnet, VPC, or Availability
	//   Zone in another Region.
	//
	//   - If you leave the RemoteResources parameter empty, the monitor will include
	//   all network flows that terminate in the current Region.
	RemoteResources []types.MonitorRemoteResource

	// The tags for a monitor. You can add a maximum of 200 tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateMonitorOutput struct {

	// The date and time when the monitor was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The local resources to monitor. A local resource in a workload is the location
	// of hosts where the Network Flow Monitor agent is installed.
	//
	// This member is required.
	LocalResources []types.MonitorLocalResource

	// The last date and time that the monitor was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// This member is required.
	MonitorArn *string

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The status of a monitor. The status can be one of the following
	//
	//   - PENDING : The monitor is in the process of being created.
	//
	//   - ACTIVE : The monitor is active.
	//
	//   - INACTIVE : The monitor is inactive.
	//
	//   - ERROR : Monitor creation failed due to an error.
	//
	//   - DELETING : The monitor is in the process of being deleted.
	//
	// This member is required.
	MonitorStatus types.MonitorStatus

	// The remote resources to monitor. A remote resource is the other endpoint
	// specified for the network flow of a workload, with a local resource. For
	// example, Amazon Dynamo DB can be a remote resource.
	//
	// This member is required.
	RemoteResources []types.MonitorRemoteResource

	// The tags for a monitor.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMonitorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMonitor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMonitor{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMonitor"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateMonitorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMonitorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMonitor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateMonitor struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateMonitor) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateMonitor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateMonitorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateMonitorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateMonitorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateMonitor{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateMonitor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMonitor",
	}
}
