// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Rejects a transit gateway attachment request for Network Firewall. When you
// reject the attachment request, Network Firewall cancels the creation of routing
// components between the transit gateway and firewall endpoints.
//
// Only the transit gateway owner can reject the attachment. After rejection, no
// traffic will flow through the firewall endpoints for this attachment.
//
// Use DescribeFirewall to monitor the rejection status. To accept the attachment instead of
// rejecting it, use AcceptNetworkFirewallTransitGatewayAttachment.
//
// Once rejected, you cannot reverse this action. To establish connectivity, you
// must create a new transit gateway-attached firewall.
func (c *Client) RejectNetworkFirewallTransitGatewayAttachment(ctx context.Context, params *RejectNetworkFirewallTransitGatewayAttachmentInput, optFns ...func(*Options)) (*RejectNetworkFirewallTransitGatewayAttachmentOutput, error) {
	if params == nil {
		params = &RejectNetworkFirewallTransitGatewayAttachmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RejectNetworkFirewallTransitGatewayAttachment", params, optFns, c.addOperationRejectNetworkFirewallTransitGatewayAttachmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RejectNetworkFirewallTransitGatewayAttachmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RejectNetworkFirewallTransitGatewayAttachmentInput struct {

	// Required. The unique identifier of the transit gateway attachment to reject.
	// This ID is returned in the response when creating a transit gateway-attached
	// firewall.
	//
	// This member is required.
	TransitGatewayAttachmentId *string

	noSmithyDocumentSerde
}

type RejectNetworkFirewallTransitGatewayAttachmentOutput struct {

	// The unique identifier of the transit gateway attachment that was rejected.
	//
	// This member is required.
	TransitGatewayAttachmentId *string

	// The current status of the transit gateway attachment. Valid values are:
	//
	//   - CREATING - The attachment is being created
	//
	//   - DELETING - The attachment is being deleted
	//
	//   - DELETED - The attachment has been deleted
	//
	//   - FAILED - The attachment creation has failed and cannot be recovered
	//
	//   - ERROR - The attachment is in an error state that might be recoverable
	//
	//   - READY - The attachment is active and processing traffic
	//
	//   - PENDING_ACCEPTANCE - The attachment is waiting to be accepted
	//
	//   - REJECTING - The attachment is in the process of being rejected
	//
	//   - REJECTED - The attachment has been rejected
	//
	// For information about troubleshooting endpoint failures, see [Troubleshooting firewall endpoint failures] in the Network
	// Firewall Developer Guide.
	//
	// [Troubleshooting firewall endpoint failures]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html
	//
	// This member is required.
	TransitGatewayAttachmentStatus types.TransitGatewayAttachmentStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRejectNetworkFirewallTransitGatewayAttachmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRejectNetworkFirewallTransitGatewayAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRejectNetworkFirewallTransitGatewayAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RejectNetworkFirewallTransitGatewayAttachment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRejectNetworkFirewallTransitGatewayAttachmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRejectNetworkFirewallTransitGatewayAttachment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRejectNetworkFirewallTransitGatewayAttachment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RejectNetworkFirewallTransitGatewayAttachment",
	}
}
