// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates Network Firewall ProxyRule resources.
//
// Attaches new proxy rule(s) to an existing proxy rule group.
//
// To retrieve information about individual proxy rules, use DescribeProxyRuleGroup and DescribeProxyRule.
func (c *Client) CreateProxyRules(ctx context.Context, params *CreateProxyRulesInput, optFns ...func(*Options)) (*CreateProxyRulesOutput, error) {
	if params == nil {
		params = &CreateProxyRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProxyRules", params, optFns, c.addOperationCreateProxyRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProxyRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProxyRulesInput struct {

	// Individual rules that define match conditions and actions for application-layer
	// traffic. Rules specify what to inspect (domains, headers, methods) and what
	// action to take (allow, deny, alert).
	//
	// This member is required.
	Rules *types.CreateProxyRulesByRequestPhase

	// The Amazon Resource Name (ARN) of a proxy rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupArn *string

	// The descriptive name of the proxy rule group. You can't change the name of a
	// proxy rule group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupName *string

	noSmithyDocumentSerde
}

type CreateProxyRulesOutput struct {

	// The properties that define the proxy rule group with the newly created proxy
	// rule(s).
	ProxyRuleGroup *types.ProxyRuleGroup

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy rule. The token marks the state of the proxy rule
	// resource at the time of the request.
	//
	// To make changes to the proxy rule, you provide the token in your request.
	// Network Firewall uses the token to ensure that the proxy rule hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the proxy rule again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProxyRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateProxyRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateProxyRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProxyRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProxyRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProxyRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProxyRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProxyRules",
	}
}
