// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Network Firewall ProxyRuleGroup
//
// Collections of related proxy filtering rules. Rule groups help you manage and
// reuse sets of rules across multiple proxy configurations.
//
// To manage a proxy rule group's tags, use the standard Amazon Web Services
// resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
//
// To retrieve information about proxy rule groups, use ListProxyRuleGroups and DescribeProxyRuleGroup.
//
// To retrieve information about individual proxy rules, use DescribeProxyRuleGroup and DescribeProxyRule.
func (c *Client) CreateProxyRuleGroup(ctx context.Context, params *CreateProxyRuleGroupInput, optFns ...func(*Options)) (*CreateProxyRuleGroupOutput, error) {
	if params == nil {
		params = &CreateProxyRuleGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProxyRuleGroup", params, optFns, c.addOperationCreateProxyRuleGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProxyRuleGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProxyRuleGroupInput struct {

	// The descriptive name of the proxy rule group. You can't change the name of a
	// proxy rule group after you create it.
	//
	// This member is required.
	ProxyRuleGroupName *string

	// A description of the proxy rule group.
	Description *string

	// Individual rules that define match conditions and actions for application-layer
	// traffic. Rules specify what to inspect (domains, headers, methods) and what
	// action to take (allow, deny, alert).
	Rules *types.ProxyRulesByRequestPhase

	// The key:value pairs to associate with the resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateProxyRuleGroupOutput struct {

	// The properties that define the proxy rule group.
	ProxyRuleGroup *types.ProxyRuleGroup

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy rule group. The token marks the state of the
	// proxy rule group resource at the time of the request.
	//
	// To make changes to the proxy rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the proxy rule group hasn't
	// changed since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException . If this happens, retrieve the proxy rule group again
	// to get a current copy of it with a current token. Reapply your changes as
	// needed, then try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProxyRuleGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateProxyRuleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateProxyRuleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProxyRuleGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProxyRuleGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProxyRuleGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProxyRuleGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProxyRuleGroup",
	}
}
