// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Network Firewall Proxy
//
// Attaches a Proxy configuration to a NAT Gateway.
//
// To manage a proxy's tags, use the standard Amazon Web Services resource tagging
// operations, ListTagsForResource, TagResource, and UntagResource.
//
// To retrieve information about proxies, use ListProxies and DescribeProxy.
func (c *Client) CreateProxy(ctx context.Context, params *CreateProxyInput, optFns ...func(*Options)) (*CreateProxyOutput, error) {
	if params == nil {
		params = &CreateProxyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProxy", params, optFns, c.addOperationCreateProxyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProxyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProxyInput struct {

	// A unique identifier for the NAT gateway to use with proxy resources.
	//
	// This member is required.
	NatGatewayId *string

	// The descriptive name of the proxy. You can't change the name of a proxy after
	// you create it.
	//
	// This member is required.
	ProxyName *string

	// TLS decryption on traffic to filter on attributes in the HTTP header.
	//
	// This member is required.
	TlsInterceptProperties *types.TlsInterceptPropertiesRequest

	// Listener properties for HTTP and HTTPS traffic.
	ListenerProperties []types.ListenerPropertyRequest

	// The Amazon Resource Name (ARN) of a proxy configuration.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationArn *string

	// The descriptive name of the proxy configuration. You can't change the name of a
	// proxy configuration after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationName *string

	// The key:value pairs to associate with the resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateProxyOutput struct {

	// Proxy attached to a NAT gateway.
	Proxy *types.Proxy

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy. The token marks the state of the proxy resource
	// at the time of the request.
	//
	// To make changes to the proxy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the proxy hasn't changed since you last
	// retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the proxy again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProxyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateProxy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateProxy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProxy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProxyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProxy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProxy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProxy",
	}
}
