// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Attaches ProxyRuleGroup resources to a ProxyConfiguration
//
// A Proxy Configuration defines the monitoring and protection behavior for a
// Proxy. The details of the behavior are defined in the rule groups that you add
// to your configuration.
func (c *Client) AttachRuleGroupsToProxyConfiguration(ctx context.Context, params *AttachRuleGroupsToProxyConfigurationInput, optFns ...func(*Options)) (*AttachRuleGroupsToProxyConfigurationOutput, error) {
	if params == nil {
		params = &AttachRuleGroupsToProxyConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AttachRuleGroupsToProxyConfiguration", params, optFns, c.addOperationAttachRuleGroupsToProxyConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AttachRuleGroupsToProxyConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AttachRuleGroupsToProxyConfigurationInput struct {

	// The proxy rule group(s) to attach to the proxy configuration
	//
	// This member is required.
	RuleGroups []types.ProxyRuleGroupAttachment

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy configuration. The token marks the state of the
	// proxy configuration resource at the time of the request.
	//
	// To make changes to the proxy configuration, you provide the token in your
	// request. Network Firewall uses the token to ensure that the proxy configuration
	// hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException . If this happens, retrieve the proxy
	// configuration again to get a current copy of it with a current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// The Amazon Resource Name (ARN) of a proxy configuration.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationArn *string

	// The descriptive name of the proxy configuration. You can't change the name of a
	// proxy configuration after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationName *string

	noSmithyDocumentSerde
}

type AttachRuleGroupsToProxyConfigurationOutput struct {

	// The updated proxy configuration resource that reflects the updates from the
	// request.
	ProxyConfiguration *types.ProxyConfiguration

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy configuration. The token marks the state of the
	// proxy configuration resource at the time of the request.
	//
	// To make changes to the proxy configuration, you provide the token in your
	// request. Network Firewall uses the token to ensure that the proxy configuration
	// hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException . If this happens, retrieve the proxy
	// configuration again to get a current copy of it with a current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAttachRuleGroupsToProxyConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAttachRuleGroupsToProxyConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAttachRuleGroupsToProxyConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AttachRuleGroupsToProxyConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAttachRuleGroupsToProxyConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAttachRuleGroupsToProxyConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAttachRuleGroupsToProxyConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AttachRuleGroupsToProxyConfiguration",
	}
}
