// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunegraph

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptunegraph/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"strconv"
	"time"
)

// Retrieves a specified export task.
func (c *Client) GetExportTask(ctx context.Context, params *GetExportTaskInput, optFns ...func(*Options)) (*GetExportTaskOutput, error) {
	if params == nil {
		params = &GetExportTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetExportTask", params, optFns, c.addOperationGetExportTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetExportTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetExportTaskInput struct {

	// The unique identifier of the export task.
	//
	// This member is required.
	TaskIdentifier *string

	noSmithyDocumentSerde
}

func (in *GetExportTaskInput) bindEndpointParams(p *EndpointParameters) {

	p.ApiType = ptr.String("ControlPlane")
}

type GetExportTaskOutput struct {

	// The Amazon S3 URI of the export task where data will be exported.
	//
	// This member is required.
	Destination *string

	// The format of the export task.
	//
	// This member is required.
	Format types.ExportFormat

	// The source graph identifier of the export task.
	//
	// This member is required.
	GraphId *string

	// The KMS key identifier of the export task.
	//
	// This member is required.
	KmsKeyIdentifier *string

	// The ARN of the IAM role that will allow data to be exported to the destination.
	//
	// This member is required.
	RoleArn *string

	// The current status of the export task.
	//
	// This member is required.
	Status types.ExportTaskStatus

	// The unique identifier of the export task.
	//
	// This member is required.
	TaskId *string

	// The export filter of the export task.
	ExportFilter *types.ExportFilter

	// The details of the export task.
	ExportTaskDetails *types.ExportTaskDetails

	// The parquet type of the export task.
	ParquetType types.ParquetType

	// The reason that the export task has this status value.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetExportTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetExportTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetExportTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetExportTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetExportTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetExportTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ExportTaskSuccessfulWaiterOptions are waiter options for
// ExportTaskSuccessfulWaiter
type ExportTaskSuccessfulWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ExportTaskSuccessfulWaiter will use default minimum delay of 60 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ExportTaskSuccessfulWaiter will use default max delay of 28800
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetExportTaskInput, *GetExportTaskOutput, error) (bool, error)
}

// ExportTaskSuccessfulWaiter defines the waiters for ExportTaskSuccessful
type ExportTaskSuccessfulWaiter struct {
	client GetExportTaskAPIClient

	options ExportTaskSuccessfulWaiterOptions
}

// NewExportTaskSuccessfulWaiter constructs a ExportTaskSuccessfulWaiter.
func NewExportTaskSuccessfulWaiter(client GetExportTaskAPIClient, optFns ...func(*ExportTaskSuccessfulWaiterOptions)) *ExportTaskSuccessfulWaiter {
	options := ExportTaskSuccessfulWaiterOptions{}
	options.MinDelay = 60 * time.Second
	options.MaxDelay = 28800 * time.Second
	options.Retryable = exportTaskSuccessfulStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ExportTaskSuccessfulWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ExportTaskSuccessful waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *ExportTaskSuccessfulWaiter) Wait(ctx context.Context, params *GetExportTaskInput, maxWaitDur time.Duration, optFns ...func(*ExportTaskSuccessfulWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ExportTaskSuccessful waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *ExportTaskSuccessfulWaiter) WaitForOutput(ctx context.Context, params *GetExportTaskInput, maxWaitDur time.Duration, optFns ...func(*ExportTaskSuccessfulWaiterOptions)) (*GetExportTaskOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 28800 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetExportTask(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ExportTaskSuccessful waiter")
}

func exportTaskSuccessfulStateRetryable(ctx context.Context, input *GetExportTaskInput, output *GetExportTaskOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "FAILED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "SUCCEEDED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// ExportTaskCancelledWaiterOptions are waiter options for
// ExportTaskCancelledWaiter
type ExportTaskCancelledWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ExportTaskCancelledWaiter will use default minimum delay of 60 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ExportTaskCancelledWaiter will use default max delay of 3600
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetExportTaskInput, *GetExportTaskOutput, error) (bool, error)
}

// ExportTaskCancelledWaiter defines the waiters for ExportTaskCancelled
type ExportTaskCancelledWaiter struct {
	client GetExportTaskAPIClient

	options ExportTaskCancelledWaiterOptions
}

// NewExportTaskCancelledWaiter constructs a ExportTaskCancelledWaiter.
func NewExportTaskCancelledWaiter(client GetExportTaskAPIClient, optFns ...func(*ExportTaskCancelledWaiterOptions)) *ExportTaskCancelledWaiter {
	options := ExportTaskCancelledWaiterOptions{}
	options.MinDelay = 60 * time.Second
	options.MaxDelay = 3600 * time.Second
	options.Retryable = exportTaskCancelledStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ExportTaskCancelledWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ExportTaskCancelled waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *ExportTaskCancelledWaiter) Wait(ctx context.Context, params *GetExportTaskInput, maxWaitDur time.Duration, optFns ...func(*ExportTaskCancelledWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ExportTaskCancelled waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *ExportTaskCancelledWaiter) WaitForOutput(ctx context.Context, params *GetExportTaskInput, maxWaitDur time.Duration, optFns ...func(*ExportTaskCancelledWaiterOptions)) (*GetExportTaskOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 3600 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetExportTask(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ExportTaskCancelled waiter")
}

func exportTaskCancelledStateRetryable(ctx context.Context, input *GetExportTaskInput, output *GetExportTaskOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		v2 := "CANCELLING"
		v3 := string(v1) != string(v2)
		v4 := output.Status
		v5 := "CANCELLED"
		v6 := string(v4) != string(v5)
		v7 := v3 && v6
		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		if v7 == bv {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetExportTaskAPIClient is a client that implements the GetExportTask operation.
type GetExportTaskAPIClient interface {
	GetExportTask(context.Context, *GetExportTaskInput, ...func(*Options)) (*GetExportTaskOutput, error)
}

var _ GetExportTaskAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetExportTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetExportTask",
	}
}
