// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies an Availability Zone.
type AvailabilityZone struct {

	// The name of the availability zone.
	Name *string

	noSmithyDocumentSerde
}

// Specifies a character set.
type CharacterSet struct {

	// The description of the character set.
	CharacterSetDescription *string

	// The name of the character set.
	CharacterSetName *string

	noSmithyDocumentSerde
}

// The configuration setting for the log types to be enabled for export to
// CloudWatch Logs for a specific DB instance or DB cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs will be
// exported (or not exported) to CloudWatch Logs.
//
// Valid log types are: audit (to publish audit logs) and slowquery (to publish
// slow-query logs). See [Publishing Neptune logs to Amazon CloudWatch logs].
//
// [Publishing Neptune logs to Amazon CloudWatch logs]: https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html
type CloudwatchLogsExportConfiguration struct {

	// The list of log types to disable.
	DisableLogTypes []string

	// The list of log types to enable.
	EnableLogTypes []string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the ModifyDBCluster operation
// and contains changes that will be applied during the next maintenance window.
type ClusterPendingModifiedValues struct {

	// The allocated storage size in gibibytes (GiB) for database engines. For
	// Neptune, AllocatedStorage always returns 1, because Neptune DB cluster storage
	// size isn't fixed, but instead automatically adjusts as needed.
	AllocatedStorage *int32

	// The number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int32

	// The DBClusterIdentifier value for the DB cluster.
	DBClusterIdentifier *string

	// The database engine version.
	EngineVersion *string

	// A value that indicates whether mapping of Amazon Web Services Identity and
	// Access Management (IAM) accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool

	// The Provisioned IOPS (I/O operations per second) value. This setting is only
	// for Multi-AZ DB clusters.
	Iops *int32

	// This PendingCloudwatchLogsExports structure specifies pending changes to which
	// CloudWatch logs are enabled and which are disabled.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports

	// The pending change in storage type for the DB cluster. Valid Values:
	//
	//   - standard – ( the default ) Configures cost-effective database storage for
	//   applications with moderate to small I/O usage.
	//
	//   - iopt1 – Enables [I/O-Optimized storage]that's designed to meet the needs of I/O-intensive graph
	//   workloads that require predictable pricing with low I/O latency and consistent
	//   I/O throughput.
	//
	// Neptune I/O-Optimized storage is only available starting with engine release
	//   1.3.0.0.
	//
	// [I/O-Optimized storage]: https://docs.aws.amazon.com/neptune/latest/userguide/storage-types.html#provisioned-iops-storage
	StorageType *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune DB cluster.
//
// This data type is used as a response element in the DescribeDBClusters.
type DBCluster struct {

	// AllocatedStorage always returns 1, because Neptune DB cluster storage size is
	// not fixed, but instead automatically adjusts as needed.
	AllocatedStorage *int32

	// Provides a list of the Amazon Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a DB
	// cluster grant permission for the DB cluster to access other Amazon services on
	// your behalf.
	AssociatedRoles []DBClusterRole

	// Time at which the DB cluster will be automatically restarted.
	AutomaticRestartTime *time.Time

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// can be created in.
	AvailabilityZones []string

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int32

	// Not supported by Neptune.
	CharacterSetName *string

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time

	//  If set to true , tags are copied to any snapshot of the DB cluster that is
	// created.
	CopyTagsToSnapshot *bool

	// If set to true , the DB cluster can be cloned across accounts.
	CrossAccountClone *bool

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []DBClusterMember

	// Not supported by Neptune.
	DBClusterOptionGroupMemberships []DBClusterOptionGroupStatus

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This same
	// name is returned for the life of the DB cluster.
	DatabaseName *string

	// The Amazon Region-unique, immutable identifier for the DB cluster. This
	// identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key
	// for the DB cluster is accessed.
	DbClusterResourceId *string

	// Indicates whether or not the DB cluster has deletion protection enabled. The
	// database can't be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// Specifies the earliest time to which a database can be restored with
	// point-in-time restore.
	EarliestRestorableTime *time.Time

	// A list of the log types that this DB cluster is configured to export to
	// CloudWatch Logs. Valid log types are: audit (to publish audit logs to
	// CloudWatch) and slowquery (to publish slow-query logs to CloudWatch). See [Publishing Neptune logs to Amazon CloudWatch logs].
	//
	// [Publishing Neptune logs to Amazon CloudWatch logs]: https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html
	EnabledCloudwatchLogsExports []string

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// Contains a user-supplied global database cluster identifier. This identifier is
	// the unique key that identifies a global database.
	GlobalClusterIdentifier *string

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// True if mapping of Amazon Identity and Access Management (IAM) accounts to
	// database accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool

	// The next time you can modify the DB cluster to use the iopt1 storage type.
	IOOptimizedNextAllowedModificationTime *time.Time

	// If StorageEncrypted is true, the Amazon KMS key identifier for the encrypted DB
	// cluster.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with
	// point-in-time restore.
	LatestRestorableTime *time.Time

	// Not supported by Neptune.
	MasterUsername *string

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool

	// This data type is used as a response element in the ModifyDBCluster operation
	// and contains changes that will be applied during the next maintenance window.
	PendingModifiedValues *ClusterPendingModifiedValues

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string

	// Specifies the port that the database engine is listening on.
	Port *int32

	// Specifies the daily time range during which automated backups are created if
	// automated backups are enabled, as determined by the BackupRetentionPeriod .
	PreferredBackupWindow *string

	// Specifies the weekly time range during which system maintenance can occur, in
	// Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string

	// Contains one or more identifiers of the Read Replicas associated with this DB
	// cluster.
	ReadReplicaIdentifiers []string

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Read Replicas that are available in a DB
	// cluster. As clients request new connections to the reader endpoint, Neptune
	// distributes the connection requests among the Read Replicas in the DB cluster.
	// This functionality can help balance your read workload across multiple Read
	// Replicas in your DB cluster.
	//
	// If a failover occurs, and the Read Replica that you are connected to is
	// promoted to be the primary instance, your connection is dropped. To continue
	// sending your read workload to other Read Replicas in the cluster, you can then
	// reconnect to the reader endpoint.
	ReaderEndpoint *string

	// Not supported by Neptune.
	ReplicationSourceIdentifier *string

	// Shows the scaling configuration for a Neptune Serverless DB cluster.
	//
	// For more information, see [Using Amazon Neptune Serverless] in the Amazon Neptune User Guide.
	//
	// [Using Amazon Neptune Serverless]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html
	ServerlessV2ScalingConfiguration *ServerlessV2ScalingConfigurationInfo

	// Specifies the current state of this DB cluster.
	Status *string

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool

	// The storage type used by the DB cluster.
	//
	// Valid Values:
	//
	//   - standard – ( the default ) Provides cost-effective database storage for
	//   applications with moderate to small I/O usage.
	//
	//   - iopt1 – Enables [I/O-Optimized storage]that's designed to meet the needs of I/O-intensive graph
	//   workloads that require predictable pricing with low I/O latency and consistent
	//   I/O throughput.
	//
	// Neptune I/O-Optimized storage is only available starting with engine release
	//   1.3.0.0.
	//
	// [I/O-Optimized storage]: https://docs.aws.amazon.com/neptune/latest/userguide/storage-types.html#provisioned-iops-storage
	StorageType *string

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// This data type represents the information you need to connect to an Amazon
// Neptune DB cluster. This data type is used as a response element in the
// following actions:
//
//   - CreateDBClusterEndpoint
//
//   - DescribeDBClusterEndpoints
//
//   - ModifyDBClusterEndpoint
//
//   - DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon Neptune DB instance endpoints,
// see Endpoint .
type DBClusterEndpoint struct {

	// The type associated with a custom endpoint. One of: READER , WRITER , ANY .
	CustomEndpointType *string

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string

	// The identifier associated with the endpoint. This parameter is stored as a
	// lowercase string.
	DBClusterEndpointIdentifier *string

	// A unique system-generated identifier for an endpoint. It remains the same for
	// the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string

	// The DB cluster identifier of the DB cluster associated with the endpoint. This
	// parameter is stored as a lowercase string.
	DBClusterIdentifier *string

	// The DNS address of the endpoint.
	Endpoint *string

	// The type of the endpoint. One of: READER , WRITER , CUSTOM .
	EndpointType *string

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []string

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []string

	// The current status of the endpoint. One of: creating , available , deleting ,
	// inactive , modifying . The inactive state applies to an endpoint that cannot be
	// used for a certain kind of cluster, such as a writer endpoint for a read-only
	// secondary cluster in a global database.
	Status *string

	noSmithyDocumentSerde
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {

	// Specifies the status of the DB cluster parameter group for this member of the
	// DB cluster.
	DBClusterParameterGroupStatus *string

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string

	// Value that is true if the cluster member is the primary instance for the DB
	// cluster and false otherwise.
	IsClusterWriter *bool

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int32

	noSmithyDocumentSerde
}

// Not supported by Neptune.
type DBClusterOptionGroupStatus struct {

	// Not supported by Neptune.
	DBClusterOptionGroupName *string

	// Not supported by Neptune.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune DB cluster parameter group.
//
// This data type is used as a response element in the DescribeDBClusterParameterGroups action.
type DBClusterParameterGroup struct {

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string

	// Provides the name of the DB parameter group family that this DB cluster
	// parameter group is compatible with.
	DBParameterGroupFamily *string

	// Provides the customer-specified description for this DB cluster parameter group.
	Description *string

	noSmithyDocumentSerde
}

// Describes an Amazon Identity and Access Management (IAM) role that is
// associated with a DB cluster.
type DBClusterRole struct {

	// The name of the feature associated with the Amazon Identity and Access
	// Management (IAM) role. For the list of supported feature names, see DescribeDBEngineVersions.
	FeatureName *string

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
	// cluster.
	RoleArn *string

	// Describes the state of association between the IAM role and the DB cluster. The
	// Status property returns one of the following values:
	//
	//   - ACTIVE - the IAM role ARN is associated with the DB cluster and can be used
	//   to access other Amazon services on your behalf.
	//
	//   - PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//   - INVALID - the IAM role ARN is associated with the DB cluster, but the DB
	//   cluster is unable to assume the IAM role in order to access other Amazon
	//   services on your behalf.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details for an Amazon Neptune DB cluster snapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots action.
type DBClusterSnapshot struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int32

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// snapshot can be restored in.
	AvailabilityZones []string

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string

	// Specifies the identifier for a DB cluster snapshot. Must match the identifier
	// of an existing snapshot.
	//
	// After you restore a DB cluster using a DBClusterSnapshotIdentifier , you must
	// specify the same DBClusterSnapshotIdentifier for any future updates to the DB
	// cluster. When you specify this property for an update, the DB cluster is not
	// restored from the snapshot again, and the data in the database is not changed.
	//
	// However, if you don't specify the DBClusterSnapshotIdentifier , an empty DB
	// cluster is created, and the original DB cluster is deleted. If you specify a
	// property that is different from the previous snapshot restore property, the DB
	// cluster is restored from the snapshot specified by the
	// DBClusterSnapshotIdentifier , and the original DB cluster is deleted.
	DBClusterSnapshotIdentifier *string

	// Specifies the name of the database engine.
	Engine *string

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string

	// True if mapping of Amazon Identity and Access Management (IAM) accounts to
	// database accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool

	// If StorageEncrypted is true, the Amazon KMS key identifier for the encrypted DB
	// cluster snapshot.
	KmsKeyId *string

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string

	// Not supported by Neptune.
	MasterUsername *string

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int32

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int32

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string

	// If the DB cluster snapshot was copied from a source DB cluster snapshot, the
	// Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null
	// value.
	SourceDBClusterSnapshotArn *string

	// Specifies the status of this DB cluster snapshot.
	Status *string

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool

	// The storage type associated with the DB cluster snapshot.
	StorageType *string

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other Amazon
// accounts to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
type DBClusterSnapshotAttribute struct {

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of Amazon accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more
	// information, see the ModifyDBClusterSnapshotAttributeAPI action.
	AttributeName *string

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore , then this element returns a list
	// of IDs of the Amazon accounts that are authorized to copy or restore the manual
	// DB cluster snapshot. If a value of all is in the list, then the manual DB
	// cluster snapshot is public and available for any Amazon account to copy or
	// restore.
	AttributeValues []string

	noSmithyDocumentSerde
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes API action.
//
// Manual DB cluster snapshot attributes are used to authorize other Amazon
// accounts to copy or restore a manual DB cluster snapshot. For more information,
// see the ModifyDBClusterSnapshotAttributeAPI action.
type DBClusterSnapshotAttributesResult struct {

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []DBClusterSnapshotAttribute

	// The identifier of the manual DB cluster snapshot that the attributes apply to.
	DBClusterSnapshotIdentifier *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {

	// The description of the database engine.
	DBEngineDescription *string

	// The description of the database engine version.
	DBEngineVersionDescription *string

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string

	//  (Not supported by Neptune)
	DefaultCharacterSet *CharacterSet

	// The name of the database engine.
	Engine *string

	// The version number of the database engine.
	EngineVersion *string

	// The types of logs that the database engine has available for export to
	// CloudWatch Logs.
	ExportableLogTypes []string

	//  (Not supported by Neptune)
	SupportedCharacterSets []CharacterSet

	// A list of the time zones supported by this engine for the Timezone parameter of
	// the CreateDBInstance action.
	SupportedTimezones []Timezone

	// A value that indicates whether you can use Aurora global databases with a
	// specific DB engine version.
	SupportsGlobalDatabases *bool

	// A value that indicates whether the engine version supports exporting the log
	// types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool

	// Indicates whether the database engine version supports read replicas.
	SupportsReadReplica *bool

	// A list of engine versions that this database engine version can be upgraded to.
	ValidUpgradeTarget []UpgradeTarget

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune DB instance.
//
// This data type is used as a response element in the DescribeDBInstances action.
type DBInstance struct {

	// Not supported by Neptune.
	AllocatedStorage *int32

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int32

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string

	//  (Not supported by Neptune)
	CharacterSetName *string

	// Specifies whether tags are copied from the DB instance to snapshots of the DB
	// instance.
	CopyTagsToSnapshot *bool

	// If the DB instance is a member of a DB cluster, contains the name of the DB
	// cluster that the DB instance is a member of.
	DBClusterIdentifier *string

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string

	// Contains a user-supplied database identifier. This identifier is the unique key
	// that identifies a DB instance.
	DBInstanceIdentifier *string

	// Specifies the current state of this database.
	DBInstanceStatus *string

	// The database name.
	DBName *string

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []DBParameterGroupStatus

	//  Provides List of DB security group elements containing only
	// DBSecurityGroup.Name and DBSecurityGroup.Status subelements.
	DBSecurityGroups []DBSecurityGroupMembership

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup

	// Specifies the port that the DB instance listens on. If the DB instance is part
	// of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int32

	// The Amazon Region-unique, immutable identifier for the DB instance. This
	// identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key
	// for the DB instance is accessed.
	DbiResourceId *string

	// Indicates whether or not the DB instance has deletion protection enabled. The
	// instance can't be deleted when deletion protection is enabled. See [Deleting a DB Instance].
	//
	// [Deleting a DB Instance]: https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html
	DeletionProtection *bool

	// Not supported
	DomainMemberships []DomainMembership

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudwatchLogsExports []string

	// Specifies the connection endpoint.
	Endpoint *Endpoint

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string

	// True if Amazon Identity and Access Management (IAM) authentication is enabled,
	// and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int32

	//  Not supported: The encryption for DB instances is managed by the DB cluster.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with
	// point-in-time restore.
	LatestRestorableTime *time.Time

	// License model information for this DB instance.
	LicenseModel *string

	// Not supported by Neptune.
	MasterUsername *string

	// The interval, in seconds, between points when Enhanced Monitoring metrics are
	// collected for the DB instance.
	MonitoringInterval *int32

	// The ARN for the IAM role that permits Neptune to send Enhanced Monitoring
	// metrics to Amazon CloudWatch Logs.
	MonitoringRoleArn *string

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool

	//  (Not supported by Neptune)
	OptionGroupMemberships []OptionGroupMembership

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by
	// subelements.
	PendingModifiedValues *PendingModifiedValues

	//  (Not supported by Neptune)
	PerformanceInsightsEnabled *bool

	//  (Not supported by Neptune)
	PerformanceInsightsKMSKeyId *string

	//  Specifies the daily time range during which automated backups are created if
	// automated backups are enabled, as determined by the BackupRetentionPeriod .
	PreferredBackupWindow *string

	// Specifies the weekly time range during which system maintenance can occur, in
	// Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int32

	// Indicates whether the DB instance is publicly accessible.
	//
	// When the DB instance is publicly accessible and you connect from outside of the
	// DB instance's virtual private cloud (VPC), its Domain Name System (DNS) endpoint
	// resolves to the public IP address. When you connect from within the same VPC as
	// the DB instance, the endpoint resolves to the private IP address. Access to the
	// DB instance is ultimately controlled by the security group it uses. That public
	// access isn't permitted if the security group assigned to the DB cluster doesn't
	// permit it.
	//
	// When the DB instance isn't publicly accessible, it is an internal DB instance
	// with a DNS name that resolves to a private IP address.
	PubliclyAccessible *bool

	// Contains one or more identifiers of DB clusters that are Read Replicas of this
	// DB instance.
	ReadReplicaDBClusterIdentifiers []string

	// Contains one or more identifiers of the Read Replicas associated with this DB
	// instance.
	ReadReplicaDBInstanceIdentifiers []string

	// Contains the identifier of the source DB instance if this DB instance is a Read
	// Replica.
	ReadReplicaSourceDBInstanceIdentifier *string

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string

	// The status of a Read Replica. If the instance is not a Read Replica, this is
	// blank.
	StatusInfos []DBInstanceStatusInfo

	// Not supported: The encryption for DB instances is managed by the DB cluster.
	StorageEncrypted *bool

	// Specifies the storage type associated with the DB instance.
	StorageType *string

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string

	// Not supported.
	Timezone *string

	// Provides a list of VPC security group elements that the DB instance belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {

	// Details of the error if there is an error for the instance. If the instance is
	// not in an error state, this value is blank.
	Message *string

	// Boolean value that is true if the instance is operating normally, or false if
	// the instance is in an error state.
	Normal *bool

	// Status of the DB instance. For a StatusType of read replica, the values can be
	// replicating, error, stopped, or terminated.
	Status *string

	// This value is currently "read replication."
	StatusType *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune DB parameter group.
//
// This data type is used as a response element in the DescribeDBParameterGroups action.
type DBParameterGroup struct {

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string

	// Provides the name of the DB parameter group family that this DB parameter group
	// is compatible with.
	DBParameterGroupFamily *string

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string

	// Provides the customer-specified description for this DB parameter group.
	Description *string

	noSmithyDocumentSerde
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
// # CreateDBInstance
//
// # DeleteDBInstance
//
// # ModifyDBInstance
//
// RebootDBInstance
type DBParameterGroupStatus struct {

	// The name of the DP parameter group.
	DBParameterGroupName *string

	// The status of parameter updates.
	ParameterApplyStatus *string

	noSmithyDocumentSerde
}

// Specifies membership in a designated DB security group.
type DBSecurityGroupMembership struct {

	// The name of the DB security group.
	DBSecurityGroupName *string

	// The status of the DB security group.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune DB subnet group.
//
// This data type is used as a response element in the DescribeDBSubnetGroups action.
type DBSubnetGroup struct {

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string

	// The name of the DB subnet group.
	DBSubnetGroupName *string

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string

	//  Contains a list of Subnet elements.
	Subnets []Subnet

	// Provides the VpcId of the DB subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// An Active Directory Domain membership record associated with a DB instance.
type DomainMembership struct {

	// The identifier of the Active Directory Domain.
	Domain *string

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string

	// The status of the DB instance's Active Directory Domain membership, such as
	// joined, pending-join, failed etc).
	Status *string

	noSmithyDocumentSerde
}

// A range of double values.
type DoubleRange struct {

	// The minimum value in the range.
	From *float64

	// The maximum value in the range.
	To *float64

	noSmithyDocumentSerde
}

// Specifies a connection endpoint.
//
// For the data structure that represents Amazon Neptune DB cluster endpoints, see
// DBClusterEndpoint .
type Endpoint struct {

	// Specifies the DNS address of the DB instance.
	Address *string

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// Specifies the port that the database engine is listening on.
	Port *int32

	noSmithyDocumentSerde
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters action.
type EngineDefaults struct {

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string

	//  An optional pagination token provided by a previous EngineDefaults request. If
	// this parameter is specified, the response includes only records beyond the
	// marker, up to the value specified by MaxRecords .
	Marker *string

	// Contains a list of engine default parameters.
	Parameters []Parameter

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeEvents action.
type Event struct {

	// Specifies the date and time of the event.
	Date *time.Time

	// Specifies the category for the event.
	EventCategories []string

	// Provides the text of this event.
	Message *string

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string

	// Provides the identifier for the source of the event.
	SourceIdentifier *string

	// Specifies the source type for this event.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Contains the results of a successful invocation of the DescribeEventCategories action.
type EventCategoriesMap struct {

	// The event categories for the specified source type
	EventCategories []string

	// The source type that the returned categories belong to
	SourceType *string

	noSmithyDocumentSerde
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions action.
type EventSubscription struct {

	// The event notification subscription Id.
	CustSubscriptionId *string

	// The Amazon customer account associated with the event notification subscription.
	CustomerAwsId *string

	// A Boolean value indicating if the subscription is enabled. True indicates the
	// subscription is enabled.
	Enabled *bool

	// A list of event categories for the event notification subscription.
	EventCategoriesList []string

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string

	// The topic ARN of the event notification subscription.
	SnsTopicArn *string

	// A list of source IDs for the event notification subscription.
	SourceIdsList []string

	// The source type for the event notification subscription.
	SourceType *string

	// The status of the event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active |
	// no-permission | topic-not-exist
	//
	// The status "no-permission" indicates that Neptune no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic was
	// deleted after the subscription was created.
	Status *string

	// The time the event notification subscription was created.
	SubscriptionCreationTime *string

	noSmithyDocumentSerde
}

// Contains the state of scheduled or in-process operations on a global cluster
// (Neptune global database). This data type is empty unless a switchover or
// failover operation is scheduled or is in progress on the Neptune global
// database.
type FailoverState struct {

	// The Amazon Resource Name (ARN) of the Neptune DB cluster that is currently
	// being demoted, and which is associated with this state.
	FromDbClusterArn *string

	// Indicates whether the operation is a global switchover or a global failover. If
	// data loss is allowed, then the operation is a global failover. Otherwise, it's a
	// switchover.
	IsDataLossAllowed *bool

	// The current status of the global cluster. Possible values are as follows:
	//
	//   - pending  The service received a request to switch over or fail over the
	//   global cluster. The global cluster's primary DB cluster and the specified
	//   secondary DB cluster are being verified before the operation starts.
	//
	//   - failing-over  Neptune is promoting the chosen secondary Neptune DB cluster
	//   to become the new primary DB cluster to fail over the global cluster.
	//
	//   - cancelling  The request to switch over or fail over the global cluster was
	//   cancelled and the primary Neptune DB cluster and the selected secondary Neptune
	//   DB cluster are returning to their previous states.
	//
	//   - switching-over  This status covers the range of Neptune internal
	//   operations that take place during the switchover process, such as demoting the
	//   primary Neptune DB cluster, promoting the secondary Neptune DB cluster, and
	//   synchronizing replicas.
	Status FailoverStatus

	// The Amazon Resource Name (ARN) of the Neptune DB cluster that is currently
	// being promoted, and which is associated with this state.
	ToDbClusterArn *string

	noSmithyDocumentSerde
}

// This type is not currently supported.
type Filter struct {

	// This parameter is not currently supported.
	//
	// This member is required.
	Name *string

	// This parameter is not currently supported.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Neptune global database.
//
// This data type is used as a response element for the CreateGlobalCluster, DescribeGlobalClusters, ModifyGlobalCluster, DeleteGlobalCluster, FailoverGlobalCluster, and RemoveFromGlobalCluster actions.
type GlobalCluster struct {

	// The deletion protection setting for the global database.
	DeletionProtection *bool

	// The Neptune database engine used by the global database ( "neptune" ).
	Engine *string

	// The Neptune engine version used by the global database.
	EngineVersion *string

	// A data object containing all properties for the current state of an in-process
	// or pending switchover or failover process for this global cluster (Neptune
	// global database). This object is empty unless the SwitchoverGlobalCluster or
	// FailoverGlobalCluster operation was called on this global cluster.
	FailoverState *FailoverState

	// The Amazon Resource Name (ARN) for the global database.
	GlobalClusterArn *string

	// Contains a user-supplied global database cluster identifier. This identifier is
	// the unique key that identifies a global database.
	GlobalClusterIdentifier *string

	// A list of cluster ARNs and instance ARNs for all the DB clusters that are part
	// of the global database.
	GlobalClusterMembers []GlobalClusterMember

	// An immutable identifier for the global database that is unique within in all
	// regions. This identifier is found in CloudTrail log entries whenever the KMS key
	// for the DB cluster is accessed.
	GlobalClusterResourceId *string

	// Specifies the current state of this global database.
	Status *string

	// The storage encryption setting for the global database.
	StorageEncrypted *bool

	noSmithyDocumentSerde
}

//	A data structure with information about any primary and secondary clusters
//
// associated with an Neptune global database.
type GlobalClusterMember struct {

	//  The Amazon Resource Name (ARN) for each Neptune cluster.
	DBClusterArn *string

	//  Specifies whether the Neptune cluster is the primary cluster (that is, has
	// read-write capability) for the Neptune global database with which it is
	// associated.
	IsWriter *bool

	//  The Amazon Resource Name (ARN) for each read-only secondary cluster associated
	// with the Neptune global database.
	Readers []string

	noSmithyDocumentSerde
}

// Not supported by Neptune.
type OptionGroupMembership struct {

	// Not supported by Neptune.
	OptionGroupName *string

	// Not supported by Neptune.
	Status *string

	noSmithyDocumentSerde
}

// Contains a list of available options for a DB instance.
//
// This data type is used as a response element in the DescribeOrderableDBInstanceOptions action.
type OrderableDBInstanceOption struct {

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []AvailabilityZone

	// The DB instance class for a DB instance.
	DBInstanceClass *string

	// The engine type of a DB instance.
	Engine *string

	// The engine version of a DB instance.
	EngineVersion *string

	// The license model for a DB instance.
	LicenseModel *string

	// Maximum total provisioned IOPS for a DB instance.
	MaxIopsPerDbInstance *int32

	// Maximum provisioned IOPS per GiB for a DB instance.
	MaxIopsPerGib *float64

	// Maximum storage size for a DB instance.
	MaxStorageSize *int32

	// Minimum total provisioned IOPS for a DB instance.
	MinIopsPerDbInstance *int32

	// Minimum provisioned IOPS per GiB for a DB instance.
	MinIopsPerGib *float64

	// Minimum storage size for a DB instance.
	MinStorageSize *int32

	// Indicates whether a DB instance is Multi-AZ capable.
	MultiAZCapable *bool

	// Indicates whether a DB instance can have a Read Replica.
	ReadReplicaCapable *bool

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	StorageType *string

	// Indicates whether a DB instance supports Enhanced Monitoring at intervals from
	// 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool

	// A value that indicates whether you can use Neptune global databases with a
	// specific combination of other DB engine attributes.
	SupportsGlobalDatabases *bool

	// Indicates whether a DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication *bool

	// Indicates whether a DB instance supports provisioned IOPS.
	SupportsIops *bool

	//  (Not supported by Neptune)
	SupportsPerformanceInsights *bool

	// Indicates whether a DB instance supports encrypted storage.
	SupportsStorageEncryption *bool

	// Indicates whether a DB instance is in a VPC.
	Vpc *bool

	noSmithyDocumentSerde
}

// Specifies a parameter.
type Parameter struct {

	// Specifies the valid range of values for the parameter.
	AllowedValues *string

	// Indicates when to apply parameter updates.
	ApplyMethod ApplyMethod

	// Specifies the engine specific parameters type.
	ApplyType *string

	// Specifies the valid data type for the parameter.
	DataType *string

	// Provides a description of the parameter.
	Description *string

	//  Indicates whether ( true ) or not ( false ) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// Specifies the name of the parameter.
	ParameterName *string

	// Specifies the value of the parameter.
	ParameterValue *string

	// Indicates the source of the parameter value.
	Source *string

	noSmithyDocumentSerde
}

// A list of the log types whose configuration is still pending. In other words,
// these log types are in the process of being activated or deactivated.
//
// Valid log types are: audit (to publish audit logs) and slowquery (to publish
// slow-query logs). See [Publishing Neptune logs to Amazon CloudWatch logs].
//
// [Publishing Neptune logs to Amazon CloudWatch logs]: https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html
type PendingCloudwatchLogsExports struct {

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to CloudWatch Logs.
	LogTypesToDisable []string

	// Log types that are in the process of being deactivated. After they are
	// deactivated, these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []string

	noSmithyDocumentSerde
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {

	// The type of pending maintenance action that is available for the resource.
	Action *string

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after this
	// date. If this date is specified, any next-maintenance opt-in requests are
	// ignored.
	AutoAppliedAfterDate *time.Time

	// The effective date when the pending maintenance action is applied to the
	// resource. This date takes into account opt-in requests received from the ApplyPendingMaintenanceActionAPI,
	// the AutoAppliedAfterDate , and the ForcedApplyDate . This value is blank if an
	// opt-in request has not been received and nothing has been specified as
	// AutoAppliedAfterDate or ForcedApplyDate .
	CurrentApplyDate *time.Time

	// A description providing more detail about the maintenance action.
	Description *string

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the ModifyDBInstance action.
type PendingModifiedValues struct {

	//  Contains the new AllocatedStorage size for the DB instance that will be
	// applied or is currently being applied.
	AllocatedStorage *int32

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int32

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string

	//  Contains the new DBInstanceClass for the DB instance that will be applied or
	// is currently being applied.
	DBInstanceClass *string

	//  Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string

	// Indicates the database engine version.
	EngineVersion *string

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is currently being applied.
	Iops *int32

	// Not supported by Neptune.
	LicenseModel *string

	// Not supported by Neptune.
	MasterUserPassword *string

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool

	// This PendingCloudwatchLogsExports structure specifies pending changes to which
	// CloudWatch logs are enabled and which are disabled.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports

	// Specifies the pending port for the DB instance.
	Port *int32

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	StorageType *string

	noSmithyDocumentSerde
}

// A range of integer values.
type Range struct {

	// The minimum value in the range.
	From *int32

	// The step value for the range. For example, if you have a range of 5,000 to
	// 10,000, with a step value of 1,000, the valid values start at 5,000 and step up
	// by 1,000. Even though 7,500 is within the range, it isn't a valid value for the
	// range. The valid values are 5,000, 6,000, 7,000, 8,000...
	Step *int32

	// The maximum value in the range.
	To *int32

	noSmithyDocumentSerde
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []PendingMaintenanceAction

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string

	noSmithyDocumentSerde
}

// Contains the scaling configuration of a Neptune Serverless DB cluster.
//
// For more information, see [Using Amazon Neptune Serverless] in the Amazon Neptune User Guide.
//
// [Using Amazon Neptune Serverless]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html
type ServerlessV2ScalingConfiguration struct {

	// The maximum number of Neptune capacity units (NCUs) for a DB instance in a
	// Neptune Serverless cluster. You can specify NCU values in half-step increments,
	// such as 40, 40.5, 41, and so on.
	MaxCapacity *float64

	// The minimum number of Neptune capacity units (NCUs) for a DB instance in a
	// Neptune Serverless cluster. You can specify NCU values in half-step increments,
	// such as 8, 8.5, 9, and so on.
	MinCapacity *float64

	noSmithyDocumentSerde
}

// Shows the scaling configuration for a Neptune Serverless DB cluster.
//
// For more information, see [Using Amazon Neptune Serverless] in the Amazon Neptune User Guide.
//
// [Using Amazon Neptune Serverless]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html
type ServerlessV2ScalingConfigurationInfo struct {

	// The maximum number of Neptune capacity units (NCUs) for a DB instance in a
	// Neptune Serverless cluster. You can specify NCU values in half-step increments,
	// such as 40, 40.5, 41, and so on.
	MaxCapacity *float64

	// The minimum number of Neptune capacity units (NCUs) for a DB instance in a
	// Neptune Serverless cluster. You can specify NCU values in half-step increments,
	// such as 8, 8.5, 9, and so on.
	MinCapacity *float64

	noSmithyDocumentSerde
}

// Specifies a subnet.
//
// This data type is used as a response element in the DescribeDBSubnetGroups action.
type Subnet struct {

	// Specifies the EC2 Availability Zone that the subnet is in.
	SubnetAvailabilityZone *AvailabilityZone

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string

	// Specifies the status of the subnet.
	SubnetStatus *string

	noSmithyDocumentSerde
}

// Metadata assigned to an Amazon Neptune resource consisting of a key-value pair.
type Tag struct {

	// A key is the required name of the tag. The string value can be from 1 to 128
	// Unicode characters in length and can't be prefixed with aws: or rds: . The
	// string can only contain the set of Unicode letters, digits, white-space, '_',
	// '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string

	// A value is the optional value of the tag. The string value can be from 1 to 256
	// Unicode characters in length and can't be prefixed with aws: or rds: . The
	// string can only contain the set of Unicode letters, digits, white-space, '_',
	// '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string

	noSmithyDocumentSerde
}

// A time zone associated with a DBInstance.
type Timezone struct {

	// The name of the time zone.
	TimezoneName *string

	noSmithyDocumentSerde
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {

	// A value that indicates whether the target version is applied to any source DB
	// instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string

	// The name of the upgrade target database engine.
	Engine *string

	// The version number of the upgrade target database engine.
	EngineVersion *string

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool

	// A value that indicates whether you can use Neptune global databases with the
	// target engine version.
	SupportsGlobalDatabases *bool

	noSmithyDocumentSerde
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the DescribeValidDBInstanceModificationsaction. You can use this
// information when you call ModifyDBInstance.
type ValidDBInstanceModificationsMessage struct {

	// Valid storage options for your DB instance.
	Storage []ValidStorageOptions

	noSmithyDocumentSerde
}

// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
type ValidStorageOptions struct {

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	IopsToStorageRatio []DoubleRange

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	ProvisionedIops []Range

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	StorageSize []Range

	// Not applicable. In Neptune the storage type is managed at the DB Cluster level.
	StorageType *string

	noSmithyDocumentSerde
}

// This data type is used as a response element for queries on VPC security group
// membership.
type VpcSecurityGroupMembership struct {

	// The status of the VPC security group.
	Status *string

	// The name of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
