// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a workflow, including its configuration,
// status, and metadata.
func (c *Client) GetWorkflow(ctx context.Context, params *GetWorkflowInput, optFns ...func(*Options)) (*GetWorkflowOutput, error) {
	if params == nil {
		params = &GetWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWorkflow", params, optFns, c.addOperationGetWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWorkflowInput struct {

	// The Amazon Resource Name (ARN) of the workflow you want to retrieve.
	//
	// This member is required.
	WorkflowArn *string

	// Optional. The specific version of the workflow to retrieve. If not specified,
	// the latest version is returned.
	WorkflowVersion *string

	noSmithyDocumentSerde
}

type GetWorkflowOutput struct {

	// The Amazon Resource Name (ARN) of the workflow.
	//
	// This member is required.
	WorkflowArn *string

	// The timestamp when the workflow was created, in ISO 8601 date-time format.
	CreatedAt *time.Time

	// The Amazon S3 location of the workflow definition file.
	DefinitionS3Location *types.DefinitionS3Location

	// The description of the workflow.
	Description *string

	// The encryption configuration for the workflow.
	EncryptionConfiguration *types.EncryptionConfiguration

	// The version of the Amazon Managed Workflows for Apache Airflow Serverless
	// engine that this workflow uses.
	EngineVersion types.EngineVersion

	// The logging configuration for the workflow.
	LoggingConfiguration *types.LoggingConfiguration

	// The timestamp when the workflow was last modified, in ISO 8601 date-time format.
	ModifiedAt *time.Time

	// The name of the workflow.
	Name *string

	// The network configuration for the workflow execution environment.
	NetworkConfiguration *types.NetworkConfiguration

	// The Amazon Resource Name (ARN) of the IAM role used for workflow execution.
	RoleArn *string

	// The schedule configuration for the workflow, including cron expressions for
	// automated execution. Amazon Managed Workflows for Apache Airflow Serverless uses
	// EventBridge Scheduler for cost-effective, timezone-aware scheduling. When a
	// workflow includes schedule information in its YAML definition, the service
	// automatically configures the appropriate triggers for automated execution. Only
	// one version of a workflow can have an active schedule at any given time.
	ScheduleConfiguration *types.ScheduleConfiguration

	// The trigger mode for the workflow execution.
	TriggerMode *string

	// The workflow definition content.
	WorkflowDefinition *string

	// The current status of the workflow.
	WorkflowStatus types.WorkflowStatus

	// The version identifier of the workflow.
	WorkflowVersion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetWorkflow",
	}
}
