// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Access configuration parameters.
type AccessConfiguration struct {

	// The type of authentication used to access content from
	// HttpConfiguration::BaseUrl on your source location.
	//
	// S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted
	// virtual-style access. If your source location base URL is an Amazon S3 bucket,
	// MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the
	// bucket where your source content is stored. Your MediaTailor source location
	// baseURL must follow the S3 virtual hosted-style request URL format. For example,
	// https://bucket-name.s3.Region.amazonaws.com/key-name.
	//
	// Before you can use S3_SIGV4 , you must meet these requirements:
	//
	// • You must allow MediaTailor to access your S3 bucket by granting
	// mediatailor.amazonaws.com principal access in IAM. For information about
	// configuring access in IAM, see Access management in the IAM User Guide.
	//
	// • The mediatailor.amazonaws.com service principal must have permissions to read
	// all top level manifests referenced by the VodSource packaging configurations.
	//
	// • The caller of the API must have s3:GetObject IAM permissions to read all top
	// level manifests referenced by your MediaTailor VodSource packaging
	// configurations.
	//
	// AUTODETECT_SIGV4 - AWS Signature Version 4 authentication for a set of
	// supported services: MediaPackage Version 2 and Amazon S3 hosted virtual-style
	// access. If your source location base URL is a MediaPackage Version 2 endpoint or
	// an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
	// authentication to access the resource where your source content is stored.
	//
	// Before you can use AUTODETECT_SIGV4 with a MediaPackage Version 2 endpoint, you
	// must meet these requirements:
	//
	// • You must grant MediaTailor access to your MediaPackage endpoint by granting
	// mediatailor.amazonaws.com principal access in an Origin Access policy on the
	// endpoint.
	//
	// • Your MediaTailor source location base URL must be a MediaPackage V2 endpoint.
	//
	// • The caller of the API must have mediapackagev2:GetObject IAM permissions to
	// read all top level manifests referenced by the MediaTailor source packaging
	// configurations.
	//
	// Before you can use AUTODETECT_SIGV4 with an Amazon S3 bucket, you must meet
	// these requirements:
	//
	// • You must grant MediaTailor access to your S3 bucket by granting
	// mediatailor.amazonaws.com principal access in IAM. For more information about
	// configuring access in IAM, see [Access management]in the IAM User Guide..
	//
	// • The mediatailor.amazonaws.com service principal must have permissions to read
	// all top-level manifests referenced by the VodSource packaging configurations.
	//
	// • The caller of the API must have s3:GetObject IAM permissions to read all top
	// level manifests referenced by your MediaTailor VodSource packaging
	// configurations.
	//
	// [Access management]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html
	AccessType AccessType

	// AWS Secrets Manager access token configuration parameters.
	SecretsManagerAccessTokenConfiguration *SecretsManagerAccessTokenConfiguration

	noSmithyDocumentSerde
}

// Ad break configuration parameters.
type AdBreak struct {

	// How long (in milliseconds) after the beginning of the program that an ad
	// starts. This value must fall within 100ms of a segment boundary, otherwise the
	// ad break will be skipped.
	//
	// This member is required.
	OffsetMillis int64

	// Defines a list of key/value pairs that MediaTailor generates within the
	// EXT-X-ASSET tag for SCTE35_ENHANCED output.
	AdBreakMetadata []KeyValuePair

	// The SCTE-35 ad insertion type. Accepted value: SPLICE_INSERT , TIME_SIGNAL .
	MessageType MessageType

	// Ad break slate configuration.
	Slate *SlateSource

	// This defines the SCTE-35 splice_insert() message inserted around the ad. For
	// information about using splice_insert() , see the SCTE-35 specficiaiton, section
	// 9.7.3.1.
	SpliceInsertMessage *SpliceInsertMessage

	// Defines the SCTE-35 time_signal message inserted around the ad.
	//
	// Programs on a channel's schedule can be configured with one or more ad breaks.
	// You can attach a splice_insert SCTE-35 message to the ad break. This message
	// provides basic metadata about the ad break.
	//
	// See section 9.7.4 of the 2022 SCTE-35 specification for more information.
	TimeSignalMessage *TimeSignalMessage

	noSmithyDocumentSerde
}

// A location at which a zero-duration ad marker was detected in a VOD source
// manifest.
type AdBreakOpportunity struct {

	// The offset in milliseconds from the start of the VOD source at which an ad
	// marker was detected.
	//
	// This member is required.
	OffsetMillis int64

	noSmithyDocumentSerde
}

// The setting that indicates what conditioning MediaTailor will perform on ads
// that the ad decision server (ADS) returns.
type AdConditioningConfiguration struct {

	// For ads that have media files with streaming delivery and supported file
	// extensions, indicates what transcoding action MediaTailor takes when it first
	// receives these ads from the ADS. TRANSCODE indicates that MediaTailor must
	// transcode the ads. NONE indicates that you have already transcoded the ads
	// outside of MediaTailor and don't need them transcoded as part of the ad
	// insertion workflow. For more information about ad conditioning see [Using preconditioned ads]in the
	// Elemental MediaTailor user guide.
	//
	// [Using preconditioned ads]: https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html
	//
	// This member is required.
	StreamingMediaFileConditioning StreamingMediaFileConditioning

	noSmithyDocumentSerde
}

// For HLS, when set to true , MediaTailor passes through EXT-X-CUE-IN ,
// EXT-X-CUE-OUT , and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin
// manifest to the MediaTailor personalized manifest.
//
// No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a
// value of 60 , but no ads are filled for that ad break, MediaTailor will not set
// the value to 0 .
type AdMarkerPassthrough struct {

	// Enables ad marker passthrough for your configuration.
	Enabled bool

	noSmithyDocumentSerde
}

// Settings for customizing what events are included in logs for interactions with
// the ad decision server (ADS).
//
// For more information about ADS logs, inlcuding descriptions of the event types,
// see [MediaTailor ADS logs description and event types]in Elemental MediaTailor User Guide.
//
// [MediaTailor ADS logs description and event types]: https://docs.aws.amazon.com/mediatailor/latest/ug/ads-log-format.html
type AdsInteractionLog struct {

	// Indicates that MediaTailor won't emit the selected events in the logs for
	// playback sessions that are initialized with this configuration.
	ExcludeEventTypes []AdsInteractionExcludeEventType

	// Indicates that MediaTailor emits RAW_ADS_RESPONSE logs for playback sessions
	// that are initialized with this configuration.
	PublishOptInEventTypes []AdsInteractionPublishOptInEventType

	noSmithyDocumentSerde
}

// Alert configuration parameters.
type Alert struct {

	// The code for the alert. For example, NOT_PROCESSED .
	//
	// This member is required.
	AlertCode *string

	// If an alert is generated for a resource, an explanation of the reason for the
	// alert.
	//
	// This member is required.
	AlertMessage *string

	// The timestamp when the alert was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Names (ARNs) related to this alert.
	//
	// This member is required.
	RelatedResourceArns []string

	// The Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	ResourceArn *string

	// The category that MediaTailor assigns to the alert.
	Category AlertCategory

	noSmithyDocumentSerde
}

// A playlist of media (VOD and/or live) to be played instead of the default media
// on a particular program.
type AlternateMedia struct {

	// Ad break configuration parameters defined in AlternateMedia.
	AdBreaks []AdBreak

	// Clip range configuration for the VOD source associated with the program.
	ClipRange *ClipRange

	// The duration of the alternateMedia in milliseconds.
	DurationMillis *int64

	// The name of the live source for alternateMedia.
	LiveSourceName *string

	// The date and time that the alternateMedia is scheduled to start, in epoch
	// milliseconds.
	ScheduledStartTimeMillis *int64

	// The name of the source location for alternateMedia.
	SourceLocationName *string

	// The name of the VOD source for alternateMedia.
	VodSourceName *string

	noSmithyDocumentSerde
}

// An AudienceMedia object contains an Audience and a list of AlternateMedia.
type AudienceMedia struct {

	// The list of AlternateMedia defined in AudienceMedia.
	AlternateMedia []AlternateMedia

	// The Audience defined in AudienceMedia.
	Audience *string

	noSmithyDocumentSerde
}

// MediaTailor only places (consumes) prefetched ads if the ad break meets the
// criteria defined by the dynamic variables. This gives you granular control over
// which ad break to place the prefetched ads into.
//
// As an example, let's say that you set DynamicVariable to scte.event_id and
// Operator to EQUALS , and your playback configuration has an ADS URL of
// https://my.ads.server.com/path?&podId=[scte.avail_num]&event=[scte.event_id]&duration=[session.avail_duration_secs]
// . And the prefetch request to the ADS contains these values
// https://my.ads.server.com/path?&podId=3&event=my-awesome-event&duration=30 .
// MediaTailor will only insert the prefetched ads into the ad break if has a SCTE
// marker with an event id of my-awesome-event , since it must match the event id
// that MediaTailor uses to query the ADS.
//
// You can specify up to five AvailMatchingCriteria . If you specify multiple
// AvailMatchingCriteria , MediaTailor combines them to match using a logical AND .
// You can model logical OR combinations by creating multiple prefetch schedules.
type AvailMatchingCriteria struct {

	// The dynamic variable(s) that MediaTailor should use as avail matching criteria.
	// MediaTailor only places the prefetched ads into the avail if the avail matches
	// the criteria defined by the dynamic variable. For information about dynamic
	// variables, see [Using dynamic ad variables]in the MediaTailor User Guide.
	//
	// You can include up to 100 dynamic variables.
	//
	// [Using dynamic ad variables]: https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html
	//
	// This member is required.
	DynamicVariable *string

	// For the DynamicVariable specified in AvailMatchingCriteria , the Operator that
	// is used for the comparison.
	//
	// This member is required.
	Operator Operator

	noSmithyDocumentSerde
}

// The configuration for avail suppression, also known as ad suppression. For more
// information about ad suppression, see [Ad Suppression].
//
// [Ad Suppression]: https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html
type AvailSuppression struct {

	// Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE
	// will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be
	// used to invoke partial ad break fills when a session starts mid-break.
	FillPolicy FillPolicy

	// Sets the ad suppression mode. By default, ad suppression is off and all ad
	// breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE , ad
	// suppression is active and MediaTailor won't fill ad breaks on or behind the ad
	// suppression Value time in the manifest lookback window. When Mode is set to
	// AFTER_LIVE_EDGE , ad suppression is active and MediaTailor won't fill ad breaks
	// that are within the live edge plus the avail suppression value.
	Mode Mode

	// A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or
	// behind this time in the manifest lookback window. If Value is set to 00:00:00,
	// it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or
	// behind the live edge. If you set a Value time, MediaTailor won't fill any ad
	// breaks on or behind this time in the manifest lookback window. For example, if
	// you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45
	// minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes
	// behind the live edge.
	Value *string

	noSmithyDocumentSerde
}

// The configuration for bumpers. Bumpers are short audio or video clips that play
// at the start or before the end of an ad break. To learn more about bumpers, see [Bumpers]
// .
//
// [Bumpers]: https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html
type Bumper struct {

	// The URL for the end bumper asset.
	EndUrl *string

	// The URL for the start bumper asset.
	StartUrl *string

	noSmithyDocumentSerde
}

// The configuration for using a content delivery network (CDN), like Amazon
// CloudFront, for content and ad segment management.
type CdnConfiguration struct {

	// A non-default content delivery network (CDN) to serve ad segments. By default,
	// AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as
	// its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN
	// for the origin ads.mediatailor.<region>.amazonaws.com. Then specify the rule's
	// name in this AdSegmentUrlPrefix . When AWS Elemental MediaTailor serves a
	// manifest, it reports your CDN as the source for ad segments.
	AdSegmentUrlPrefix *string

	// A content delivery network (CDN) to cache content segments, so that content
	// requests don’t always have to go to the origin server. First, create a rule in
	// your CDN for the content segment origin server. Then specify the rule's name in
	// this ContentSegmentUrlPrefix . When AWS Elemental MediaTailor serves a manifest,
	// it reports your CDN as the source for content segments.
	ContentSegmentUrlPrefix *string

	noSmithyDocumentSerde
}

// The configuration parameters for a channel. For information about MediaTailor
// channels, see [Working with channels]in the MediaTailor User Guide.
//
// [Working with channels]: https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html
type Channel struct {

	// The ARN of the channel.
	//
	// This member is required.
	Arn *string

	// The name of the channel.
	//
	// This member is required.
	ChannelName *string

	// Returns the state whether the channel is running or not.
	//
	// This member is required.
	ChannelState *string

	// The log configuration.
	//
	// This member is required.
	LogConfiguration *LogConfigurationForChannel

	// The channel's output properties.
	//
	// This member is required.
	Outputs []ResponseOutputItem

	// The type of playback mode for this channel.
	//
	// LINEAR - Programs play back-to-back only once.
	//
	// LOOP - Programs play back-to-back in an endless loop. When the last program in
	// the schedule plays, playback loops back to the first program in the schedule.
	//
	// This member is required.
	PlaybackMode *string

	// The tier for this channel. STANDARD tier channels can contain live programs.
	//
	// This member is required.
	Tier *string

	// The list of audiences defined in channel.
	Audiences []string

	// The timestamp of when the channel was created.
	CreationTime *time.Time

	// The slate used to fill gaps between programs in the schedule. You must
	// configure filler slate if your channel uses the LINEAR PlaybackMode .
	// MediaTailor doesn't support filler slate for channels using the LOOP PlaybackMode
	// .
	FillerSlate *SlateSource

	// The timestamp of when the channel was last modified.
	LastModifiedTime *time.Time

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control, and
	// cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources].
	//
	// [Tagging AWS Elemental MediaTailor Resources]: https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// Clip range configuration for the VOD source associated with the program.
type ClipRange struct {

	// The end offset of the clip range, in milliseconds, starting from the beginning
	// of the VOD source associated with the program.
	EndOffsetMillis *int64

	// The start offset of the clip range, in milliseconds. This offset truncates the
	// start at the number of milliseconds into the duration of the VOD source.
	StartOffsetMillis *int64

	noSmithyDocumentSerde
}

// The configuration for DASH content.
type DashConfiguration struct {

	// The URL generated by MediaTailor to initiate a playback session. The session
	// uses server-side reporting. This setting is ignored in PUT operations.
	ManifestEndpointPrefix *string

	// The setting that controls whether MediaTailor includes the Location tag in DASH
	// manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT . The
	// EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
	MpdLocation *string

	// The setting that controls whether MediaTailor handles manifests from the origin
	// server as multi-period manifests or single-period manifests. If your origin
	// server produces single-period manifests, set this to SINGLE_PERIOD . The default
	// setting is MULTI_PERIOD . For multi-period manifests, omit this setting or set
	// it to MULTI_PERIOD .
	OriginManifestType OriginManifestType

	noSmithyDocumentSerde
}

// The configuration for DASH PUT operations.
type DashConfigurationForPut struct {

	// The setting that controls whether MediaTailor includes the Location tag in DASH
	// manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT . The
	// EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
	MpdLocation *string

	// The setting that controls whether MediaTailor handles manifests from the origin
	// server as multi-period manifests or single-period manifests. If your origin
	// server produces single-period manifests, set this to SINGLE_PERIOD . The default
	// setting is MULTI_PERIOD . For multi-period manifests, omit this setting or set
	// it to MULTI_PERIOD .
	OriginManifestType OriginManifestType

	noSmithyDocumentSerde
}

// Dash manifest configuration parameters.
type DashPlaylistSettings struct {

	// The total duration (in seconds) of each manifest. Minimum value: 30 seconds.
	// Maximum value: 3600 seconds.
	ManifestWindowSeconds *int32

	// Minimum amount of content (measured in seconds) that a player must keep
	// available in the buffer. Minimum value: 2 seconds. Maximum value: 60 seconds.
	MinBufferTimeSeconds *int32

	// Minimum amount of time (in seconds) that the player should wait before
	// requesting updates to the manifest. Minimum value: 2 seconds. Maximum value: 60
	// seconds.
	MinUpdatePeriodSeconds *int32

	// Amount of time (in seconds) that the player should be from the live point at
	// the end of the manifest. Minimum value: 2 seconds. Maximum value: 60 seconds.
	SuggestedPresentationDelaySeconds *int32

	noSmithyDocumentSerde
}

// The optional configuration for a server that serves segments. Use this if you
// want the segment delivery server to be different from the source location
// server. For example, you can configure your source location server to be an
// origination server, such as MediaPackage, and the segment delivery server to be
// a content delivery network (CDN), such as CloudFront. If you don't specify a
// segment delivery server, then the source location server is used.
type DefaultSegmentDeliveryConfiguration struct {

	// The hostname of the server that will be used to serve segments. This string
	// must include the protocol, such as https://.
	BaseUrl *string

	noSmithyDocumentSerde
}

// The configuration for HLS content.
type HlsConfiguration struct {

	// The URL that is used to initiate a playback session for devices that support
	// Apple HLS. The session uses server-side reporting.
	ManifestEndpointPrefix *string

	noSmithyDocumentSerde
}

// HLS playlist configuration parameters.
type HlsPlaylistSettings struct {

	// Determines the type of SCTE 35 tags to use in ad markup. Specify DATERANGE to
	// use DATERANGE tags (for live or VOD content). Specify SCTE35_ENHANCED to use
	// EXT-X-CUE-OUT and EXT-X-CUE-IN tags (for VOD content only).
	AdMarkupType []AdMarkupType

	// The total duration (in seconds) of each manifest. Minimum value: 30 seconds.
	// Maximum value: 3600 seconds.
	ManifestWindowSeconds *int32

	noSmithyDocumentSerde
}

// The HTTP configuration for the source location.
type HttpConfiguration struct {

	// The base URL for the source location host server. This string must include the
	// protocol, such as https://.
	//
	// This member is required.
	BaseUrl *string

	noSmithyDocumentSerde
}

// The HTTP package configuration properties for the requested VOD source.
type HttpPackageConfiguration struct {

	// The relative path to the URL for this VOD source. This is combined with
	// SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.
	//
	// This member is required.
	Path *string

	// The name of the source group. This has to match one of the
	// Channel::Outputs::SourceGroup .
	//
	// This member is required.
	SourceGroup *string

	// The streaming protocol for this package configuration. Supported values are HLS
	// and DASH .
	//
	// This member is required.
	Type Type

	noSmithyDocumentSerde
}

// For SCTE35_ENHANCED output, defines a key and corresponding value. MediaTailor
// generates these pairs within the EXT-X-ASSET tag.
type KeyValuePair struct {

	// For SCTE35_ENHANCED output, defines a key. MediaTailor takes this key, and its
	// associated value, and generates the key/value pair within the EXT-X-ASSET tag.
	// If you specify a key, you must also specify a corresponding value.
	//
	// This member is required.
	Key *string

	// For SCTE35_ENHANCED output, defines a value. MediaTailor; takes this value, and
	// its associated key, and generates the key/value pair within the EXT-X-ASSET tag.
	// If you specify a value, you must also specify a corresponding key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The configuration for pre-roll ad insertion.
type LivePreRollConfiguration struct {

	// The URL for the ad decision server (ADS) for pre-roll ads. This includes the
	// specification of static parameters and placeholders for dynamic parameters. AWS
	// Elemental MediaTailor substitutes player-specific and session-specific
	// parameters as needed when calling the ADS. Alternately, for testing, you can
	// provide a static VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string

	// The maximum allowed duration for the pre-roll ad avail. AWS Elemental
	// MediaTailor won't play pre-roll ads to exceed this duration, regardless of the
	// total duration of ads that the ADS returns.
	MaxDurationSeconds *int32

	noSmithyDocumentSerde
}

// Live source configuration parameters.
type LiveSource struct {

	// The ARN for the live source.
	//
	// This member is required.
	Arn *string

	// The HTTP package configurations for the live source.
	//
	// This member is required.
	HttpPackageConfigurations []HttpPackageConfiguration

	// The name that's used to refer to a live source.
	//
	// This member is required.
	LiveSourceName *string

	// The name of the source location.
	//
	// This member is required.
	SourceLocationName *string

	// The timestamp that indicates when the live source was created.
	CreationTime *time.Time

	// The timestamp that indicates when the live source was last modified.
	LastModifiedTime *time.Time

	// The tags assigned to the live source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control, and
	// cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources].
	//
	// [Tagging AWS Elemental MediaTailor Resources]: https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// Defines where AWS Elemental MediaTailor sends logs for the playback
// configuration.
type LogConfiguration struct {

	// The method used for collecting logs from AWS Elemental MediaTailor.
	// LEGACY_CLOUDWATCH indicates that MediaTailor is sending logs directly to Amazon
	// CloudWatch Logs. VENDED_LOGS indicates that MediaTailor is sending logs to
	// CloudWatch, which then vends the logs to your destination of choice. Supported
	// destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
	// Firehose stream.
	//
	// This member is required.
	EnabledLoggingStrategies []LoggingStrategy

	// The percentage of session logs that MediaTailor sends to your configured log
	// destination. For example, if your playback configuration has 1000 sessions and
	// percentEnabled is set to 60 , MediaTailor sends logs for 600 of the sessions to
	// CloudWatch Logs. MediaTailor decides at random which of the playback
	// configuration sessions to send logs for. If you want to view logs for a specific
	// session, you can use the [debug log mode].
	//
	// Valid values: 0 - 100
	//
	// [debug log mode]: https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html
	//
	// This member is required.
	PercentEnabled int32

	// Settings for customizing what events are included in logs for interactions with
	// the ad decision server (ADS).
	AdsInteractionLog *AdsInteractionLog

	// Settings for customizing what events are included in logs for interactions with
	// the origin server.
	ManifestServiceInteractionLog *ManifestServiceInteractionLog

	noSmithyDocumentSerde
}

// The log configuration for the channel.
type LogConfigurationForChannel struct {

	// The log types.
	LogTypes []LogType

	noSmithyDocumentSerde
}

// The configuration for manifest processing rules. Manifest processing rules
// enable customization of the personalized manifests created by MediaTailor.
type ManifestProcessingRules struct {

	// For HLS, when set to true , MediaTailor passes through EXT-X-CUE-IN ,
	// EXT-X-CUE-OUT , and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin
	// manifest to the MediaTailor personalized manifest.
	//
	// No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a
	// value of 60 , but no ads are filled for that ad break, MediaTailor will not set
	// the value to 0 .
	AdMarkerPassthrough *AdMarkerPassthrough

	noSmithyDocumentSerde
}

// Settings for customizing what events are included in logs for interactions with
// the origin server.
//
// For more information about manifest service logs, including descriptions of the
// event types, see [MediaTailor manifest logs description and event types]in Elemental MediaTailor User Guide.
//
// [MediaTailor manifest logs description and event types]: https://docs.aws.amazon.com/mediatailor/latest/ug/log-types.html
type ManifestServiceInteractionLog struct {

	// Indicates that MediaTailor won't emit the selected events in the logs for
	// playback sessions that are initialized with this configuration.
	ExcludeEventTypes []ManifestServiceExcludeEventType

	noSmithyDocumentSerde
}

// A playback configuration. For information about MediaTailor configurations, see [Working with configurations in AWS Elemental MediaTailor]
// .
//
// [Working with configurations in AWS Elemental MediaTailor]: https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html
type PlaybackConfiguration struct {

	// The setting that indicates what conditioning MediaTailor will perform on ads
	// that the ad decision server (ADS) returns, and what priority MediaTailor uses
	// when inserting ads.
	AdConditioningConfiguration *AdConditioningConfiguration

	// The URL for the ad decision server (ADS). This includes the specification of
	// static parameters and placeholders for dynamic parameters. AWS Elemental
	// MediaTailor substitutes player-specific and session-specific parameters as
	// needed when calling the ADS. Alternately, for testing you can provide a static
	// VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string

	// The configuration for avail suppression, also known as ad suppression. For more
	// information about ad suppression, see [Ad Suppression].
	//
	// [Ad Suppression]: https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html
	AvailSuppression *AvailSuppression

	// The configuration for bumpers. Bumpers are short audio or video clips that play
	// at the start or before the end of an ad break. To learn more about bumpers, see [Bumpers]
	// .
	//
	// [Bumpers]: https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html
	Bumper *Bumper

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration

	// The player parameters and aliases used as dynamic variables during session
	// initialization. For more information, see [Domain Variables].
	//
	// [Domain Variables]: https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domains.html
	ConfigurationAliases map[string]map[string]string

	// The configuration for a DASH source.
	DashConfiguration *DashConfiguration

	// The configuration for HLS content.
	HlsConfiguration *HlsConfiguration

	// The setting that controls whether players can use stitched or guided ad
	// insertion. The default, STITCHED_ONLY , forces all player sessions to use
	// stitched (server-side) ad insertion. Choosing PLAYER_SELECT allows players to
	// select either stitched or guided ad insertion at session-initialization time.
	// The default for players that do not specify an insertion mode is stitched.
	InsertionMode InsertionMode

	// The configuration for pre-roll ad insertion.
	LivePreRollConfiguration *LivePreRollConfiguration

	// Defines where AWS Elemental MediaTailor sends logs for the playback
	// configuration.
	LogConfiguration *LogConfiguration

	// The configuration for manifest processing rules. Manifest processing rules
	// enable customization of the personalized manifests created by MediaTailor.
	ManifestProcessingRules *ManifestProcessingRules

	// The identifier for the playback configuration.
	Name *string

	// Defines the maximum duration of underfilled ad time (in seconds) allowed in an
	// ad break. If the duration of underfilled ad time exceeds the personalization
	// threshold, then the personalization of the ad break is abandoned and the
	// underlying content is shown. This feature applies to ad replacement in live and
	// VOD streams, rather than ad insertion, because it relies on an underlying
	// content stream. For more information about ad break behavior, including ad
	// replacement and insertion, see [Ad Behavior in AWS Elemental MediaTailor].
	//
	// [Ad Behavior in AWS Elemental MediaTailor]: https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html
	PersonalizationThresholdSeconds *int32

	// The Amazon Resource Name (ARN) for the playback configuration.
	PlaybackConfigurationArn *string

	// The URL that the player accesses to get a manifest from AWS Elemental
	// MediaTailor.
	PlaybackEndpointPrefix *string

	// The URL that the player uses to initialize a session that uses client-side
	// reporting.
	SessionInitializationEndpointPrefix *string

	// The URL for a video asset to transcode and use to fill in time that's not used
	// by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media
	// content. Configuring the slate is optional for non-VPAID playback
	// configurations. For VPAID, the slate is required because MediaTailor provides it
	// in the slots designated for dynamic ad content. The slate must be a high-quality
	// asset that contains both audio and video.
	SlateAdUrl *string

	// The tags to assign to the playback configuration. Tags are key-value pairs that
	// you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources].
	//
	// [Tagging AWS Elemental MediaTailor Resources]: https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html
	Tags map[string]string

	// The name that is used to associate this playback configuration with a custom
	// transcode profile. This overrides the dynamic transcoding defaults of
	// MediaTailor. Use this only if you have already set up custom profiles with the
	// help of AWS Support.
	TranscodeProfileName *string

	// The URL prefix for the parent manifest for the stream, minus the asset ID. The
	// maximum length is 512 characters.
	VideoContentSourceUrl *string

	noSmithyDocumentSerde
}

// For single prefetch, describes how and when that MediaTailor places prefetched
// ads into upcoming ad breaks.
type PrefetchConsumption struct {

	// The time when MediaTailor no longer considers the prefetched ads for use in an
	// ad break. MediaTailor automatically deletes prefetch schedules no less than
	// seven days after the end time. If you'd like to manually delete the prefetch
	// schedule, you can call DeletePrefetchSchedule .
	//
	// This member is required.
	EndTime *time.Time

	// If you only want MediaTailor to insert prefetched ads into avails (ad breaks)
	// that match specific dynamic variables, such as scte.event_id , set the avail
	// matching criteria.
	AvailMatchingCriteria []AvailMatchingCriteria

	// The time when prefetched ads are considered for use in an ad break. If you
	// don't specify StartTime , the prefetched ads are available after MediaTailor
	// retrieves them from the ad decision server.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A complex type that contains settings governing when MediaTailor prefetches
// ads, and which dynamic variables that MediaTailor includes in the request to the
// ad decision server.
type PrefetchRetrieval struct {

	// The time when prefetch retrieval ends for the ad break. Prefetching will be
	// attempted for manifest requests that occur at or before this time.
	//
	// This member is required.
	EndTime *time.Time

	// The dynamic variables to use for substitution during prefetch requests to the
	// ad decision server (ADS).
	//
	// You initially configure [dynamic variables] for the ADS URL when you set up your playback
	// configuration. When you specify DynamicVariables for prefetch retrieval,
	// MediaTailor includes the dynamic variables in the request to the ADS.
	//
	// [dynamic variables]: https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html
	DynamicVariables map[string]string

	// The time when prefetch retrievals can start for this break. Ad prefetching will
	// be attempted for manifest requests that occur at or after this time. Defaults to
	// the current time. If not specified, the prefetch retrieval starts as soon as
	// possible.
	StartTime *time.Time

	// Configuration for spreading ADS traffic across a set window instead of sending
	// ADS requests for all sessions at the same time.
	TrafficShapingRetrievalWindow *TrafficShapingRetrievalWindow

	// The configuration for TPS-based traffic shaping that limits the number of
	// requests to the ad decision server (ADS) based on transactions per second
	// instead of time windows.
	TrafficShapingTpsConfiguration *TrafficShapingTpsConfiguration

	// Indicates the type of traffic shaping used for prefetch traffic shaping and
	// limiting the number of requests to the ADS at one time.
	TrafficShapingType TrafficShapingType

	noSmithyDocumentSerde
}

// A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain
// ads before an ad break happens. For more information about ad prefetching, see [Using ad prefetching]
// in the MediaTailor User Guide.
//
// [Using ad prefetching]: https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html
type PrefetchSchedule struct {

	// The Amazon Resource Name (ARN) of the prefetch schedule.
	//
	// This member is required.
	Arn *string

	// The name of the prefetch schedule. The name must be unique among all prefetch
	// schedules that are associated with the specified playback configuration.
	//
	// This member is required.
	Name *string

	// The name of the playback configuration to create the prefetch schedule for.
	//
	// This member is required.
	PlaybackConfigurationName *string

	// Consumption settings determine how, and when, MediaTailor places the prefetched
	// ads into ad breaks for single prefetch schedules. Ad consumption occurs within a
	// span of time that you define, called a consumption window. You can designate
	// which ad breaks that MediaTailor fills with prefetch ads by setting avail
	// matching criteria.
	Consumption *PrefetchConsumption

	// The settings that determine how and when MediaTailor prefetches ads and inserts
	// them into ad breaks.
	RecurringPrefetchConfiguration *RecurringPrefetchConfiguration

	// A complex type that contains settings for prefetch retrieval from the ad
	// decision server (ADS).
	Retrieval *PrefetchRetrieval

	// The frequency that MediaTailor creates prefetch schedules. SINGLE indicates
	// that this schedule applies to one ad break. RECURRING indicates that
	// MediaTailor automatically creates a schedule for each ad avail in a live event.
	//
	// For more information about the prefetch types and when you might use each, see [Prefetching ads in Elemental MediaTailor.]
	//
	// [Prefetching ads in Elemental MediaTailor.]: https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html
	ScheduleType PrefetchScheduleType

	// An optional stream identifier that you can specify in order to prefetch for
	// multiple streams that use the same playback configuration.
	StreamId *string

	noSmithyDocumentSerde
}

// The settings that determine how and when MediaTailor places prefetched ads into
// upcoming ad breaks for recurring prefetch scedules.
type RecurringConsumption struct {

	// The configuration for the dynamic variables that determine which ad breaks that
	// MediaTailor inserts prefetched ads in.
	AvailMatchingCriteria []AvailMatchingCriteria

	// The number of seconds that an ad is available for insertion after it was
	// prefetched.
	RetrievedAdExpirationSeconds *int32

	noSmithyDocumentSerde
}

// The configuration that defines how MediaTailor performs recurring prefetch.
type RecurringPrefetchConfiguration struct {

	// The end time for the window that MediaTailor prefetches and inserts ads in a
	// live event.
	//
	// This member is required.
	EndTime *time.Time

	// The settings that determine how and when MediaTailor places prefetched ads into
	// upcoming ad breaks for recurring prefetch scedules.
	//
	// This member is required.
	RecurringConsumption *RecurringConsumption

	// The configuration for prefetch ad retrieval from the ADS.
	//
	// This member is required.
	RecurringRetrieval *RecurringRetrieval

	// The start time for the window that MediaTailor prefetches and inserts ads in a
	// live event.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// With recurring prefetch, MediaTailor automatically prefetches ads for every
// avail that occurs during the retrieval window. The following configurations
// describe the MediaTailor behavior when prefetching ads for a live event.
type RecurringRetrieval struct {

	// The number of seconds that MediaTailor waits after an ad avail before
	// prefetching ads for the next avail. If not set, the default is 0 (no delay).
	DelayAfterAvailEndSeconds *int32

	// The dynamic variables to use for substitution during prefetch requests to the
	// ADS.
	DynamicVariables map[string]string

	// Configuration for spreading ADS traffic across a set window instead of sending
	// ADS requests for all sessions at the same time.
	TrafficShapingRetrievalWindow *TrafficShapingRetrievalWindow

	// The configuration for TPS-based traffic shaping that limits the number of
	// requests to the ad decision server (ADS) based on transactions per second
	// instead of time windows.
	TrafficShapingTpsConfiguration *TrafficShapingTpsConfiguration

	// Indicates the type of traffic shaping used for traffic shaping and limiting the
	// number of requests to the ADS at one time.
	TrafficShapingType TrafficShapingType

	noSmithyDocumentSerde
}

// The output configuration for this channel.
type RequestOutputItem struct {

	// The name of the manifest for the channel. The name appears in the PlaybackUrl .
	//
	// This member is required.
	ManifestName *string

	// A string used to match which HttpPackageConfiguration is used for each VodSource
	// .
	//
	// This member is required.
	SourceGroup *string

	// DASH manifest configuration parameters.
	DashPlaylistSettings *DashPlaylistSettings

	// HLS playlist configuration parameters.
	HlsPlaylistSettings *HlsPlaylistSettings

	noSmithyDocumentSerde
}

// The output item response.
type ResponseOutputItem struct {

	// The name of the manifest for the channel that will appear in the channel
	// output's playback URL.
	//
	// This member is required.
	ManifestName *string

	// The URL used for playback by content players.
	//
	// This member is required.
	PlaybackUrl *string

	// A string used to associate a package configuration source group with a channel
	// output.
	//
	// This member is required.
	SourceGroup *string

	// DASH manifest configuration settings.
	DashPlaylistSettings *DashPlaylistSettings

	// HLS manifest configuration settings.
	HlsPlaylistSettings *HlsPlaylistSettings

	noSmithyDocumentSerde
}

// The schedule's ad break properties.
type ScheduleAdBreak struct {

	// The approximate duration of the ad break, in seconds.
	ApproximateDurationSeconds *int64

	// The approximate time that the ad will start playing.
	ApproximateStartTime *time.Time

	// The name of the source location containing the VOD source used for the ad break.
	SourceLocationName *string

	// The name of the VOD source used for the ad break.
	VodSourceName *string

	noSmithyDocumentSerde
}

// Schedule configuration parameters. A channel must be stopped before changes can
// be made to the schedule.
type ScheduleConfiguration struct {

	// Program transition configurations.
	//
	// This member is required.
	Transition *Transition

	// Program clip range configuration.
	ClipRange *ClipRange

	noSmithyDocumentSerde
}

// The properties for a schedule.
type ScheduleEntry struct {

	// The ARN of the program.
	//
	// This member is required.
	Arn *string

	// The name of the channel that uses this schedule.
	//
	// This member is required.
	ChannelName *string

	// The name of the program.
	//
	// This member is required.
	ProgramName *string

	// The name of the source location.
	//
	// This member is required.
	SourceLocationName *string

	// The approximate duration of this program, in seconds.
	ApproximateDurationSeconds *int64

	// The approximate time that the program will start playing.
	ApproximateStartTime *time.Time

	// The list of audiences defined in ScheduleEntry.
	Audiences []string

	// The name of the live source used for the program.
	LiveSourceName *string

	// The schedule's ad break properties.
	ScheduleAdBreaks []ScheduleAdBreak

	// The type of schedule entry.
	ScheduleEntryType ScheduleEntryType

	// The name of the VOD source.
	VodSourceName *string

	noSmithyDocumentSerde
}

// AWS Secrets Manager access token configuration parameters. For information
// about Secrets Manager access token authentication, see [Working with AWS Secrets Manager access token authentication].
//
// [Working with AWS Secrets Manager access token authentication]: https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html
type SecretsManagerAccessTokenConfiguration struct {

	// The name of the HTTP header used to supply the access token in requests to the
	// source location.
	HeaderName *string

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the access token.
	SecretArn *string

	// The AWS Secrets Manager [SecretString] key associated with the access token. MediaTailor uses
	// the key to look up SecretString key and value pair containing the access token.
	//
	// [SecretString]: https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html
	SecretStringKey *string

	noSmithyDocumentSerde
}

// The segmentation_descriptor message can contain advanced metadata fields, like
// content identifiers, to convey a wide range of information about the ad break.
// MediaTailor writes the ad metadata in the egress manifest as part of the
// EXT-X-DATERANGE or EventStream ad marker's SCTE-35 data.
//
// segmentation_descriptor messages must be sent with the time_signal message type.
//
// See the segmentation_descriptor() table of the 2022 SCTE-35 specification for
// more information.
type SegmentationDescriptor struct {

	// The segment number to assign to the segmentation_descriptor.segment_num
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values
	// must be between 0 and 256, inclusive. The default value is 0.
	SegmentNum *int32

	// The Event Identifier to assign to the
	// segmentation_descriptor.segmentation_event_id message, as defined in section
	// 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
	SegmentationEventId *int32

	// The Type Identifier to assign to the
	// segmentation_descriptor.segmentation_type_id message, as defined in section
	// 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
	// inclusive. The default value is 48.
	SegmentationTypeId *int32

	// The Upid to assign to the segmentation_descriptor.segmentation_upid message, as
	// defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be
	// a hexadecimal string containing only the characters 0 though 9 and A through F.
	// The default value is "" (an empty string).
	SegmentationUpid *string

	// The Upid Type to assign to the segmentation_descriptor.segmentation_upid_type
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The default value is 14.
	SegmentationUpidType *int32

	// The number of segments expected, which is assigned to the
	// segmentation_descriptor.segments_expectedS message, as defined in section
	// 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256,
	// inclusive. The default value is 0.
	SegmentsExpected *int32

	// The sub-segment number to assign to the segmentation_descriptor.sub_segment_num
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The defualt value is null.
	SubSegmentNum *int32

	// The number of sub-segments expected, which is assigned to the
	// segmentation_descriptor.sub_segments_expected message, as defined in section
	// 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
	// inclusive. The default value is null.
	SubSegmentsExpected *int32

	noSmithyDocumentSerde
}

// The segment delivery configuration settings.
type SegmentDeliveryConfiguration struct {

	// The base URL of the host or path of the segment delivery server that you're
	// using to serve segments. This is typically a content delivery network (CDN). The
	// URL can be absolute or relative. To use an absolute URL include the protocol,
	// such as https://example.com/some/path . To use a relative URL specify the
	// relative path, such as /some/path* .
	BaseUrl *string

	// A unique identifier used to distinguish between multiple segment delivery
	// configurations in a source location.
	Name *string

	noSmithyDocumentSerde
}

// Slate VOD source configuration.
type SlateSource struct {

	// The name of the source location where the slate VOD source is stored.
	SourceLocationName *string

	// The slate VOD source name. The VOD source must already exist in a source
	// location before it can be used for slate.
	VodSourceName *string

	noSmithyDocumentSerde
}

// A source location is a container for sources. For more information about source
// locations, see [Working with source locations]in the MediaTailor User Guide.
//
// [Working with source locations]: https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html
type SourceLocation struct {

	// The ARN of the SourceLocation.
	//
	// This member is required.
	Arn *string

	// The HTTP configuration for the source location.
	//
	// This member is required.
	HttpConfiguration *HttpConfiguration

	// The name of the source location.
	//
	// This member is required.
	SourceLocationName *string

	// The access configuration for the source location.
	AccessConfiguration *AccessConfiguration

	// The timestamp that indicates when the source location was created.
	CreationTime *time.Time

	// The default segment delivery configuration.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration

	// The timestamp that indicates when the source location was last modified.
	LastModifiedTime *time.Time

	// The segment delivery configurations for the source location.
	SegmentDeliveryConfigurations []SegmentDeliveryConfiguration

	// The tags assigned to the source location. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control, and
	// cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources].
	//
	// [Tagging AWS Elemental MediaTailor Resources]: https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// Splice insert message configuration.
type SpliceInsertMessage struct {

	// This is written to splice_insert.avail_num , as defined in section 9.7.3.1 of
	// the SCTE-35 specification. The default value is 0 . Values must be between 0
	// and 256 , inclusive.
	AvailNum *int32

	// This is written to splice_insert.avails_expected , as defined in section 9.7.3.1
	// of the SCTE-35 specification. The default value is 0 . Values must be between 0
	// and 256 , inclusive.
	AvailsExpected *int32

	// This is written to splice_insert.splice_event_id , as defined in section 9.7.3.1
	// of the SCTE-35 specification. The default value is 1 .
	SpliceEventId *int32

	// This is written to splice_insert.unique_program_id , as defined in section
	// 9.7.3.1 of the SCTE-35 specification. The default value is 0 . Values must be
	// between 0 and 256 , inclusive.
	UniqueProgramId *int32

	noSmithyDocumentSerde
}

// The configuration for time-shifted viewing.
type TimeShiftConfiguration struct {

	//  The maximum time delay for time-shifted viewing. The minimum allowed maximum
	// time delay is 0 seconds, and the maximum allowed maximum time delay is 21600
	// seconds (6 hours).
	//
	// This member is required.
	MaxTimeDelaySeconds *int32

	noSmithyDocumentSerde
}

// The SCTE-35 time_signal message can be sent with one or more
// segmentation_descriptor messages. A time_signal message can be sent only if a
// single segmentation_descriptor message is sent.
//
// The time_signal message contains only the splice_time field which is
// constructed using a given presentation timestamp. When sending a time_signal
// message, the splice_command_type field in the splice_info_section message is
// set to 6 (0x06).
//
// See the time_signal() table of the 2022 SCTE-35 specification for more
// information.
type TimeSignalMessage struct {

	// The configurations for the SCTE-35 segmentation_descriptor message(s) sent with
	// the time_signal message.
	SegmentationDescriptors []SegmentationDescriptor

	noSmithyDocumentSerde
}

// The configuration that tells Elemental MediaTailor how to spread out requests
// to the ad decision server (ADS). Instead of sending ADS requests for all
// sessions at the same time, MediaTailor spreads the requests across the amount of
// time specified in the retrieval window.
type TrafficShapingRetrievalWindow struct {

	// The amount of time, in seconds, that MediaTailor spreads prefetch requests to
	// the ADS.
	RetrievalWindowDurationSeconds *int32

	noSmithyDocumentSerde
}

// The configuration for TPS-based traffic shaping. This approach limits requests
// to the ad decision server (ADS) based on transactions per second and concurrent
// users, providing more intuitive capacity management compared to time-window
// based traffic shaping.
type TrafficShapingTpsConfiguration struct {

	// The expected peak number of concurrent viewers for your content. MediaTailor
	// uses this value along with peak TPS to determine how to distribute prefetch
	// requests across the available capacity without exceeding your ADS limits.
	PeakConcurrentUsers *int32

	// The maximum number of transactions per second (TPS) that your ad decision
	// server (ADS) can handle. MediaTailor uses this value along with concurrent users
	// and headroom multiplier to calculate optimal traffic distribution and prevent
	// ADS overload.
	PeakTps *int32

	noSmithyDocumentSerde
}

// Program transition configuration.
type Transition struct {

	// The position where this program will be inserted relative to the
	// RelativePosition .
	//
	// This member is required.
	RelativePosition RelativePosition

	// Defines when the program plays in the schedule. You can set the value to
	// ABSOLUTE or RELATIVE .
	//
	// ABSOLUTE - The program plays at a specific wall clock time. This setting can
	// only be used for channels using the LINEAR PlaybackMode .
	//
	// Note the following considerations when using ABSOLUTE transitions:
	//
	// If the preceding program in the schedule has a duration that extends past the
	// wall clock time, MediaTailor truncates the preceding program on a common segment
	// boundary.
	//
	// If there are gaps in playback, MediaTailor plays the FillerSlate you configured
	// for your linear channel.
	//
	// RELATIVE - The program is inserted into the schedule either before or after a
	// program that you specify via RelativePosition .
	//
	// This member is required.
	Type *string

	// The duration of the live program in seconds.
	DurationMillis *int64

	// The name of the program that this program will be inserted next to, as defined
	// by RelativePosition .
	RelativeProgram *string

	// The date and time that the program is scheduled to start, in epoch milliseconds.
	ScheduledStartTimeMillis *int64

	noSmithyDocumentSerde
}

// Schedule configuration parameters.
type UpdateProgramScheduleConfiguration struct {

	// Program clip range configuration.
	ClipRange *ClipRange

	// Program transition configuration.
	Transition *UpdateProgramTransition

	noSmithyDocumentSerde
}

// Program transition configuration.
type UpdateProgramTransition struct {

	// The duration of the live program in seconds.
	DurationMillis *int64

	// The date and time that the program is scheduled to start, in epoch milliseconds.
	ScheduledStartTimeMillis *int64

	noSmithyDocumentSerde
}

// VOD source configuration parameters.
type VodSource struct {

	// The ARN for the VOD source.
	//
	// This member is required.
	Arn *string

	// The HTTP package configurations for the VOD source.
	//
	// This member is required.
	HttpPackageConfigurations []HttpPackageConfiguration

	// The name of the source location that the VOD source is associated with.
	//
	// This member is required.
	SourceLocationName *string

	// The name of the VOD source.
	//
	// This member is required.
	VodSourceName *string

	// The timestamp that indicates when the VOD source was created.
	CreationTime *time.Time

	// The timestamp that indicates when the VOD source was last modified.
	LastModifiedTime *time.Time

	// The tags assigned to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control, and
	// cost tracking. For more information, see [Tagging AWS Elemental MediaTailor Resources].
	//
	// [Tagging AWS Elemental MediaTailor Resources]: https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
