// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Delete a Network. The Network must have no resources associated with it.
func (c *Client) DeleteNetwork(ctx context.Context, params *DeleteNetworkInput, optFns ...func(*Options)) (*DeleteNetworkOutput, error) {
	if params == nil {
		params = &DeleteNetworkInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteNetwork", params, optFns, c.addOperationDeleteNetworkMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteNetworkOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for DeleteNetworkRequest
type DeleteNetworkInput struct {

	// The ID of the network.
	//
	// This member is required.
	NetworkId *string

	noSmithyDocumentSerde
}

// Placeholder documentation for DeleteNetworkResponse
type DeleteNetworkOutput struct {

	// The ARN of this Network. It is automatically assigned when the Network is
	// created.
	Arn *string

	// Placeholder documentation for __listOf__string
	AssociatedClusterIds []string

	// The ID of the Network. Unique in the AWS account. The ID is the resource-id
	// portion of the ARN.
	Id *string

	// An array of IpPools in your organization's network that identify a collection
	// of IP addresses in this network that are reserved for use in MediaLive Anywhere.
	// MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and
	// NAT networks) and for output destinations (only in Bridge networks). Each IpPool
	// specifies one CIDR block.
	IpPools []types.IpPool

	// The name that you specified for the Network.
	Name *string

	// An array of routes that MediaLive Anywhere needs to know about in order to
	// route encoding traffic.
	Routes []types.Route

	// The current state of the Network. Only MediaLive Anywhere can change the state.
	State types.NetworkState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteNetworkMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteNetwork{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteNetwork{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteNetwork"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteNetworkValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteNetwork(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteNetwork(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteNetwork",
	}
}
