// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAddBridgeOutputs struct {
}

func (*awsRestjson1_serializeOpAddBridgeOutputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddBridgeOutputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddBridgeOutputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddBridgeOutputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddBridgeOutputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddBridgeOutputsInput(v *AddBridgeOutputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddBridgeOutputsInput(v *AddBridgeOutputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddBridgeSources struct {
}

func (*awsRestjson1_serializeOpAddBridgeSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddBridgeSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddBridgeSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddBridgeSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddBridgeSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddBridgeSourcesInput(v *AddBridgeSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddBridgeSourcesInput(v *AddBridgeSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowMediaStreams struct {
}

func (*awsRestjson1_serializeOpAddFlowMediaStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowMediaStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowMediaStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowMediaStreamsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowMediaStreamsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowMediaStreamsInput(v *AddFlowMediaStreamsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowMediaStreamsInput(v *AddFlowMediaStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MediaStreams != nil {
		ok := object.Key("mediaStreams")
		if err := awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v.MediaStreams, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowOutputs struct {
}

func (*awsRestjson1_serializeOpAddFlowOutputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowOutputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowOutputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowOutputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowOutputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowOutputsInput(v *AddFlowOutputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowOutputsInput(v *AddFlowOutputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowSources struct {
}

func (*awsRestjson1_serializeOpAddFlowSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowSourcesInput(v *AddFlowSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowSourcesInput(v *AddFlowSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfSetSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowVpcInterfaces struct {
}

func (*awsRestjson1_serializeOpAddFlowVpcInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowVpcInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowVpcInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/vpcInterfaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowVpcInterfacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowVpcInterfacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowVpcInterfacesInput(v *AddFlowVpcInterfacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowVpcInterfacesInput(v *AddFlowVpcInterfacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcInterfaces != nil {
		ok := object.Key("vpcInterfaces")
		if err := awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v.VpcInterfaces, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetRouterInput struct {
}

func (*awsRestjson1_serializeOpBatchGetRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetRouterInputInput(v *BatchGetRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arns != nil {
		for i := range v.Arns {
			encoder.AddQuery("arns").String(v.Arns[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetRouterNetworkInterface struct {
}

func (*awsRestjson1_serializeOpBatchGetRouterNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetRouterNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetRouterNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterfaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetRouterNetworkInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetRouterNetworkInterfaceInput(v *BatchGetRouterNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arns != nil {
		for i := range v.Arns {
			encoder.AddQuery("arns").String(v.Arns[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetRouterOutput struct {
}

func (*awsRestjson1_serializeOpBatchGetRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetRouterOutputInput(v *BatchGetRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arns != nil {
		for i := range v.Arns {
			encoder.AddQuery("arns").String(v.Arns[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBridge struct {
}

func (*awsRestjson1_serializeOpCreateBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBridgeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBridgeInput(v *CreateBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBridgeInput(v *CreateBridgeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressGatewayBridge != nil {
		ok := object.Key("egressGatewayBridge")
		if err := awsRestjson1_serializeDocumentAddEgressGatewayBridgeRequest(v.EgressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.IngressGatewayBridge != nil {
		ok := object.Key("ingressGatewayBridge")
		if err := awsRestjson1_serializeDocumentAddIngressGatewayBridgeRequest(v.IngressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.PlacementArn != nil {
		ok := object.Key("placementArn")
		ok.String(*v.PlacementArn)
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFlow struct {
}

func (*awsRestjson1_serializeOpCreateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFlowInput(v *CreateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFlowInput(v *CreateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("availabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.Entitlements != nil {
		ok := object.Key("entitlements")
		if err := awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v.Entitlements, ok); err != nil {
			return err
		}
	}

	if len(v.FlowSize) > 0 {
		ok := object.Key("flowSize")
		ok.String(string(v.FlowSize))
	}

	if v.FlowTags != nil {
		ok := object.Key("flowTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.FlowTags, ok); err != nil {
			return err
		}
	}

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentAddMaintenance(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.MediaStreams != nil {
		ok := object.Key("mediaStreams")
		if err := awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v.MediaStreams, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NdiConfig != nil {
		ok := object.Key("ndiConfig")
		if err := awsRestjson1_serializeDocumentNdiConfig(v.NdiConfig, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentSetSourceRequest(v.Source, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceMonitoringConfig != nil {
		ok := object.Key("sourceMonitoringConfig")
		if err := awsRestjson1_serializeDocumentMonitoringConfig(v.SourceMonitoringConfig, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfSetSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	if v.VpcInterfaces != nil {
		ok := object.Key("vpcInterfaces")
		if err := awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v.VpcInterfaces, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGateway struct {
}

func (*awsRestjson1_serializeOpCreateGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGatewayInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGatewayInput(v *CreateGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGatewayInput(v *CreateGatewayInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressCidrBlocks != nil {
		ok := object.Key("egressCidrBlocks")
		if err := awsRestjson1_serializeDocument__listOfString(v.EgressCidrBlocks, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Networks != nil {
		ok := object.Key("networks")
		if err := awsRestjson1_serializeDocument__listOfGatewayNetwork(v.Networks, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRouterInput struct {
}

func (*awsRestjson1_serializeOpCreateRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouterInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouterInputInput(v *CreateRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouterInputInput(v *CreateRouterInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("availabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterInputConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.MaintenanceConfiguration != nil {
		ok := object.Key("maintenanceConfiguration")
		if err := awsRestjson1_serializeDocumentMaintenanceConfiguration(v.MaintenanceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaximumBitrate != nil {
		ok := object.Key("maximumBitrate")
		ok.Long(*v.MaximumBitrate)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RegionName != nil {
		ok := object.Key("regionName")
		ok.String(*v.RegionName)
	}

	if len(v.RoutingScope) > 0 {
		ok := object.Key("routingScope")
		ok.String(string(v.RoutingScope))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Tier) > 0 {
		ok := object.Key("tier")
		ok.String(string(v.Tier))
	}

	if v.TransitEncryption != nil {
		ok := object.Key("transitEncryption")
		if err := awsRestjson1_serializeDocumentRouterInputTransitEncryption(v.TransitEncryption, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRouterNetworkInterface struct {
}

func (*awsRestjson1_serializeOpCreateRouterNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRouterNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouterNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterface")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouterNetworkInterfaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouterNetworkInterfaceInput(v *CreateRouterNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouterNetworkInterfaceInput(v *CreateRouterNetworkInterfaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RegionName != nil {
		ok := object.Key("regionName")
		ok.String(*v.RegionName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRouterOutput struct {
}

func (*awsRestjson1_serializeOpCreateRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouterOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouterOutputInput(v *CreateRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouterOutputInput(v *CreateRouterOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("availabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterOutputConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.MaintenanceConfiguration != nil {
		ok := object.Key("maintenanceConfiguration")
		if err := awsRestjson1_serializeDocumentMaintenanceConfiguration(v.MaintenanceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaximumBitrate != nil {
		ok := object.Key("maximumBitrate")
		ok.Long(*v.MaximumBitrate)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RegionName != nil {
		ok := object.Key("regionName")
		ok.String(*v.RegionName)
	}

	if len(v.RoutingScope) > 0 {
		ok := object.Key("routingScope")
		ok.String(string(v.RoutingScope))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Tier) > 0 {
		ok := object.Key("tier")
		ok.String(string(v.Tier))
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBridge struct {
}

func (*awsRestjson1_serializeOpDeleteBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBridgeInput(v *DeleteBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFlow struct {
}

func (*awsRestjson1_serializeOpDeleteFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFlowInput(v *DeleteFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGateway struct {
}

func (*awsRestjson1_serializeOpDeleteGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways/{GatewayArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGatewayInput(v *DeleteGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayArn == nil || len(*v.GatewayArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayArn must not be empty")}
	}
	if v.GatewayArn != nil {
		if err := encoder.SetURI("GatewayArn").String(*v.GatewayArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouterInput struct {
}

func (*awsRestjson1_serializeOpDeleteRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouterInputInput(v *DeleteRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouterNetworkInterface struct {
}

func (*awsRestjson1_serializeOpDeleteRouterNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouterNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouterNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterface/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouterNetworkInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouterNetworkInterfaceInput(v *DeleteRouterNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouterOutput struct {
}

func (*awsRestjson1_serializeOpDeleteRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouterOutputInput(v *DeleteRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeregisterGatewayInstance struct {
}

func (*awsRestjson1_serializeOpDeregisterGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeregisterGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeregisterGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeregisterGatewayInstanceInput(v *DeregisterGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Force != nil {
		encoder.SetQuery("force").Boolean(*v.Force)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBridge struct {
}

func (*awsRestjson1_serializeOpDescribeBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBridgeInput(v *DescribeBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlow struct {
}

func (*awsRestjson1_serializeOpDescribeFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowInput(v *DescribeFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlowSourceMetadata struct {
}

func (*awsRestjson1_serializeOpDescribeFlowSourceMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlowSourceMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowSourceMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source-metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceMetadataInput(v *DescribeFlowSourceMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlowSourceThumbnail struct {
}

func (*awsRestjson1_serializeOpDescribeFlowSourceThumbnail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlowSourceThumbnail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowSourceThumbnailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source-thumbnail")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceThumbnailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceThumbnailInput(v *DescribeFlowSourceThumbnailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGateway struct {
}

func (*awsRestjson1_serializeOpDescribeGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways/{GatewayArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGatewayInput(v *DescribeGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayArn == nil || len(*v.GatewayArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayArn must not be empty")}
	}
	if v.GatewayArn != nil {
		if err := encoder.SetURI("GatewayArn").String(*v.GatewayArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGatewayInstance struct {
}

func (*awsRestjson1_serializeOpDescribeGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGatewayInstanceInput(v *DescribeGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeOffering struct {
}

func (*awsRestjson1_serializeOpDescribeOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings/{OfferingArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(v *DescribeOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingArn == nil || len(*v.OfferingArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingArn must not be empty")}
	}
	if v.OfferingArn != nil {
		if err := encoder.SetURI("OfferingArn").String(*v.OfferingArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeReservation struct {
}

func (*awsRestjson1_serializeOpDescribeReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/reservations/{ReservationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(v *DescribeReservationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReservationArn == nil || len(*v.ReservationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReservationArn must not be empty")}
	}
	if v.ReservationArn != nil {
		if err := encoder.SetURI("ReservationArn").String(*v.ReservationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouterInput struct {
}

func (*awsRestjson1_serializeOpGetRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouterInputInput(v *GetRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouterInputSourceMetadata struct {
}

func (*awsRestjson1_serializeOpGetRouterInputSourceMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouterInputSourceMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouterInputSourceMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/{Arn}/source-metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouterInputSourceMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouterInputSourceMetadataInput(v *GetRouterInputSourceMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouterInputThumbnail struct {
}

func (*awsRestjson1_serializeOpGetRouterInputThumbnail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouterInputThumbnail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouterInputThumbnailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/{Arn}/thumbnail")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouterInputThumbnailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouterInputThumbnailInput(v *GetRouterInputThumbnailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouterNetworkInterface struct {
}

func (*awsRestjson1_serializeOpGetRouterNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouterNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouterNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterface/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouterNetworkInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouterNetworkInterfaceInput(v *GetRouterNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouterOutput struct {
}

func (*awsRestjson1_serializeOpGetRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouterOutputInput(v *GetRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGrantFlowEntitlements struct {
}

func (*awsRestjson1_serializeOpGrantFlowEntitlements) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGrantFlowEntitlements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GrantFlowEntitlementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGrantFlowEntitlementsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGrantFlowEntitlementsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGrantFlowEntitlementsInput(v *GrantFlowEntitlementsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGrantFlowEntitlementsInput(v *GrantFlowEntitlementsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entitlements != nil {
		ok := object.Key("entitlements")
		if err := awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v.Entitlements, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBridges struct {
}

func (*awsRestjson1_serializeOpListBridges) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBridges) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBridgesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBridgesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBridgesInput(v *ListBridgesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FilterArn != nil {
		encoder.SetQuery("filterArn").String(*v.FilterArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListEntitlements struct {
}

func (*awsRestjson1_serializeOpListEntitlements) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEntitlements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEntitlementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/entitlements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEntitlementsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEntitlementsInput(v *ListEntitlementsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFlows struct {
}

func (*awsRestjson1_serializeOpListFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFlowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFlowsInput(v *ListFlowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGatewayInstances struct {
}

func (*awsRestjson1_serializeOpListGatewayInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGatewayInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGatewayInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGatewayInstancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGatewayInstancesInput(v *ListGatewayInstancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FilterArn != nil {
		encoder.SetQuery("filterArn").String(*v.FilterArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGateways struct {
}

func (*awsRestjson1_serializeOpListGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGatewaysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGatewaysInput(v *ListGatewaysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListOfferings struct {
}

func (*awsRestjson1_serializeOpListOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOfferingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOfferingsInput(v *ListOfferingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListReservations struct {
}

func (*awsRestjson1_serializeOpListReservations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListReservations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReservationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/reservations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListReservationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListReservationsInput(v *ListReservationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRouterInputs struct {
}

func (*awsRestjson1_serializeOpListRouterInputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRouterInputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRouterInputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRouterInputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListRouterInputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRouterInputsInput(v *ListRouterInputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListRouterInputsInput(v *ListRouterInputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentRouterInputFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRouterNetworkInterfaces struct {
}

func (*awsRestjson1_serializeOpListRouterNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRouterNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRouterNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterfaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRouterNetworkInterfacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListRouterNetworkInterfacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRouterNetworkInterfacesInput(v *ListRouterNetworkInterfacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListRouterNetworkInterfacesInput(v *ListRouterNetworkInterfacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRouterOutputs struct {
}

func (*awsRestjson1_serializeOpListRouterOutputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRouterOutputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRouterOutputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRouterOutputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListRouterOutputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRouterOutputsInput(v *ListRouterOutputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListRouterOutputsInput(v *ListRouterOutputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentRouterOutputFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForGlobalResource struct {
}

func (*awsRestjson1_serializeOpListTagsForGlobalResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForGlobalResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForGlobalResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/global/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForGlobalResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForGlobalResourceInput(v *ListTagsForGlobalResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPurchaseOffering struct {
}

func (*awsRestjson1_serializeOpPurchaseOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPurchaseOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings/{OfferingArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPurchaseOfferingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(v *PurchaseOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingArn == nil || len(*v.OfferingArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingArn must not be empty")}
	}
	if v.OfferingArn != nil {
		if err := encoder.SetURI("OfferingArn").String(*v.OfferingArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPurchaseOfferingInput(v *PurchaseOfferingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReservationName != nil {
		ok := object.Key("reservationName")
		ok.String(*v.ReservationName)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.String(*v.Start)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveBridgeOutput struct {
}

func (*awsRestjson1_serializeOpRemoveBridgeOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveBridgeOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveBridgeOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs/{OutputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveBridgeOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveBridgeOutputInput(v *RemoveBridgeOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.OutputName == nil || len(*v.OutputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputName must not be empty")}
	}
	if v.OutputName != nil {
		if err := encoder.SetURI("OutputName").String(*v.OutputName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveBridgeSource struct {
}

func (*awsRestjson1_serializeOpRemoveBridgeSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveBridgeSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveBridgeSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources/{SourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveBridgeSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveBridgeSourceInput(v *RemoveBridgeSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.SourceName == nil || len(*v.SourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceName must not be empty")}
	}
	if v.SourceName != nil {
		if err := encoder.SetURI("SourceName").String(*v.SourceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowMediaStream struct {
}

func (*awsRestjson1_serializeOpRemoveFlowMediaStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowMediaStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowMediaStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowMediaStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowMediaStreamInput(v *RemoveFlowMediaStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.MediaStreamName == nil || len(*v.MediaStreamName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MediaStreamName must not be empty")}
	}
	if v.MediaStreamName != nil {
		if err := encoder.SetURI("MediaStreamName").String(*v.MediaStreamName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowOutput struct {
}

func (*awsRestjson1_serializeOpRemoveFlowOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs/{OutputArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowOutputInput(v *RemoveFlowOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.OutputArn == nil || len(*v.OutputArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputArn must not be empty")}
	}
	if v.OutputArn != nil {
		if err := encoder.SetURI("OutputArn").String(*v.OutputArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowSource struct {
}

func (*awsRestjson1_serializeOpRemoveFlowSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source/{SourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowSourceInput(v *RemoveFlowSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.SourceArn == nil || len(*v.SourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceArn must not be empty")}
	}
	if v.SourceArn != nil {
		if err := encoder.SetURI("SourceArn").String(*v.SourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowVpcInterface struct {
}

func (*awsRestjson1_serializeOpRemoveFlowVpcInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowVpcInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowVpcInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/vpcInterfaces/{VpcInterfaceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowVpcInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowVpcInterfaceInput(v *RemoveFlowVpcInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.VpcInterfaceName == nil || len(*v.VpcInterfaceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VpcInterfaceName must not be empty")}
	}
	if v.VpcInterfaceName != nil {
		if err := encoder.SetURI("VpcInterfaceName").String(*v.VpcInterfaceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRestartRouterInput struct {
}

func (*awsRestjson1_serializeOpRestartRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRestartRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestartRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/restart/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRestartRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRestartRouterInputInput(v *RestartRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRestartRouterOutput struct {
}

func (*awsRestjson1_serializeOpRestartRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRestartRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestartRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/restart/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRestartRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRestartRouterOutputInput(v *RestartRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRevokeFlowEntitlement struct {
}

func (*awsRestjson1_serializeOpRevokeFlowEntitlement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRevokeFlowEntitlement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeFlowEntitlementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements/{EntitlementArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRevokeFlowEntitlementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRevokeFlowEntitlementInput(v *RevokeFlowEntitlementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntitlementArn == nil || len(*v.EntitlementArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EntitlementArn must not be empty")}
	}
	if v.EntitlementArn != nil {
		if err := encoder.SetURI("EntitlementArn").String(*v.EntitlementArn); err != nil {
			return err
		}
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartFlow struct {
}

func (*awsRestjson1_serializeOpStartFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/start/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartFlowInput(v *StartFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartRouterInput struct {
}

func (*awsRestjson1_serializeOpStartRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/start/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartRouterInputInput(v *StartRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartRouterOutput struct {
}

func (*awsRestjson1_serializeOpStartRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/start/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartRouterOutputInput(v *StartRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopFlow struct {
}

func (*awsRestjson1_serializeOpStopFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/stop/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopFlowInput(v *StopFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopRouterInput struct {
}

func (*awsRestjson1_serializeOpStopRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/stop/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopRouterInputInput(v *StopRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopRouterOutput struct {
}

func (*awsRestjson1_serializeOpStopRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/stop/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopRouterOutputInput(v *StopRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagGlobalResource struct {
}

func (*awsRestjson1_serializeOpTagGlobalResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagGlobalResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagGlobalResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/global/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagGlobalResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagGlobalResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagGlobalResourceInput(v *TagGlobalResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagGlobalResourceInput(v *TagGlobalResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTakeRouterInput struct {
}

func (*awsRestjson1_serializeOpTakeRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTakeRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TakeRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/takeRouterInput/{RouterOutputArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTakeRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTakeRouterInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTakeRouterInputInput(v *TakeRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RouterOutputArn == nil || len(*v.RouterOutputArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouterOutputArn must not be empty")}
	}
	if v.RouterOutputArn != nil {
		if err := encoder.SetURI("RouterOutputArn").String(*v.RouterOutputArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTakeRouterInputInput(v *TakeRouterInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RouterInputArn != nil {
		ok := object.Key("routerInputArn")
		ok.String(*v.RouterInputArn)
	}

	return nil
}

type awsRestjson1_serializeOpUntagGlobalResource struct {
}

func (*awsRestjson1_serializeOpUntagGlobalResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagGlobalResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagGlobalResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/global/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagGlobalResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagGlobalResourceInput(v *UntagGlobalResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridge struct {
}

func (*awsRestjson1_serializeOpUpdateBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeInput(v *UpdateBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeInput(v *UpdateBridgeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressGatewayBridge != nil {
		ok := object.Key("egressGatewayBridge")
		if err := awsRestjson1_serializeDocumentUpdateEgressGatewayBridgeRequest(v.EgressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.IngressGatewayBridge != nil {
		ok := object.Key("ingressGatewayBridge")
		if err := awsRestjson1_serializeDocumentUpdateIngressGatewayBridgeRequest(v.IngressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentUpdateFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeOutput struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs/{OutputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeOutputInput(v *UpdateBridgeOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.OutputName == nil || len(*v.OutputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputName must not be empty")}
	}
	if v.OutputName != nil {
		if err := encoder.SetURI("OutputName").String(*v.OutputName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeOutputInput(v *UpdateBridgeOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkOutput != nil {
		ok := object.Key("networkOutput")
		if err := awsRestjson1_serializeDocumentUpdateBridgeNetworkOutputRequest(v.NetworkOutput, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeSource struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources/{SourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeSourceInput(v *UpdateBridgeSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.SourceName == nil || len(*v.SourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceName must not be empty")}
	}
	if v.SourceName != nil {
		if err := encoder.SetURI("SourceName").String(*v.SourceName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeSourceInput(v *UpdateBridgeSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowSource != nil {
		ok := object.Key("flowSource")
		if err := awsRestjson1_serializeDocumentUpdateBridgeFlowSourceRequest(v.FlowSource, ok); err != nil {
			return err
		}
	}

	if v.NetworkSource != nil {
		ok := object.Key("networkSource")
		if err := awsRestjson1_serializeDocumentUpdateBridgeNetworkSourceRequest(v.NetworkSource, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeState struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeState) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/state")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeStateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeStateInput(v *UpdateBridgeStateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeStateInput(v *UpdateBridgeStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DesiredState) > 0 {
		ok := object.Key("desiredState")
		ok.String(string(v.DesiredState))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlow struct {
}

func (*awsRestjson1_serializeOpUpdateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowInput(v *UpdateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowInput(v *UpdateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FlowSize) > 0 {
		ok := object.Key("flowSize")
		ok.String(string(v.FlowSize))
	}

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentUpdateMaintenance(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.NdiConfig != nil {
		ok := object.Key("ndiConfig")
		if err := awsRestjson1_serializeDocumentNdiConfig(v.NdiConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentUpdateFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceMonitoringConfig != nil {
		ok := object.Key("sourceMonitoringConfig")
		if err := awsRestjson1_serializeDocumentMonitoringConfig(v.SourceMonitoringConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowEntitlement struct {
}

func (*awsRestjson1_serializeOpUpdateFlowEntitlement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowEntitlement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowEntitlementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements/{EntitlementArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowEntitlementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowEntitlementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowEntitlementInput(v *UpdateFlowEntitlementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntitlementArn == nil || len(*v.EntitlementArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EntitlementArn must not be empty")}
	}
	if v.EntitlementArn != nil {
		if err := encoder.SetURI("EntitlementArn").String(*v.EntitlementArn); err != nil {
			return err
		}
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowEntitlementInput(v *UpdateFlowEntitlementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.EntitlementStatus) > 0 {
		ok := object.Key("entitlementStatus")
		ok.String(string(v.EntitlementStatus))
	}

	if v.Subscribers != nil {
		ok := object.Key("subscribers")
		if err := awsRestjson1_serializeDocument__listOfString(v.Subscribers, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowMediaStream struct {
}

func (*awsRestjson1_serializeOpUpdateFlowMediaStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowMediaStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowMediaStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowMediaStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowMediaStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowMediaStreamInput(v *UpdateFlowMediaStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.MediaStreamName == nil || len(*v.MediaStreamName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MediaStreamName must not be empty")}
	}
	if v.MediaStreamName != nil {
		if err := encoder.SetURI("MediaStreamName").String(*v.MediaStreamName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowMediaStreamInput(v *UpdateFlowMediaStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClockRate != nil {
		ok := object.Key("clockRate")
		ok.Integer(*v.ClockRate)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if len(v.MediaStreamType) > 0 {
		ok := object.Key("mediaStreamType")
		ok.String(string(v.MediaStreamType))
	}

	if v.VideoFormat != nil {
		ok := object.Key("videoFormat")
		ok.String(*v.VideoFormat)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowOutput struct {
}

func (*awsRestjson1_serializeOpUpdateFlowOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs/{OutputArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowOutputInput(v *UpdateFlowOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.OutputArn == nil || len(*v.OutputArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputArn must not be empty")}
	}
	if v.OutputArn != nil {
		if err := encoder.SetURI("OutputArn").String(*v.OutputArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowOutputInput(v *UpdateFlowOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrAllowList != nil {
		ok := object.Key("cidrAllowList")
		if err := awsRestjson1_serializeDocument__listOfString(v.CidrAllowList, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MediaStreamOutputConfigurations != nil {
		ok := object.Key("mediaStreamOutputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v.MediaStreamOutputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if v.NdiProgramName != nil {
		ok := object.Key("ndiProgramName")
		ok.String(*v.NdiProgramName)
	}

	if v.NdiSpeedHqQuality != nil {
		ok := object.Key("ndiSpeedHqQuality")
		ok.Integer(*v.NdiSpeedHqQuality)
	}

	if len(v.OutputStatus) > 0 {
		ok := object.Key("outputStatus")
		ok.String(string(v.OutputStatus))
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.RemoteId != nil {
		ok := object.Key("remoteId")
		ok.String(*v.RemoteId)
	}

	if len(v.RouterIntegrationState) > 0 {
		ok := object.Key("routerIntegrationState")
		ok.String(string(v.RouterIntegrationState))
	}

	if v.RouterIntegrationTransitEncryption != nil {
		ok := object.Key("routerIntegrationTransitEncryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.RouterIntegrationTransitEncryption, ok); err != nil {
			return err
		}
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SmoothingLatency != nil {
		ok := object.Key("smoothingLatency")
		ok.Integer(*v.SmoothingLatency)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowSource struct {
}

func (*awsRestjson1_serializeOpUpdateFlowSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source/{SourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowSourceInput(v *UpdateFlowSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.SourceArn == nil || len(*v.SourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceArn must not be empty")}
	}
	if v.SourceArn != nil {
		if err := encoder.SetURI("SourceArn").String(*v.SourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowSourceInput(v *UpdateFlowSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decryption != nil {
		ok := object.Key("decryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Decryption, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntitlementArn != nil {
		ok := object.Key("entitlementArn")
		ok.String(*v.EntitlementArn)
	}

	if v.GatewayBridgeSource != nil {
		ok := object.Key("gatewayBridgeSource")
		if err := awsRestjson1_serializeDocumentUpdateGatewayBridgeSourceRequest(v.GatewayBridgeSource, ok); err != nil {
			return err
		}
	}

	if v.IngestPort != nil {
		ok := object.Key("ingestPort")
		ok.Integer(*v.IngestPort)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MaxSyncBuffer != nil {
		ok := object.Key("maxSyncBuffer")
		ok.Integer(*v.MaxSyncBuffer)
	}

	if v.MediaStreamSourceConfigurations != nil {
		ok := object.Key("mediaStreamSourceConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v.MediaStreamSourceConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if len(v.RouterIntegrationState) > 0 {
		ok := object.Key("routerIntegrationState")
		ok.String(string(v.RouterIntegrationState))
	}

	if v.RouterIntegrationTransitDecryption != nil {
		ok := object.Key("routerIntegrationTransitDecryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.RouterIntegrationTransitDecryption, ok); err != nil {
			return err
		}
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SourceListenerAddress != nil {
		ok := object.Key("sourceListenerAddress")
		ok.String(*v.SourceListenerAddress)
	}

	if v.SourceListenerPort != nil {
		ok := object.Key("sourceListenerPort")
		ok.Integer(*v.SourceListenerPort)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	if v.WhitelistCidr != nil {
		ok := object.Key("whitelistCidr")
		ok.String(*v.WhitelistCidr)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGatewayInstance struct {
}

func (*awsRestjson1_serializeOpUpdateGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGatewayInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGatewayInstanceInput(v *UpdateGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGatewayInstanceInput(v *UpdateGatewayInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BridgePlacement) > 0 {
		ok := object.Key("bridgePlacement")
		ok.String(string(v.BridgePlacement))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRouterInput struct {
}

func (*awsRestjson1_serializeOpUpdateRouterInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRouterInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouterInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerInput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouterInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouterInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouterInputInput(v *UpdateRouterInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouterInputInput(v *UpdateRouterInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterInputConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.MaintenanceConfiguration != nil {
		ok := object.Key("maintenanceConfiguration")
		if err := awsRestjson1_serializeDocumentMaintenanceConfiguration(v.MaintenanceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaximumBitrate != nil {
		ok := object.Key("maximumBitrate")
		ok.Long(*v.MaximumBitrate)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.RoutingScope) > 0 {
		ok := object.Key("routingScope")
		ok.String(string(v.RoutingScope))
	}

	if len(v.Tier) > 0 {
		ok := object.Key("tier")
		ok.String(string(v.Tier))
	}

	if v.TransitEncryption != nil {
		ok := object.Key("transitEncryption")
		if err := awsRestjson1_serializeDocumentRouterInputTransitEncryption(v.TransitEncryption, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRouterNetworkInterface struct {
}

func (*awsRestjson1_serializeOpUpdateRouterNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRouterNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouterNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerNetworkInterface/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouterNetworkInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouterNetworkInterfaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouterNetworkInterfaceInput(v *UpdateRouterNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouterNetworkInterfaceInput(v *UpdateRouterNetworkInterfaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRouterOutput struct {
}

func (*awsRestjson1_serializeOpUpdateRouterOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRouterOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouterOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/routerOutput/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouterOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouterOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouterOutputInput(v *UpdateRouterOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouterOutputInput(v *UpdateRouterOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRouterOutputConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.MaintenanceConfiguration != nil {
		ok := object.Key("maintenanceConfiguration")
		if err := awsRestjson1_serializeDocumentMaintenanceConfiguration(v.MaintenanceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaximumBitrate != nil {
		ok := object.Key("maximumBitrate")
		ok.Long(*v.MaximumBitrate)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.RoutingScope) > 0 {
		ok := object.Key("routingScope")
		ok.String(string(v.RoutingScope))
	}

	if len(v.Tier) > 0 {
		ok := object.Key("tier")
		ok.String(string(v.Tier))
	}

	return nil
}

func awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v []types.AddBridgeOutputRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddBridgeOutputRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v []types.AddBridgeSourceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddBridgeSourceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v []types.AddMediaStreamRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddMediaStreamRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddOutputRequest(v []types.AddOutputRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddOutputRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioMonitoringSetting(v []types.AudioMonitoringSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioMonitoringSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfDestinationConfigurationRequest(v []types.DestinationConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDestinationConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfGatewayNetwork(v []types.GatewayNetwork, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGatewayNetwork(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v []types.GrantEntitlementRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGrantEntitlementRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputConfigurationRequest(v []types.InputConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v []types.MediaStreamOutputConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaStreamOutputConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v []types.MediaStreamSourceConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaStreamSourceConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfNdiDiscoveryServerConfig(v []types.NdiDiscoveryServerConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNdiDiscoveryServerConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfSetSourceRequest(v []types.SetSourceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSetSourceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfString(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVideoMonitoringSetting(v []types.VideoMonitoringSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVideoMonitoringSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v []types.VpcInterfaceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVpcInterfaceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOfString(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAddBridgeFlowSourceRequest(v *types.AddBridgeFlowSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowVpcInterfaceAttachment != nil {
		ok := object.Key("flowVpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.FlowVpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeNetworkOutputRequest(v *types.AddBridgeNetworkOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpAddress != nil {
		ok := object.Key("ipAddress")
		ok.String(*v.IpAddress)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.Ttl != nil {
		ok := object.Key("ttl")
		ok.Integer(*v.Ttl)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeNetworkSourceRequest(v *types.AddBridgeNetworkSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MulticastIp != nil {
		ok := object.Key("multicastIp")
		ok.String(*v.MulticastIp)
	}

	if v.MulticastSourceSettings != nil {
		ok := object.Key("multicastSourceSettings")
		if err := awsRestjson1_serializeDocumentMulticastSourceSettings(v.MulticastSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeOutputRequest(v *types.AddBridgeOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkOutput != nil {
		ok := object.Key("networkOutput")
		if err := awsRestjson1_serializeDocumentAddBridgeNetworkOutputRequest(v.NetworkOutput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeSourceRequest(v *types.AddBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowSource != nil {
		ok := object.Key("flowSource")
		if err := awsRestjson1_serializeDocumentAddBridgeFlowSourceRequest(v.FlowSource, ok); err != nil {
			return err
		}
	}

	if v.NetworkSource != nil {
		ok := object.Key("networkSource")
		if err := awsRestjson1_serializeDocumentAddBridgeNetworkSourceRequest(v.NetworkSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddEgressGatewayBridgeRequest(v *types.AddEgressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddIngressGatewayBridgeRequest(v *types.AddIngressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxOutputs != nil {
		ok := object.Key("maxOutputs")
		ok.Integer(*v.MaxOutputs)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddMaintenance(v *types.AddMaintenance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceStartHour != nil {
		ok := object.Key("maintenanceStartHour")
		ok.String(*v.MaintenanceStartHour)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddMediaStreamRequest(v *types.AddMediaStreamRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClockRate != nil {
		ok := object.Key("clockRate")
		ok.Integer(*v.ClockRate)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MediaStreamId != nil {
		ok := object.Key("mediaStreamId")
		ok.Integer(*v.MediaStreamId)
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	if v.MediaStreamTags != nil {
		ok := object.Key("mediaStreamTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.MediaStreamTags, ok); err != nil {
			return err
		}
	}

	if len(v.MediaStreamType) > 0 {
		ok := object.Key("mediaStreamType")
		ok.String(string(v.MediaStreamType))
	}

	if v.VideoFormat != nil {
		ok := object.Key("videoFormat")
		ok.String(*v.VideoFormat)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddOutputRequest(v *types.AddOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrAllowList != nil {
		ok := object.Key("cidrAllowList")
		if err := awsRestjson1_serializeDocument__listOfString(v.CidrAllowList, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MediaStreamOutputConfigurations != nil {
		ok := object.Key("mediaStreamOutputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v.MediaStreamOutputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NdiProgramName != nil {
		ok := object.Key("ndiProgramName")
		ok.String(*v.NdiProgramName)
	}

	if v.NdiSpeedHqQuality != nil {
		ok := object.Key("ndiSpeedHqQuality")
		ok.Integer(*v.NdiSpeedHqQuality)
	}

	if len(v.OutputStatus) > 0 {
		ok := object.Key("outputStatus")
		ok.String(string(v.OutputStatus))
	}

	if v.OutputTags != nil {
		ok := object.Key("outputTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.OutputTags, ok); err != nil {
			return err
		}
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.RemoteId != nil {
		ok := object.Key("remoteId")
		ok.String(*v.RemoteId)
	}

	if len(v.RouterIntegrationState) > 0 {
		ok := object.Key("routerIntegrationState")
		ok.String(string(v.RouterIntegrationState))
	}

	if v.RouterIntegrationTransitEncryption != nil {
		ok := object.Key("routerIntegrationTransitEncryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.RouterIntegrationTransitEncryption, ok); err != nil {
			return err
		}
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SmoothingLatency != nil {
		ok := object.Key("smoothingLatency")
		ok.Integer(*v.SmoothingLatency)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioMonitoringSetting(v *types.AudioMonitoringSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SilentAudio != nil {
		ok := object.Key("silentAudio")
		if err := awsRestjson1_serializeDocumentSilentAudio(v.SilentAudio, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomaticEncryptionKeyConfiguration(v *types.AutomaticEncryptionKeyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentBlackFrames(v *types.BlackFrames, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.ThresholdSeconds != nil {
		ok := object.Key("thresholdSeconds")
		ok.Integer(*v.ThresholdSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultMaintenanceConfiguration(v *types.DefaultMaintenanceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentDestinationConfigurationRequest(v *types.DestinationConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationIp != nil {
		ok := object.Key("destinationIp")
		ok.String(*v.DestinationIp)
	}

	if v.DestinationPort != nil {
		ok := object.Key("destinationPort")
		ok.Integer(*v.DestinationPort)
	}

	if v.Interface != nil {
		ok := object.Key("interface")
		if err := awsRestjson1_serializeDocumentInterfaceRequest(v.Interface, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEncodingParametersRequest(v *types.EncodingParametersRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompressionFactor != nil {
		ok := object.Key("compressionFactor")
		switch {
		case math.IsNaN(*v.CompressionFactor):
			ok.String("NaN")

		case math.IsInf(*v.CompressionFactor, 1):
			ok.String("Infinity")

		case math.IsInf(*v.CompressionFactor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.CompressionFactor)

		}
	}

	if len(v.EncoderProfile) > 0 {
		ok := object.Key("encoderProfile")
		ok.String(string(v.EncoderProfile))
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryption(v *types.Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.DeviceId != nil {
		ok := object.Key("deviceId")
		ok.String(*v.DeviceId)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("keyType")
		ok.String(string(v.KeyType))
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverConfig(v *types.FailoverConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.RecoveryWindow != nil {
		ok := object.Key("recoveryWindow")
		ok.Integer(*v.RecoveryWindow)
	}

	if v.SourcePriority != nil {
		ok := object.Key("sourcePriority")
		if err := awsRestjson1_serializeDocumentSourcePriority(v.SourcePriority, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverRouterInputConfiguration(v *types.FailoverRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkInterfaceArn != nil {
		ok := object.Key("networkInterfaceArn")
		ok.String(*v.NetworkInterfaceArn)
	}

	if v.PrimarySourceIndex != nil {
		ok := object.Key("primarySourceIndex")
		ok.Integer(*v.PrimarySourceIndex)
	}

	if v.ProtocolConfigurations != nil {
		ok := object.Key("protocolConfigurations")
		if err := awsRestjson1_serializeDocumentFailoverRouterInputProtocolConfigurationList(v.ProtocolConfigurations, ok); err != nil {
			return err
		}
	}

	if len(v.SourcePriorityMode) > 0 {
		ok := object.Key("sourcePriorityMode")
		ok.String(string(v.SourcePriorityMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverRouterInputProtocolConfiguration(v types.FailoverRouterInputProtocolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FailoverRouterInputProtocolConfigurationMemberRist:
		av := object.Key("rist")
		if err := awsRestjson1_serializeDocumentRistRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.FailoverRouterInputProtocolConfigurationMemberRtp:
		av := object.Key("rtp")
		if err := awsRestjson1_serializeDocumentRtpRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.FailoverRouterInputProtocolConfigurationMemberSrtCaller:
		av := object.Key("srtCaller")
		if err := awsRestjson1_serializeDocumentSrtCallerRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.FailoverRouterInputProtocolConfigurationMemberSrtListener:
		av := object.Key("srtListener")
		if err := awsRestjson1_serializeDocumentSrtListenerRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentFailoverRouterInputProtocolConfigurationList(v []types.FailoverRouterInputProtocolConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentFailoverRouterInputProtocolConfiguration(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFlowTransitEncryption(v *types.FlowTransitEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKeyConfiguration != nil {
		ok := object.Key("encryptionKeyConfiguration")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryptionKeyConfiguration(v.EncryptionKeyConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.EncryptionKeyType) > 0 {
		ok := object.Key("encryptionKeyType")
		ok.String(string(v.EncryptionKeyType))
	}

	return nil
}

func awsRestjson1_serializeDocumentFlowTransitEncryptionKeyConfiguration(v types.FlowTransitEncryptionKeyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FlowTransitEncryptionKeyConfigurationMemberAutomatic:
		av := object.Key("automatic")
		if err := awsRestjson1_serializeDocumentAutomaticEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.FlowTransitEncryptionKeyConfigurationMemberSecretsManager:
		av := object.Key("secretsManager")
		if err := awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentFmtpRequest(v *types.FmtpRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelOrder != nil {
		ok := object.Key("channelOrder")
		ok.String(*v.ChannelOrder)
	}

	if len(v.Colorimetry) > 0 {
		ok := object.Key("colorimetry")
		ok.String(string(v.Colorimetry))
	}

	if v.ExactFramerate != nil {
		ok := object.Key("exactFramerate")
		ok.String(*v.ExactFramerate)
	}

	if v.Par != nil {
		ok := object.Key("par")
		ok.String(*v.Par)
	}

	if len(v.Range) > 0 {
		ok := object.Key("range")
		ok.String(string(v.Range))
	}

	if len(v.ScanMode) > 0 {
		ok := object.Key("scanMode")
		ok.String(string(v.ScanMode))
	}

	if len(v.Tcs) > 0 {
		ok := object.Key("tcs")
		ok.String(string(v.Tcs))
	}

	return nil
}

func awsRestjson1_serializeDocumentFrozenFrames(v *types.FrozenFrames, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.ThresholdSeconds != nil {
		ok := object.Key("thresholdSeconds")
		ok.Integer(*v.ThresholdSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayNetwork(v *types.GatewayNetwork, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrBlock != nil {
		ok := object.Key("cidrBlock")
		ok.String(*v.CidrBlock)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrantEntitlementRequest(v *types.GrantEntitlementRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataTransferSubscriberFeePercent != nil {
		ok := object.Key("dataTransferSubscriberFeePercent")
		ok.Integer(*v.DataTransferSubscriberFeePercent)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.EntitlementStatus) > 0 {
		ok := object.Key("entitlementStatus")
		ok.String(string(v.EntitlementStatus))
	}

	if v.EntitlementTags != nil {
		ok := object.Key("entitlementTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.EntitlementTags, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Subscribers != nil {
		ok := object.Key("subscribers")
		if err := awsRestjson1_serializeDocument__listOfString(v.Subscribers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputConfigurationRequest(v *types.InputConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputPort != nil {
		ok := object.Key("inputPort")
		ok.Integer(*v.InputPort)
	}

	if v.Interface != nil {
		ok := object.Key("interface")
		if err := awsRestjson1_serializeDocumentInterfaceRequest(v.Interface, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInterfaceRequest(v *types.InterfaceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentMaintenanceConfiguration(v types.MaintenanceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MaintenanceConfigurationMemberDefault:
		av := object.Key("default")
		if err := awsRestjson1_serializeDocumentDefaultMaintenanceConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.MaintenanceConfigurationMemberPreferredDayTime:
		av := object.Key("preferredDayTime")
		if err := awsRestjson1_serializeDocumentPreferredDayTimeMaintenanceConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentMediaConnectFlowRouterInputConfiguration(v *types.MediaConnectFlowRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowOutputArn != nil {
		ok := object.Key("flowOutputArn")
		ok.String(*v.FlowOutputArn)
	}

	if v.SourceTransitDecryption != nil {
		ok := object.Key("sourceTransitDecryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.SourceTransitDecryption, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaConnectFlowRouterOutputConfiguration(v *types.MediaConnectFlowRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationTransitEncryption != nil {
		ok := object.Key("destinationTransitEncryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.DestinationTransitEncryption, ok); err != nil {
			return err
		}
	}

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowSourceArn != nil {
		ok := object.Key("flowSourceArn")
		ok.String(*v.FlowSourceArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaLiveInputRouterOutputConfiguration(v *types.MediaLiveInputRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationTransitEncryption != nil {
		ok := object.Key("destinationTransitEncryption")
		if err := awsRestjson1_serializeDocumentMediaLiveTransitEncryption(v.DestinationTransitEncryption, ok); err != nil {
			return err
		}
	}

	if v.MediaLiveInputArn != nil {
		ok := object.Key("mediaLiveInputArn")
		ok.String(*v.MediaLiveInputArn)
	}

	if len(v.MediaLivePipelineId) > 0 {
		ok := object.Key("mediaLivePipelineId")
		ok.String(string(v.MediaLivePipelineId))
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaLiveTransitEncryption(v *types.MediaLiveTransitEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKeyConfiguration != nil {
		ok := object.Key("encryptionKeyConfiguration")
		if err := awsRestjson1_serializeDocumentMediaLiveTransitEncryptionKeyConfiguration(v.EncryptionKeyConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.EncryptionKeyType) > 0 {
		ok := object.Key("encryptionKeyType")
		ok.String(string(v.EncryptionKeyType))
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaLiveTransitEncryptionKeyConfiguration(v types.MediaLiveTransitEncryptionKeyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MediaLiveTransitEncryptionKeyConfigurationMemberAutomatic:
		av := object.Key("automatic")
		if err := awsRestjson1_serializeDocumentAutomaticEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.MediaLiveTransitEncryptionKeyConfigurationMemberSecretsManager:
		av := object.Key("secretsManager")
		if err := awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v *types.MediaStreamAttributesRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Fmtp != nil {
		ok := object.Key("fmtp")
		if err := awsRestjson1_serializeDocumentFmtpRequest(v.Fmtp, ok); err != nil {
			return err
		}
	}

	if v.Lang != nil {
		ok := object.Key("lang")
		ok.String(*v.Lang)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaStreamOutputConfigurationRequest(v *types.MediaStreamOutputConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationConfigurations != nil {
		ok := object.Key("destinationConfigurations")
		if err := awsRestjson1_serializeDocument__listOfDestinationConfigurationRequest(v.DestinationConfigurations, ok); err != nil {
			return err
		}
	}

	if len(v.EncodingName) > 0 {
		ok := object.Key("encodingName")
		ok.String(string(v.EncodingName))
	}

	if v.EncodingParameters != nil {
		ok := object.Key("encodingParameters")
		if err := awsRestjson1_serializeDocumentEncodingParametersRequest(v.EncodingParameters, ok); err != nil {
			return err
		}
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaStreamSourceConfigurationRequest(v *types.MediaStreamSourceConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncodingName) > 0 {
		ok := object.Key("encodingName")
		ok.String(string(v.EncodingName))
	}

	if v.InputConfigurations != nil {
		ok := object.Key("inputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfInputConfigurationRequest(v.InputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMergeRouterInputConfiguration(v *types.MergeRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MergeRecoveryWindowMilliseconds != nil {
		ok := object.Key("mergeRecoveryWindowMilliseconds")
		ok.Long(*v.MergeRecoveryWindowMilliseconds)
	}

	if v.NetworkInterfaceArn != nil {
		ok := object.Key("networkInterfaceArn")
		ok.String(*v.NetworkInterfaceArn)
	}

	if v.ProtocolConfigurations != nil {
		ok := object.Key("protocolConfigurations")
		if err := awsRestjson1_serializeDocumentMergeRouterInputProtocolConfigurationList(v.ProtocolConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMergeRouterInputProtocolConfiguration(v types.MergeRouterInputProtocolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MergeRouterInputProtocolConfigurationMemberRist:
		av := object.Key("rist")
		if err := awsRestjson1_serializeDocumentRistRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.MergeRouterInputProtocolConfigurationMemberRtp:
		av := object.Key("rtp")
		if err := awsRestjson1_serializeDocumentRtpRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentMergeRouterInputProtocolConfigurationList(v []types.MergeRouterInputProtocolConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentMergeRouterInputProtocolConfiguration(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMonitoringConfig(v *types.MonitoringConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioMonitoringSettings != nil {
		ok := object.Key("audioMonitoringSettings")
		if err := awsRestjson1_serializeDocument__listOfAudioMonitoringSetting(v.AudioMonitoringSettings, ok); err != nil {
			return err
		}
	}

	if len(v.ContentQualityAnalysisState) > 0 {
		ok := object.Key("contentQualityAnalysisState")
		ok.String(string(v.ContentQualityAnalysisState))
	}

	if len(v.ThumbnailState) > 0 {
		ok := object.Key("thumbnailState")
		ok.String(string(v.ThumbnailState))
	}

	if v.VideoMonitoringSettings != nil {
		ok := object.Key("videoMonitoringSettings")
		if err := awsRestjson1_serializeDocument__listOfVideoMonitoringSetting(v.VideoMonitoringSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMulticastSourceSettings(v *types.MulticastSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MulticastSourceIp != nil {
		ok := object.Key("multicastSourceIp")
		ok.String(*v.MulticastSourceIp)
	}

	return nil
}

func awsRestjson1_serializeDocumentNdiConfig(v *types.NdiConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MachineName != nil {
		ok := object.Key("machineName")
		ok.String(*v.MachineName)
	}

	if v.NdiDiscoveryServers != nil {
		ok := object.Key("ndiDiscoveryServers")
		if err := awsRestjson1_serializeDocument__listOfNdiDiscoveryServerConfig(v.NdiDiscoveryServers, ok); err != nil {
			return err
		}
	}

	if len(v.NdiState) > 0 {
		ok := object.Key("ndiState")
		ok.String(string(v.NdiState))
	}

	return nil
}

func awsRestjson1_serializeDocumentNdiDiscoveryServerConfig(v *types.NdiDiscoveryServerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DiscoveryServerAddress != nil {
		ok := object.Key("discoveryServerAddress")
		ok.String(*v.DiscoveryServerAddress)
	}

	if v.DiscoveryServerPort != nil {
		ok := object.Key("discoveryServerPort")
		ok.Integer(*v.DiscoveryServerPort)
	}

	if v.VpcInterfaceAdapter != nil {
		ok := object.Key("vpcInterfaceAdapter")
		ok.String(*v.VpcInterfaceAdapter)
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkInterfaceRuleList(v []types.PublicRouterNetworkInterfaceRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPublicRouterNetworkInterfaceRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPreferredDayTimeMaintenanceConfiguration(v *types.PreferredDayTimeMaintenanceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Day) > 0 {
		ok := object.Key("day")
		ok.String(string(v.Day))
	}

	if v.Time != nil {
		ok := object.Key("time")
		ok.String(*v.Time)
	}

	return nil
}

func awsRestjson1_serializeDocumentPublicRouterNetworkInterfaceConfiguration(v *types.PublicRouterNetworkInterfaceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowRules != nil {
		ok := object.Key("allowRules")
		if err := awsRestjson1_serializeDocumentNetworkInterfaceRuleList(v.AllowRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPublicRouterNetworkInterfaceRule(v *types.PublicRouterNetworkInterfaceRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cidr != nil {
		ok := object.Key("cidr")
		ok.String(*v.Cidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentRistRouterInputConfiguration(v *types.RistRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if v.RecoveryLatencyMilliseconds != nil {
		ok := object.Key("recoveryLatencyMilliseconds")
		ok.Long(*v.RecoveryLatencyMilliseconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentRistRouterOutputConfiguration(v *types.RistRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationAddress != nil {
		ok := object.Key("destinationAddress")
		ok.String(*v.DestinationAddress)
	}

	if v.DestinationPort != nil {
		ok := object.Key("destinationPort")
		ok.Integer(*v.DestinationPort)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouterInputArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputConfiguration(v types.RouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterInputConfigurationMemberFailover:
		av := object.Key("failover")
		if err := awsRestjson1_serializeDocumentFailoverRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputConfigurationMemberMediaConnectFlow:
		av := object.Key("mediaConnectFlow")
		if err := awsRestjson1_serializeDocumentMediaConnectFlowRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputConfigurationMemberMerge:
		av := object.Key("merge")
		if err := awsRestjson1_serializeDocumentMergeRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputConfigurationMemberStandard:
		av := object.Key("standard")
		if err := awsRestjson1_serializeDocumentStandardRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputFilter(v types.RouterInputFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterInputFilterMemberInputTypes:
		av := object.Key("inputTypes")
		if err := awsRestjson1_serializeDocumentRouterInputTypeList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputFilterMemberNameContains:
		av := object.Key("nameContains")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputFilterMemberNetworkInterfaceArns:
		av := object.Key("networkInterfaceArns")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceArnList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputFilterMemberRegionNames:
		av := object.Key("regionNames")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputFilterMemberRoutingScopes:
		av := object.Key("routingScopes")
		if err := awsRestjson1_serializeDocumentRoutingScopeList(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputFilterList(v []types.RouterInputFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRouterInputFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputProtocolConfiguration(v types.RouterInputProtocolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterInputProtocolConfigurationMemberRist:
		av := object.Key("rist")
		if err := awsRestjson1_serializeDocumentRistRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputProtocolConfigurationMemberRtp:
		av := object.Key("rtp")
		if err := awsRestjson1_serializeDocumentRtpRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputProtocolConfigurationMemberSrtCaller:
		av := object.Key("srtCaller")
		if err := awsRestjson1_serializeDocumentSrtCallerRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputProtocolConfigurationMemberSrtListener:
		av := object.Key("srtListener")
		if err := awsRestjson1_serializeDocumentSrtListenerRouterInputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputTransitEncryption(v *types.RouterInputTransitEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKeyConfiguration != nil {
		ok := object.Key("encryptionKeyConfiguration")
		if err := awsRestjson1_serializeDocumentRouterInputTransitEncryptionKeyConfiguration(v.EncryptionKeyConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.EncryptionKeyType) > 0 {
		ok := object.Key("encryptionKeyType")
		ok.String(string(v.EncryptionKeyType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRouterInputTransitEncryptionKeyConfiguration(v types.RouterInputTransitEncryptionKeyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterInputTransitEncryptionKeyConfigurationMemberAutomatic:
		av := object.Key("automatic")
		if err := awsRestjson1_serializeDocumentAutomaticEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterInputTransitEncryptionKeyConfigurationMemberSecretsManager:
		av := object.Key("secretsManager")
		if err := awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterInputTypeList(v []types.RouterInputType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterNetworkInterfaceArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterNetworkInterfaceConfiguration(v types.RouterNetworkInterfaceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterNetworkInterfaceConfigurationMemberPublic:
		av := object.Key("public")
		if err := awsRestjson1_serializeDocumentPublicRouterNetworkInterfaceConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterNetworkInterfaceConfigurationMemberVpc:
		av := object.Key("vpc")
		if err := awsRestjson1_serializeDocumentVpcRouterNetworkInterfaceConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterNetworkInterfaceFilter(v types.RouterNetworkInterfaceFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterNetworkInterfaceFilterMemberNameContains:
		av := object.Key("nameContains")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterNetworkInterfaceFilterMemberNetworkInterfaceTypes:
		av := object.Key("networkInterfaceTypes")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceTypeList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterNetworkInterfaceFilterMemberRegionNames:
		av := object.Key("regionNames")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterNetworkInterfaceFilterList(v []types.RouterNetworkInterfaceFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterNetworkInterfaceTypeList(v []types.RouterNetworkInterfaceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterOutputConfiguration(v types.RouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterOutputConfigurationMemberMediaConnectFlow:
		av := object.Key("mediaConnectFlow")
		if err := awsRestjson1_serializeDocumentMediaConnectFlowRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputConfigurationMemberMediaLiveInput:
		av := object.Key("mediaLiveInput")
		if err := awsRestjson1_serializeDocumentMediaLiveInputRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputConfigurationMemberStandard:
		av := object.Key("standard")
		if err := awsRestjson1_serializeDocumentStandardRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterOutputFilter(v types.RouterOutputFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterOutputFilterMemberNameContains:
		av := object.Key("nameContains")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputFilterMemberNetworkInterfaceArns:
		av := object.Key("networkInterfaceArns")
		if err := awsRestjson1_serializeDocumentRouterNetworkInterfaceArnList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputFilterMemberOutputTypes:
		av := object.Key("outputTypes")
		if err := awsRestjson1_serializeDocumentRouterOutputTypeList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputFilterMemberRegionNames:
		av := object.Key("regionNames")
		if err := awsRestjson1_serializeDocumentStringList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputFilterMemberRoutedInputArns:
		av := object.Key("routedInputArns")
		if err := awsRestjson1_serializeDocumentRouterInputArnList(uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputFilterMemberRoutingScopes:
		av := object.Key("routingScopes")
		if err := awsRestjson1_serializeDocumentRoutingScopeList(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterOutputFilterList(v []types.RouterOutputFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRouterOutputFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouterOutputProtocolConfiguration(v types.RouterOutputProtocolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RouterOutputProtocolConfigurationMemberRist:
		av := object.Key("rist")
		if err := awsRestjson1_serializeDocumentRistRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputProtocolConfigurationMemberRtp:
		av := object.Key("rtp")
		if err := awsRestjson1_serializeDocumentRtpRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputProtocolConfigurationMemberSrtCaller:
		av := object.Key("srtCaller")
		if err := awsRestjson1_serializeDocumentSrtCallerRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RouterOutputProtocolConfigurationMemberSrtListener:
		av := object.Key("srtListener")
		if err := awsRestjson1_serializeDocumentSrtListenerRouterOutputConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRouterOutputTypeList(v []types.RouterOutputType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRoutingScopeList(v []types.RoutingScope, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRtpRouterInputConfiguration(v *types.RtpRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ForwardErrorCorrection) > 0 {
		ok := object.Key("forwardErrorCorrection")
		ok.String(string(v.ForwardErrorCorrection))
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentRtpRouterOutputConfiguration(v *types.RtpRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationAddress != nil {
		ok := object.Key("destinationAddress")
		ok.String(*v.DestinationAddress)
	}

	if v.DestinationPort != nil {
		ok := object.Key("destinationPort")
		ok.Integer(*v.DestinationPort)
	}

	if len(v.ForwardErrorCorrection) > 0 {
		ok := object.Key("forwardErrorCorrection")
		ok.String(string(v.ForwardErrorCorrection))
	}

	return nil
}

func awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(v *types.SecretsManagerEncryptionKeyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSetGatewayBridgeSourceRequest(v *types.SetGatewayBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BridgeArn != nil {
		ok := object.Key("bridgeArn")
		ok.String(*v.BridgeArn)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSetSourceRequest(v *types.SetSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decryption != nil {
		ok := object.Key("decryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Decryption, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntitlementArn != nil {
		ok := object.Key("entitlementArn")
		ok.String(*v.EntitlementArn)
	}

	if v.GatewayBridgeSource != nil {
		ok := object.Key("gatewayBridgeSource")
		if err := awsRestjson1_serializeDocumentSetGatewayBridgeSourceRequest(v.GatewayBridgeSource, ok); err != nil {
			return err
		}
	}

	if v.IngestPort != nil {
		ok := object.Key("ingestPort")
		ok.Integer(*v.IngestPort)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MaxSyncBuffer != nil {
		ok := object.Key("maxSyncBuffer")
		ok.Integer(*v.MaxSyncBuffer)
	}

	if v.MediaStreamSourceConfigurations != nil {
		ok := object.Key("mediaStreamSourceConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v.MediaStreamSourceConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if len(v.RouterIntegrationState) > 0 {
		ok := object.Key("routerIntegrationState")
		ok.String(string(v.RouterIntegrationState))
	}

	if v.RouterIntegrationTransitDecryption != nil {
		ok := object.Key("routerIntegrationTransitDecryption")
		if err := awsRestjson1_serializeDocumentFlowTransitEncryption(v.RouterIntegrationTransitDecryption, ok); err != nil {
			return err
		}
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SourceListenerAddress != nil {
		ok := object.Key("sourceListenerAddress")
		ok.String(*v.SourceListenerAddress)
	}

	if v.SourceListenerPort != nil {
		ok := object.Key("sourceListenerPort")
		ok.Integer(*v.SourceListenerPort)
	}

	if v.SourceTags != nil {
		ok := object.Key("sourceTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.SourceTags, ok); err != nil {
			return err
		}
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	if v.WhitelistCidr != nil {
		ok := object.Key("whitelistCidr")
		ok.String(*v.WhitelistCidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentSilentAudio(v *types.SilentAudio, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.ThresholdSeconds != nil {
		ok := object.Key("thresholdSeconds")
		ok.Integer(*v.ThresholdSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentSourcePriority(v *types.SourcePriority, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrimarySource != nil {
		ok := object.Key("primarySource")
		ok.String(*v.PrimarySource)
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtCallerRouterInputConfiguration(v *types.SrtCallerRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecryptionConfiguration != nil {
		ok := object.Key("decryptionConfiguration")
		if err := awsRestjson1_serializeDocumentSrtDecryptionConfiguration(v.DecryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MinimumLatencyMilliseconds != nil {
		ok := object.Key("minimumLatencyMilliseconds")
		ok.Long(*v.MinimumLatencyMilliseconds)
	}

	if v.SourceAddress != nil {
		ok := object.Key("sourceAddress")
		ok.String(*v.SourceAddress)
	}

	if v.SourcePort != nil {
		ok := object.Key("sourcePort")
		ok.Integer(*v.SourcePort)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtCallerRouterOutputConfiguration(v *types.SrtCallerRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationAddress != nil {
		ok := object.Key("destinationAddress")
		ok.String(*v.DestinationAddress)
	}

	if v.DestinationPort != nil {
		ok := object.Key("destinationPort")
		ok.Integer(*v.DestinationPort)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentSrtEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MinimumLatencyMilliseconds != nil {
		ok := object.Key("minimumLatencyMilliseconds")
		ok.Long(*v.MinimumLatencyMilliseconds)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtDecryptionConfiguration(v *types.SrtDecryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKey != nil {
		ok := object.Key("encryptionKey")
		if err := awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(v.EncryptionKey, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtEncryptionConfiguration(v *types.SrtEncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKey != nil {
		ok := object.Key("encryptionKey")
		if err := awsRestjson1_serializeDocumentSecretsManagerEncryptionKeyConfiguration(v.EncryptionKey, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtListenerRouterInputConfiguration(v *types.SrtListenerRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecryptionConfiguration != nil {
		ok := object.Key("decryptionConfiguration")
		if err := awsRestjson1_serializeDocumentSrtDecryptionConfiguration(v.DecryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MinimumLatencyMilliseconds != nil {
		ok := object.Key("minimumLatencyMilliseconds")
		ok.Long(*v.MinimumLatencyMilliseconds)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtListenerRouterOutputConfiguration(v *types.SrtListenerRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentSrtEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MinimumLatencyMilliseconds != nil {
		ok := object.Key("minimumLatencyMilliseconds")
		ok.Long(*v.MinimumLatencyMilliseconds)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardRouterInputConfiguration(v *types.StandardRouterInputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkInterfaceArn != nil {
		ok := object.Key("networkInterfaceArn")
		ok.String(*v.NetworkInterfaceArn)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.ProtocolConfiguration != nil {
		ok := object.Key("protocolConfiguration")
		if err := awsRestjson1_serializeDocumentRouterInputProtocolConfiguration(v.ProtocolConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardRouterOutputConfiguration(v *types.StandardRouterOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkInterfaceArn != nil {
		ok := object.Key("networkInterfaceArn")
		ok.String(*v.NetworkInterfaceArn)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.ProtocolConfiguration != nil {
		ok := object.Key("protocolConfiguration")
		if err := awsRestjson1_serializeDocumentRouterOutputProtocolConfiguration(v.ProtocolConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeFlowSourceRequest(v *types.UpdateBridgeFlowSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowVpcInterfaceAttachment != nil {
		ok := object.Key("flowVpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.FlowVpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeNetworkOutputRequest(v *types.UpdateBridgeNetworkOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpAddress != nil {
		ok := object.Key("ipAddress")
		ok.String(*v.IpAddress)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.Ttl != nil {
		ok := object.Key("ttl")
		ok.Integer(*v.Ttl)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeNetworkSourceRequest(v *types.UpdateBridgeNetworkSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MulticastIp != nil {
		ok := object.Key("multicastIp")
		ok.String(*v.MulticastIp)
	}

	if v.MulticastSourceSettings != nil {
		ok := object.Key("multicastSourceSettings")
		if err := awsRestjson1_serializeDocumentMulticastSourceSettings(v.MulticastSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateEgressGatewayBridgeRequest(v *types.UpdateEgressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateEncryption(v *types.UpdateEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.DeviceId != nil {
		ok := object.Key("deviceId")
		ok.String(*v.DeviceId)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("keyType")
		ok.String(string(v.KeyType))
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateFailoverConfig(v *types.UpdateFailoverConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.RecoveryWindow != nil {
		ok := object.Key("recoveryWindow")
		ok.Integer(*v.RecoveryWindow)
	}

	if v.SourcePriority != nil {
		ok := object.Key("sourcePriority")
		if err := awsRestjson1_serializeDocumentSourcePriority(v.SourcePriority, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateGatewayBridgeSourceRequest(v *types.UpdateGatewayBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BridgeArn != nil {
		ok := object.Key("bridgeArn")
		ok.String(*v.BridgeArn)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateIngressGatewayBridgeRequest(v *types.UpdateIngressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxOutputs != nil {
		ok := object.Key("maxOutputs")
		ok.Integer(*v.MaxOutputs)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateMaintenance(v *types.UpdateMaintenance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceScheduledDate != nil {
		ok := object.Key("maintenanceScheduledDate")
		ok.String(*v.MaintenanceScheduledDate)
	}

	if v.MaintenanceStartHour != nil {
		ok := object.Key("maintenanceStartHour")
		ok.String(*v.MaintenanceStartHour)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoMonitoringSetting(v *types.VideoMonitoringSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlackFrames != nil {
		ok := object.Key("blackFrames")
		if err := awsRestjson1_serializeDocumentBlackFrames(v.BlackFrames, ok); err != nil {
			return err
		}
	}

	if v.FrozenFrames != nil {
		ok := object.Key("frozenFrames")
		if err := awsRestjson1_serializeDocumentFrozenFrames(v.FrozenFrames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcInterfaceAttachment(v *types.VpcInterfaceAttachment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcInterfaceRequest(v *types.VpcInterfaceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.NetworkInterfaceType) > 0 {
		ok := object.Key("networkInterfaceType")
		ok.String(string(v.NetworkInterfaceType))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocument__listOfString(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("subnetId")
		ok.String(*v.SubnetId)
	}

	if v.VpcInterfaceTags != nil {
		ok := object.Key("vpcInterfaceTags")
		if err := awsRestjson1_serializeDocument__mapOfString(v.VpcInterfaceTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcRouterNetworkInterfaceConfiguration(v *types.VpcRouterNetworkInterfaceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("subnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}
