// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of an existing router input in AWS Elemental
// MediaConnect.
func (c *Client) UpdateRouterInput(ctx context.Context, params *UpdateRouterInputInput, optFns ...func(*Options)) (*UpdateRouterInputOutput, error) {
	if params == nil {
		params = &UpdateRouterInputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRouterInput", params, optFns, c.addOperationUpdateRouterInputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRouterInputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRouterInputInput struct {

	// The Amazon Resource Name (ARN) of the router input that you want to update.
	//
	// This member is required.
	Arn *string

	// The updated configuration settings for the router input. Changing the type of
	// the configuration is not supported.
	Configuration types.RouterInputConfiguration

	// The updated maintenance configuration settings for the router input, including
	// any changes to preferred maintenance windows and schedules.
	MaintenanceConfiguration types.MaintenanceConfiguration

	// The updated maximum bitrate for the router input.
	MaximumBitrate *int64

	// The updated name for the router input.
	Name *string

	// Specifies whether the router input can be assigned to outputs in different
	// Regions. REGIONAL (default) - can be assigned only to outputs in the same
	// Region. GLOBAL - can be assigned to outputs in any Region.
	RoutingScope types.RoutingScope

	// The updated tier level for the router input.
	Tier types.RouterInputTier

	// The updated transit encryption settings for the router input.
	TransitEncryption *types.RouterInputTransitEncryption

	noSmithyDocumentSerde
}

type UpdateRouterInputOutput struct {

	// The updated router input.
	//
	// This member is required.
	RouterInput *types.RouterInput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRouterInputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateRouterInput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateRouterInput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRouterInput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateRouterInputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRouterInput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRouterInput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRouterInput",
	}
}
