// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
func (c *Client) ListRouterNetworkInterfaces(ctx context.Context, params *ListRouterNetworkInterfacesInput, optFns ...func(*Options)) (*ListRouterNetworkInterfacesOutput, error) {
	if params == nil {
		params = &ListRouterNetworkInterfacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRouterNetworkInterfaces", params, optFns, c.addOperationListRouterNetworkInterfacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRouterNetworkInterfacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRouterNetworkInterfacesInput struct {

	// The filters to apply when retrieving the list of router network interfaces.
	Filters []types.RouterNetworkInterfaceFilter

	// The maximum number of router network interfaces to return in the response.
	MaxResults *int32

	// A token used to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRouterNetworkInterfacesOutput struct {

	// The summary information for the retrieved router network interfaces.
	//
	// This member is required.
	RouterNetworkInterfaces []types.ListedRouterNetworkInterface

	// The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRouterNetworkInterfacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRouterNetworkInterfaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRouterNetworkInterfaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRouterNetworkInterfaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRouterNetworkInterfaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRouterNetworkInterfacesPaginatorOptions is the paginator options for
// ListRouterNetworkInterfaces
type ListRouterNetworkInterfacesPaginatorOptions struct {
	// The maximum number of router network interfaces to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRouterNetworkInterfacesPaginator is a paginator for
// ListRouterNetworkInterfaces
type ListRouterNetworkInterfacesPaginator struct {
	options   ListRouterNetworkInterfacesPaginatorOptions
	client    ListRouterNetworkInterfacesAPIClient
	params    *ListRouterNetworkInterfacesInput
	nextToken *string
	firstPage bool
}

// NewListRouterNetworkInterfacesPaginator returns a new
// ListRouterNetworkInterfacesPaginator
func NewListRouterNetworkInterfacesPaginator(client ListRouterNetworkInterfacesAPIClient, params *ListRouterNetworkInterfacesInput, optFns ...func(*ListRouterNetworkInterfacesPaginatorOptions)) *ListRouterNetworkInterfacesPaginator {
	if params == nil {
		params = &ListRouterNetworkInterfacesInput{}
	}

	options := ListRouterNetworkInterfacesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRouterNetworkInterfacesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRouterNetworkInterfacesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRouterNetworkInterfaces page.
func (p *ListRouterNetworkInterfacesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRouterNetworkInterfacesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRouterNetworkInterfaces(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRouterNetworkInterfacesAPIClient is a client that implements the
// ListRouterNetworkInterfaces operation.
type ListRouterNetworkInterfacesAPIClient interface {
	ListRouterNetworkInterfaces(context.Context, *ListRouterNetworkInterfacesInput, ...func(*Options)) (*ListRouterNetworkInterfacesOutput, error)
}

var _ ListRouterNetworkInterfacesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRouterNetworkInterfaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRouterNetworkInterfaces",
	}
}
