// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new router output in AWS Elemental MediaConnect.
func (c *Client) CreateRouterOutput(ctx context.Context, params *CreateRouterOutputInput, optFns ...func(*Options)) (*CreateRouterOutputOutput, error) {
	if params == nil {
		params = &CreateRouterOutputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRouterOutput", params, optFns, c.addOperationCreateRouterOutputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRouterOutputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRouterOutputInput struct {

	// The configuration settings for the router output.
	//
	// This member is required.
	Configuration types.RouterOutputConfiguration

	// The maximum bitrate for the router output.
	//
	// This member is required.
	MaximumBitrate *int64

	// The name of the router output.
	//
	// This member is required.
	Name *string

	// Specifies whether the router output can take inputs that are in different
	// Regions. REGIONAL (default) - can only take inputs from same Region. GLOBAL -
	// can take inputs from any Region.
	//
	// This member is required.
	RoutingScope types.RoutingScope

	// The tier level for the router output.
	//
	// This member is required.
	Tier types.RouterOutputTier

	// The Availability Zone where you want to create the router output. This must be
	// a valid Availability Zone for the region specified by regionName , or the
	// current region if no regionName is provided.
	AvailabilityZone *string

	// A unique identifier for the request to ensure idempotency.
	ClientToken *string

	// The maintenance configuration settings for the router output, including
	// preferred maintenance windows and schedules.
	MaintenanceConfiguration types.MaintenanceConfiguration

	// The AWS Region for the router output. Defaults to the current region if not
	// specified.
	RegionName *string

	// Key-value pairs that can be used to tag this router output.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateRouterOutputOutput struct {

	// The newly-created router output.
	//
	// This member is required.
	RouterOutput *types.RouterOutput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRouterOutputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRouterOutput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRouterOutput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRouterOutput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRouterOutputMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRouterOutputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRouterOutput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateRouterOutput struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRouterOutput) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRouterOutput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRouterOutputInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRouterOutputInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRouterOutputMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRouterOutput{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRouterOutput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRouterOutput",
	}
}
