// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Fetch attributes of an import job.
func (c *Client) GetAddressListImportJob(ctx context.Context, params *GetAddressListImportJobInput, optFns ...func(*Options)) (*GetAddressListImportJobOutput, error) {
	if params == nil {
		params = &GetAddressListImportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAddressListImportJob", params, optFns, c.addOperationGetAddressListImportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAddressListImportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAddressListImportJobInput struct {

	// The identifier of the import job that needs to be retrieved.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

type GetAddressListImportJobOutput struct {

	// The unique identifier of the address list the import job was created for.
	//
	// This member is required.
	AddressListId *string

	// The timestamp of when the import job was created.
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The format of the input for an import job.
	//
	// This member is required.
	ImportDataFormat *types.ImportDataFormat

	// The identifier of the import job.
	//
	// This member is required.
	JobId *string

	// A user-friendly name for the import job.
	//
	// This member is required.
	Name *string

	// The pre-signed URL target for uploading the input file.
	//
	// This member is required.
	PreSignedUrl *string

	// The status of the import job.
	//
	// This member is required.
	Status types.ImportJobStatus

	// The timestamp of when the import job was completed.
	CompletedTimestamp *time.Time

	// The reason for failure of an import job.
	Error *string

	// The number of input addresses that failed to be imported into the address list.
	FailedItemsCount *int32

	// The number of input addresses successfully imported into the address list.
	ImportedItemsCount *int32

	// The timestamp of when the import job was started.
	StartTimestamp *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAddressListImportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAddressListImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAddressListImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAddressListImportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAddressListImportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAddressListImportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAddressListImportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAddressListImportJob",
	}
}
