// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutequipment

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lookoutequipment/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Generates a list of all model versions for a given model, including the model
// version, model version ARN, and status. To list a subset of versions, use the
// MaxModelVersion and MinModelVersion fields.
func (c *Client) ListModelVersions(ctx context.Context, params *ListModelVersionsInput, optFns ...func(*Options)) (*ListModelVersionsOutput, error) {
	if params == nil {
		params = &ListModelVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListModelVersions", params, optFns, c.addOperationListModelVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListModelVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListModelVersionsInput struct {

	// Then name of the machine learning model for which the model versions are to be
	// listed.
	//
	// This member is required.
	ModelName *string

	// Filter results to return all the model versions created before this time.
	CreatedAtEndTime *time.Time

	// Filter results to return all the model versions created after this time.
	CreatedAtStartTime *time.Time

	// Specifies the highest version of the model to return in the list.
	MaxModelVersion *int64

	// Specifies the maximum number of machine learning model versions to list.
	MaxResults *int32

	// Specifies the lowest version of the model to return in the list.
	MinModelVersion *int64

	// If the total number of results exceeds the limit that the response can display,
	// the response returns an opaque pagination token indicating where to continue the
	// listing of machine learning model versions. Use this token in the NextToken
	// field in the request to list the next page of results.
	NextToken *string

	// Filter the results based on the way the model version was generated.
	SourceType types.ModelVersionSourceType

	// Filter the results based on the current status of the model version.
	Status types.ModelVersionStatus

	noSmithyDocumentSerde
}

type ListModelVersionsOutput struct {

	// Provides information on the specified model version, including the created
	// time, model and dataset ARNs, and status.
	//
	// If you don't supply the ModelName request parameter, or if you supply the name
	// of a model that doesn't exist, ListModelVersions returns an empty array in
	// ModelVersionSummaries .
	ModelVersionSummaries []types.ModelVersionSummary

	// If the total number of results exceeds the limit that the response can display,
	// the response returns an opaque pagination token indicating where to continue the
	// listing of machine learning model versions. Use this token in the NextToken
	// field in the request to list the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListModelVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListModelVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListModelVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListModelVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListModelVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListModelVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListModelVersionsPaginatorOptions is the paginator options for ListModelVersions
type ListModelVersionsPaginatorOptions struct {
	// Specifies the maximum number of machine learning model versions to list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListModelVersionsPaginator is a paginator for ListModelVersions
type ListModelVersionsPaginator struct {
	options   ListModelVersionsPaginatorOptions
	client    ListModelVersionsAPIClient
	params    *ListModelVersionsInput
	nextToken *string
	firstPage bool
}

// NewListModelVersionsPaginator returns a new ListModelVersionsPaginator
func NewListModelVersionsPaginator(client ListModelVersionsAPIClient, params *ListModelVersionsInput, optFns ...func(*ListModelVersionsPaginatorOptions)) *ListModelVersionsPaginator {
	if params == nil {
		params = &ListModelVersionsInput{}
	}

	options := ListModelVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListModelVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListModelVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListModelVersions page.
func (p *ListModelVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListModelVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListModelVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListModelVersionsAPIClient is a client that implements the ListModelVersions
// operation.
type ListModelVersionsAPIClient interface {
	ListModelVersions(context.Context, *ListModelVersionsInput, ...func(*Options)) (*ListModelVersionsOutput, error)
}

var _ ListModelVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListModelVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListModelVersions",
	}
}
