// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific [durable execution], including its current status,
// input payload, result or error information, and execution metadata such as start
// time and usage statistics.
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
func (c *Client) GetDurableExecution(ctx context.Context, params *GetDurableExecutionInput, optFns ...func(*Options)) (*GetDurableExecutionOutput, error) {
	if params == nil {
		params = &GetDurableExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDurableExecution", params, optFns, c.addOperationGetDurableExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDurableExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDurableExecutionInput struct {

	// The Amazon Resource Name (ARN) of the durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	noSmithyDocumentSerde
}

// The response from the GetDurableExecution operation, containing detailed
// information about the durable execution.
type GetDurableExecutionOutput struct {

	// The Amazon Resource Name (ARN) of the durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	// The name of the durable execution. This is either the name you provided when
	// invoking the function, or a system-generated unique identifier if no name was
	// provided.
	//
	// This member is required.
	DurableExecutionName *string

	// The Amazon Resource Name (ARN) of the Lambda function that was invoked to start
	// this durable execution.
	//
	// This member is required.
	FunctionArn *string

	// The date and time when the durable execution started, in Unix timestamp format.
	//
	// This member is required.
	StartTimestamp *time.Time

	// The current status of the durable execution. Valid values are RUNNING ,
	// SUCCEEDED , FAILED , TIMED_OUT , and STOPPED .
	//
	// This member is required.
	Status types.ExecutionStatus

	// The date and time when the durable execution ended, in Unix timestamp format.
	// This field is only present if the execution has completed (status is SUCCEEDED ,
	// FAILED , TIMED_OUT , or STOPPED ).
	EndTimestamp *time.Time

	// Error information if the durable execution failed. This field is only present
	// when the execution status is FAILED , TIMED_OUT , or STOPPED . The combined size
	// of all error fields is limited to 256 KB.
	Error *types.ErrorObject

	// The JSON input payload that was provided when the durable execution was
	// started. For asynchronous invocations, this is limited to 256 KB. For
	// synchronous invocations, this can be up to 6 MB.
	InputPayload *string

	// The JSON result returned by the durable execution if it completed successfully.
	// This field is only present when the execution status is SUCCEEDED . The result
	// is limited to 256 KB.
	Result *string

	// The trace headers associated with the durable execution.
	TraceHeader *types.TraceHeader

	// The version of the Lambda function that was invoked for this durable execution.
	// This ensures that all replays during the execution use the same function
	// version.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDurableExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDurableExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDurableExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDurableExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDurableExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDurableExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDurableExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDurableExecution",
	}
}
