// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Saves the progress of a [durable function] execution during runtime. This API is used by the
// Lambda durable functions SDK to checkpoint completed steps and schedule
// asynchronous operations. You typically don't need to call this API directly as
// the SDK handles checkpointing automatically.
//
// Each checkpoint operation consumes the current checkpoint token and returns a
// new one for the next checkpoint. This ensures that checkpoints are applied in
// the correct order and prevents duplicate or out-of-order state updates.
//
// [durable function]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
func (c *Client) CheckpointDurableExecution(ctx context.Context, params *CheckpointDurableExecutionInput, optFns ...func(*Options)) (*CheckpointDurableExecutionOutput, error) {
	if params == nil {
		params = &CheckpointDurableExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CheckpointDurableExecution", params, optFns, c.addOperationCheckpointDurableExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CheckpointDurableExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CheckpointDurableExecutionInput struct {

	// A unique token that identifies the current checkpoint state. This token is
	// provided by the Lambda runtime and must be used to ensure checkpoints are
	// applied in the correct order. Each checkpoint operation consumes this token and
	// returns a new one.
	//
	// This member is required.
	CheckpointToken *string

	// The Amazon Resource Name (ARN) of the durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	// An optional idempotency token to ensure that duplicate checkpoint requests are
	// handled correctly. If provided, Lambda uses this token to detect and handle
	// duplicate requests within a 15-minute window.
	ClientToken *string

	// An array of state updates to apply during this checkpoint. Each update
	// represents a change to the execution state, such as completing a step, starting
	// a callback, or scheduling a timer. Updates are applied atomically as part of the
	// checkpoint operation.
	Updates []types.OperationUpdate

	noSmithyDocumentSerde
}

// The response from the CheckpointDurableExecution operation.
type CheckpointDurableExecutionOutput struct {

	// Updated execution state information that includes any changes that occurred
	// since the last checkpoint, such as completed callbacks or expired timers. This
	// allows the SDK to update its internal state during replay.
	//
	// This member is required.
	NewExecutionState *types.CheckpointUpdatedExecutionState

	// A new checkpoint token to use for the next checkpoint operation. This token
	// replaces the one provided in the request and must be used for subsequent
	// checkpoints to maintain proper ordering.
	CheckpointToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCheckpointDurableExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCheckpointDurableExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCheckpointDurableExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CheckpointDurableExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCheckpointDurableExecutionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCheckpointDurableExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCheckpointDurableExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCheckpointDurableExecution struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCheckpointDurableExecution) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCheckpointDurableExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CheckpointDurableExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CheckpointDurableExecutionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCheckpointDurableExecutionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCheckpointDurableExecution{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCheckpointDurableExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CheckpointDurableExecution",
	}
}
