// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideowebrtcstorage

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Join the ongoing one way-video and/or multi-way audio WebRTC session as a
//
// viewer for an input channel. If there’s no existing session for the channel,
// create a new streaming session and provide the Amazon Resource Name (ARN) of the
// signaling channel ( channelArn ) and client id ( clientId ).
//
// Currently for SINGLE_MASTER type, a video producing device is able to ingest
// both audio and video media into a stream, while viewers can only ingest audio.
// Both a video producing device and viewers can join a session first and wait for
// other participants. While participants are having peer to peer conversations
// through WebRTC, the ingested media session will be stored into the Kinesis Video
// Stream. Multiple viewers are able to playback real-time media.
//
// Customers can also use existing Kinesis Video Streams features like HLS or DASH
// playback, Image generation, and more with ingested WebRTC media. If there’s an
// existing session with the same clientId that's found in the join session
// request, the new request takes precedence.
func (c *Client) JoinStorageSessionAsViewer(ctx context.Context, params *JoinStorageSessionAsViewerInput, optFns ...func(*Options)) (*JoinStorageSessionAsViewerOutput, error) {
	if params == nil {
		params = &JoinStorageSessionAsViewerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "JoinStorageSessionAsViewer", params, optFns, c.addOperationJoinStorageSessionAsViewerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*JoinStorageSessionAsViewerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type JoinStorageSessionAsViewerInput struct {

	//  The Amazon Resource Name (ARN) of the signaling channel.
	//
	// This member is required.
	ChannelArn *string

	//  The unique identifier for the sender client.
	//
	// This member is required.
	ClientId *string

	noSmithyDocumentSerde
}

type JoinStorageSessionAsViewerOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationJoinStorageSessionAsViewerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpJoinStorageSessionAsViewer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpJoinStorageSessionAsViewer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "JoinStorageSessionAsViewer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpJoinStorageSessionAsViewerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opJoinStorageSessionAsViewer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opJoinStorageSessionAsViewer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "JoinStorageSessionAsViewer",
	}
}
