// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalytics

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalytics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption struct {
}

func (*awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationCloudWatchLoggingOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationCloudWatchLoggingOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.AddApplicationCloudWatchLoggingOption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationCloudWatchLoggingOptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationInput struct {
}

func (*awsAwsjson11_serializeOpAddApplicationInput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.AddApplicationInput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration struct {
}

func (*awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationInputProcessingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationInputProcessingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.AddApplicationInputProcessingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationInputProcessingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationOutput struct {
}

func (*awsAwsjson11_serializeOpAddApplicationOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.AddApplicationOutput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddApplicationReferenceDataSource struct {
}

func (*awsAwsjson11_serializeOpAddApplicationReferenceDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddApplicationReferenceDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddApplicationReferenceDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.AddApplicationReferenceDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddApplicationReferenceDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateApplication struct {
}

func (*awsAwsjson11_serializeOpCreateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.CreateApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplication struct {
}

func (*awsAwsjson11_serializeOpDeleteApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DeleteApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationCloudWatchLoggingOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationCloudWatchLoggingOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DeleteApplicationCloudWatchLoggingOption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationCloudWatchLoggingOptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationInputProcessingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInputProcessingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DeleteApplicationInputProcessingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationInputProcessingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationOutput struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DeleteApplicationOutput")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource struct {
}

func (*awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteApplicationReferenceDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationReferenceDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DeleteApplicationReferenceDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteApplicationReferenceDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplication struct {
}

func (*awsAwsjson11_serializeOpDescribeApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DescribeApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDiscoverInputSchema struct {
}

func (*awsAwsjson11_serializeOpDiscoverInputSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDiscoverInputSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DiscoverInputSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.DiscoverInputSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDiscoverInputSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplications struct {
}

func (*awsAwsjson11_serializeOpListApplications) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.ListApplications")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartApplication struct {
}

func (*awsAwsjson11_serializeOpStartApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.StartApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopApplication struct {
}

func (*awsAwsjson11_serializeOpStopApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.StopApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateApplication struct {
}

func (*awsAwsjson11_serializeOpUpdateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("KinesisAnalytics_20150814.UpdateApplication")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentApplicationUpdate(v *types.ApplicationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationCodeUpdate != nil {
		ok := object.Key("ApplicationCodeUpdate")
		ok.String(*v.ApplicationCodeUpdate)
	}

	if v.CloudWatchLoggingOptionUpdates != nil {
		ok := object.Key("CloudWatchLoggingOptionUpdates")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdates(v.CloudWatchLoggingOptionUpdates, ok); err != nil {
			return err
		}
	}

	if v.InputUpdates != nil {
		ok := object.Key("InputUpdates")
		if err := awsAwsjson11_serializeDocumentInputUpdates(v.InputUpdates, ok); err != nil {
			return err
		}
	}

	if v.OutputUpdates != nil {
		ok := object.Key("OutputUpdates")
		if err := awsAwsjson11_serializeDocumentOutputUpdates(v.OutputUpdates, ok); err != nil {
			return err
		}
	}

	if v.ReferenceDataSourceUpdates != nil {
		ok := object.Key("ReferenceDataSourceUpdates")
		if err := awsAwsjson11_serializeDocumentReferenceDataSourceUpdates(v.ReferenceDataSourceUpdates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOption(v *types.CloudWatchLoggingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogStreamARN != nil {
		ok := object.Key("LogStreamARN")
		ok.String(*v.LogStreamARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v []types.CloudWatchLoggingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdate(v *types.CloudWatchLoggingOptionUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLoggingOptionId != nil {
		ok := object.Key("CloudWatchLoggingOptionId")
		ok.String(*v.CloudWatchLoggingOptionId)
	}

	if v.LogStreamARNUpdate != nil {
		ok := object.Key("LogStreamARNUpdate")
		ok.String(*v.LogStreamARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdates(v []types.CloudWatchLoggingOptionUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptionUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCSVMappingParameters(v *types.CSVMappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumnDelimiter != nil {
		ok := object.Key("RecordColumnDelimiter")
		ok.String(*v.RecordColumnDelimiter)
	}

	if v.RecordRowDelimiter != nil {
		ok := object.Key("RecordRowDelimiter")
		ok.String(*v.RecordRowDelimiter)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDestinationSchema(v *types.DestinationSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RecordFormatType) > 0 {
		ok := object.Key("RecordFormatType")
		ok.String(string(v.RecordFormatType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentInput(v *types.Input, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputParallelism != nil {
		ok := object.Key("InputParallelism")
		if err := awsAwsjson11_serializeDocumentInputParallelism(v.InputParallelism, ok); err != nil {
			return err
		}
	}

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InputSchema != nil {
		ok := object.Key("InputSchema")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.InputSchema, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseInput != nil {
		ok := object.Key("KinesisFirehoseInput")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseInput(v.KinesisFirehoseInput, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsInput != nil {
		ok := object.Key("KinesisStreamsInput")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsInput(v.KinesisStreamsInput, ok); err != nil {
			return err
		}
	}

	if v.NamePrefix != nil {
		ok := object.Key("NamePrefix")
		ok.String(*v.NamePrefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputConfiguration(v *types.InputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.InputStartingPositionConfiguration != nil {
		ok := object.Key("InputStartingPositionConfiguration")
		if err := awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v.InputStartingPositionConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputConfigurations(v []types.InputConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInputConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInputLambdaProcessor(v *types.InputLambdaProcessor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputLambdaProcessorUpdate(v *types.InputLambdaProcessorUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputParallelism(v *types.InputParallelism, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Count != nil {
		ok := object.Key("Count")
		ok.Integer(*v.Count)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputParallelismUpdate(v *types.InputParallelismUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CountUpdate != nil {
		ok := object.Key("CountUpdate")
		ok.Integer(*v.CountUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputProcessingConfiguration(v *types.InputProcessingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputLambdaProcessor != nil {
		ok := object.Key("InputLambdaProcessor")
		if err := awsAwsjson11_serializeDocumentInputLambdaProcessor(v.InputLambdaProcessor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputProcessingConfigurationUpdate(v *types.InputProcessingConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputLambdaProcessorUpdate != nil {
		ok := object.Key("InputLambdaProcessorUpdate")
		if err := awsAwsjson11_serializeDocumentInputLambdaProcessorUpdate(v.InputLambdaProcessorUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputs(v []types.Input, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInputSchemaUpdate(v *types.InputSchemaUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumnUpdates != nil {
		ok := object.Key("RecordColumnUpdates")
		if err := awsAwsjson11_serializeDocumentRecordColumns(v.RecordColumnUpdates, ok); err != nil {
			return err
		}
	}

	if v.RecordEncodingUpdate != nil {
		ok := object.Key("RecordEncodingUpdate")
		ok.String(*v.RecordEncodingUpdate)
	}

	if v.RecordFormatUpdate != nil {
		ok := object.Key("RecordFormatUpdate")
		if err := awsAwsjson11_serializeDocumentRecordFormat(v.RecordFormatUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v *types.InputStartingPositionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputStartingPosition) > 0 {
		ok := object.Key("InputStartingPosition")
		ok.String(string(v.InputStartingPosition))
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputUpdate(v *types.InputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	if v.InputParallelismUpdate != nil {
		ok := object.Key("InputParallelismUpdate")
		if err := awsAwsjson11_serializeDocumentInputParallelismUpdate(v.InputParallelismUpdate, ok); err != nil {
			return err
		}
	}

	if v.InputProcessingConfigurationUpdate != nil {
		ok := object.Key("InputProcessingConfigurationUpdate")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfigurationUpdate(v.InputProcessingConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.InputSchemaUpdate != nil {
		ok := object.Key("InputSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentInputSchemaUpdate(v.InputSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseInputUpdate != nil {
		ok := object.Key("KinesisFirehoseInputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseInputUpdate(v.KinesisFirehoseInputUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsInputUpdate != nil {
		ok := object.Key("KinesisStreamsInputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsInputUpdate(v.KinesisStreamsInputUpdate, ok); err != nil {
			return err
		}
	}

	if v.NamePrefixUpdate != nil {
		ok := object.Key("NamePrefixUpdate")
		ok.String(*v.NamePrefixUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputUpdates(v []types.InputUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInputUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJSONMappingParameters(v *types.JSONMappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordRowPath != nil {
		ok := object.Key("RecordRowPath")
		ok.String(*v.RecordRowPath)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseInput(v *types.KinesisFirehoseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseInputUpdate(v *types.KinesisFirehoseInputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseOutput(v *types.KinesisFirehoseOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisFirehoseOutputUpdate(v *types.KinesisFirehoseOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsInput(v *types.KinesisStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsInputUpdate(v *types.KinesisStreamsInputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsOutput(v *types.KinesisStreamsOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamsOutputUpdate(v *types.KinesisStreamsOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaOutput(v *types.LambdaOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaOutputUpdate(v *types.LambdaOutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARNUpdate != nil {
		ok := object.Key("ResourceARNUpdate")
		ok.String(*v.ResourceARNUpdate)
	}

	if v.RoleARNUpdate != nil {
		ok := object.Key("RoleARNUpdate")
		ok.String(*v.RoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMappingParameters(v *types.MappingParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CSVMappingParameters != nil {
		ok := object.Key("CSVMappingParameters")
		if err := awsAwsjson11_serializeDocumentCSVMappingParameters(v.CSVMappingParameters, ok); err != nil {
			return err
		}
	}

	if v.JSONMappingParameters != nil {
		ok := object.Key("JSONMappingParameters")
		if err := awsAwsjson11_serializeDocumentJSONMappingParameters(v.JSONMappingParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutput(v *types.Output, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationSchema != nil {
		ok := object.Key("DestinationSchema")
		if err := awsAwsjson11_serializeDocumentDestinationSchema(v.DestinationSchema, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseOutput != nil {
		ok := object.Key("KinesisFirehoseOutput")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseOutput(v.KinesisFirehoseOutput, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsOutput != nil {
		ok := object.Key("KinesisStreamsOutput")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsOutput(v.KinesisStreamsOutput, ok); err != nil {
			return err
		}
	}

	if v.LambdaOutput != nil {
		ok := object.Key("LambdaOutput")
		if err := awsAwsjson11_serializeDocumentLambdaOutput(v.LambdaOutput, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputs(v []types.Output, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOutput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOutputUpdate(v *types.OutputUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationSchemaUpdate != nil {
		ok := object.Key("DestinationSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentDestinationSchema(v.DestinationSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisFirehoseOutputUpdate != nil {
		ok := object.Key("KinesisFirehoseOutputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisFirehoseOutputUpdate(v.KinesisFirehoseOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamsOutputUpdate != nil {
		ok := object.Key("KinesisStreamsOutputUpdate")
		if err := awsAwsjson11_serializeDocumentKinesisStreamsOutputUpdate(v.KinesisStreamsOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.LambdaOutputUpdate != nil {
		ok := object.Key("LambdaOutputUpdate")
		if err := awsAwsjson11_serializeDocumentLambdaOutputUpdate(v.LambdaOutputUpdate, ok); err != nil {
			return err
		}
	}

	if v.NameUpdate != nil {
		ok := object.Key("NameUpdate")
		ok.String(*v.NameUpdate)
	}

	if v.OutputId != nil {
		ok := object.Key("OutputId")
		ok.String(*v.OutputId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputUpdates(v []types.OutputUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOutputUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecordColumn(v *types.RecordColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mapping != nil {
		ok := object.Key("Mapping")
		ok.String(*v.Mapping)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SqlType != nil {
		ok := object.Key("SqlType")
		ok.String(*v.SqlType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecordColumns(v []types.RecordColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRecordColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecordFormat(v *types.RecordFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MappingParameters != nil {
		ok := object.Key("MappingParameters")
		if err := awsAwsjson11_serializeDocumentMappingParameters(v.MappingParameters, ok); err != nil {
			return err
		}
	}

	if len(v.RecordFormatType) > 0 {
		ok := object.Key("RecordFormatType")
		ok.String(string(v.RecordFormatType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSource(v *types.ReferenceDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceSchema != nil {
		ok := object.Key("ReferenceSchema")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.ReferenceSchema, ok); err != nil {
			return err
		}
	}

	if v.S3ReferenceDataSource != nil {
		ok := object.Key("S3ReferenceDataSource")
		if err := awsAwsjson11_serializeDocumentS3ReferenceDataSource(v.S3ReferenceDataSource, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSourceUpdate(v *types.ReferenceDataSourceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceId != nil {
		ok := object.Key("ReferenceId")
		ok.String(*v.ReferenceId)
	}

	if v.ReferenceSchemaUpdate != nil {
		ok := object.Key("ReferenceSchemaUpdate")
		if err := awsAwsjson11_serializeDocumentSourceSchema(v.ReferenceSchemaUpdate, ok); err != nil {
			return err
		}
	}

	if v.S3ReferenceDataSourceUpdate != nil {
		ok := object.Key("S3ReferenceDataSourceUpdate")
		if err := awsAwsjson11_serializeDocumentS3ReferenceDataSourceUpdate(v.S3ReferenceDataSourceUpdate, ok); err != nil {
			return err
		}
	}

	if v.TableNameUpdate != nil {
		ok := object.Key("TableNameUpdate")
		ok.String(*v.TableNameUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentReferenceDataSourceUpdates(v []types.ReferenceDataSourceUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentReferenceDataSourceUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3Configuration(v *types.S3Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.FileKey != nil {
		ok := object.Key("FileKey")
		ok.String(*v.FileKey)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ReferenceDataSource(v *types.S3ReferenceDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.FileKey != nil {
		ok := object.Key("FileKey")
		ok.String(*v.FileKey)
	}

	if v.ReferenceRoleARN != nil {
		ok := object.Key("ReferenceRoleARN")
		ok.String(*v.ReferenceRoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ReferenceDataSourceUpdate(v *types.S3ReferenceDataSourceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARNUpdate != nil {
		ok := object.Key("BucketARNUpdate")
		ok.String(*v.BucketARNUpdate)
	}

	if v.FileKeyUpdate != nil {
		ok := object.Key("FileKeyUpdate")
		ok.String(*v.FileKeyUpdate)
	}

	if v.ReferenceRoleARNUpdate != nil {
		ok := object.Key("ReferenceRoleARNUpdate")
		ok.String(*v.ReferenceRoleARNUpdate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSourceSchema(v *types.SourceSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecordColumns != nil {
		ok := object.Key("RecordColumns")
		if err := awsAwsjson11_serializeDocumentRecordColumns(v.RecordColumns, ok); err != nil {
			return err
		}
	}

	if v.RecordEncoding != nil {
		ok := object.Key("RecordEncoding")
		ok.String(*v.RecordEncoding)
	}

	if v.RecordFormat != nil {
		ok := object.Key("RecordFormat")
		if err := awsAwsjson11_serializeDocumentRecordFormat(v.RecordFormat, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationCloudWatchLoggingOptionInput(v *AddApplicationCloudWatchLoggingOptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOption != nil {
		ok := object.Key("CloudWatchLoggingOption")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOption(v.CloudWatchLoggingOption, ok); err != nil {
			return err
		}
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationInputInput(v *AddApplicationInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.Input != nil {
		ok := object.Key("Input")
		if err := awsAwsjson11_serializeDocumentInput(v.Input, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationInputProcessingConfigurationInput(v *AddApplicationInputProcessingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationOutputInput(v *AddApplicationOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.Output != nil {
		ok := object.Key("Output")
		if err := awsAwsjson11_serializeDocumentOutput(v.Output, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddApplicationReferenceDataSourceInput(v *AddApplicationReferenceDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.ReferenceDataSource != nil {
		ok := object.Key("ReferenceDataSource")
		if err := awsAwsjson11_serializeDocumentReferenceDataSource(v.ReferenceDataSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateApplicationInput(v *CreateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationCode != nil {
		ok := object.Key("ApplicationCode")
		ok.String(*v.ApplicationCode)
	}

	if v.ApplicationDescription != nil {
		ok := object.Key("ApplicationDescription")
		ok.String(*v.ApplicationDescription)
	}

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.Inputs != nil {
		ok := object.Key("Inputs")
		if err := awsAwsjson11_serializeDocumentInputs(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("Outputs")
		if err := awsAwsjson11_serializeDocumentOutputs(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationCloudWatchLoggingOptionInput(v *DeleteApplicationCloudWatchLoggingOptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CloudWatchLoggingOptionId != nil {
		ok := object.Key("CloudWatchLoggingOptionId")
		ok.String(*v.CloudWatchLoggingOptionId)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationInput(v *DeleteApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CreateTimestamp != nil {
		ok := object.Key("CreateTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreateTimestamp))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationInputProcessingConfigurationInput(v *DeleteApplicationInputProcessingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.InputId != nil {
		ok := object.Key("InputId")
		ok.String(*v.InputId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationOutputInput(v *DeleteApplicationOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.OutputId != nil {
		ok := object.Key("OutputId")
		ok.String(*v.OutputId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteApplicationReferenceDataSourceInput(v *DeleteApplicationReferenceDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	if v.ReferenceId != nil {
		ok := object.Key("ReferenceId")
		ok.String(*v.ReferenceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationInput(v *DescribeApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDiscoverInputSchemaInput(v *DiscoverInputSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputProcessingConfiguration != nil {
		ok := object.Key("InputProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentInputProcessingConfiguration(v.InputProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InputStartingPositionConfiguration != nil {
		ok := object.Key("InputStartingPositionConfiguration")
		if err := awsAwsjson11_serializeDocumentInputStartingPositionConfiguration(v.InputStartingPositionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3Configuration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationsInput(v *ListApplicationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExclusiveStartApplicationName != nil {
		ok := object.Key("ExclusiveStartApplicationName")
		ok.String(*v.ExclusiveStartApplicationName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartApplicationInput(v *StartApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.InputConfigurations != nil {
		ok := object.Key("InputConfigurations")
		if err := awsAwsjson11_serializeDocumentInputConfigurations(v.InputConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopApplicationInput(v *StopApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateApplicationInput(v *UpdateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.ApplicationUpdate != nil {
		ok := object.Key("ApplicationUpdate")
		if err := awsAwsjson11_serializeDocumentApplicationUpdate(v.ApplicationUpdate, ok); err != nil {
			return err
		}
	}

	if v.CurrentApplicationVersionId != nil {
		ok := object.Key("CurrentApplicationVersionId")
		ok.Long(*v.CurrentApplicationVersionId)
	}

	return nil
}
