// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a cell in an Amazon Keyspaces table, containing both the value and
// metadata about the cell.
type KeyspacesCell struct {

	// Metadata associated with this cell, such as time-to-live (TTL) expiration time
	// and write timestamp.
	Metadata *KeyspacesMetadata

	// The value stored in this cell, which can be of various data types supported by
	// Amazon Keyspaces.
	Value KeyspacesCellValue

	noSmithyDocumentSerde
}

// Represents a key-value pair within a map data type in Amazon Keyspaces,
// including the associated metadata.
type KeyspacesCellMapDefinition struct {

	// The key of this map entry in the Amazon Keyspaces cell.
	Key KeyspacesCellValue

	// Metadata for this specific key-value pair within the map, such as timestamps
	// and TTL information.
	Metadata *KeyspacesMetadata

	// The value associated with the key in this map entry.
	Value KeyspacesCellValue

	noSmithyDocumentSerde
}

// Represents the value of a cell in an Amazon Keyspaces table, supporting various
// data types with type-specific fields.
//
// The following types satisfy this interface:
//
//	KeyspacesCellValueMemberAsciiT
//	KeyspacesCellValueMemberBigintT
//	KeyspacesCellValueMemberBlobT
//	KeyspacesCellValueMemberBoolT
//	KeyspacesCellValueMemberCounterT
//	KeyspacesCellValueMemberDateT
//	KeyspacesCellValueMemberDecimalT
//	KeyspacesCellValueMemberDoubleT
//	KeyspacesCellValueMemberFloatT
//	KeyspacesCellValueMemberInetT
//	KeyspacesCellValueMemberIntT
//	KeyspacesCellValueMemberListT
//	KeyspacesCellValueMemberMapT
//	KeyspacesCellValueMemberSetT
//	KeyspacesCellValueMemberSmallintT
//	KeyspacesCellValueMemberTextT
//	KeyspacesCellValueMemberTimestampT
//	KeyspacesCellValueMemberTimeT
//	KeyspacesCellValueMemberTimeuuidT
//	KeyspacesCellValueMemberTinyintT
//	KeyspacesCellValueMemberTupleT
//	KeyspacesCellValueMemberUdtT
//	KeyspacesCellValueMemberUuidT
//	KeyspacesCellValueMemberVarcharT
//	KeyspacesCellValueMemberVarintT
type KeyspacesCellValue interface {
	isKeyspacesCellValue()
}

// A value of ASCII text type, containing US-ASCII characters.
type KeyspacesCellValueMemberAsciiT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberAsciiT) isKeyspacesCellValue() {}

// A 64-bit signed integer value.
type KeyspacesCellValueMemberBigintT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberBigintT) isKeyspacesCellValue() {}

// A binary large object (BLOB) value stored as a Base64-encoded string.
type KeyspacesCellValueMemberBlobT struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberBlobT) isKeyspacesCellValue() {}

// A Boolean value, either true or false .
type KeyspacesCellValueMemberBoolT struct {
	Value bool

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberBoolT) isKeyspacesCellValue() {}

// A distributed counter value that can be incremented and decremented.
type KeyspacesCellValueMemberCounterT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberCounterT) isKeyspacesCellValue() {}

// A date value without a time component, represented as days since epoch (January
// 1, 1970).
type KeyspacesCellValueMemberDateT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberDateT) isKeyspacesCellValue() {}

// A variable-precision decimal number value.
type KeyspacesCellValueMemberDecimalT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberDecimalT) isKeyspacesCellValue() {}

// A 64-bit double-precision floating point value.
type KeyspacesCellValueMemberDoubleT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberDoubleT) isKeyspacesCellValue() {}

// A 32-bit single-precision floating point value.
type KeyspacesCellValueMemberFloatT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberFloatT) isKeyspacesCellValue() {}

// An IP address value, either IPv4 or IPv6 format.
type KeyspacesCellValueMemberInetT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberInetT) isKeyspacesCellValue() {}

// A 32-bit signed integer value.
type KeyspacesCellValueMemberIntT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberIntT) isKeyspacesCellValue() {}

// An ordered collection of elements that can contain duplicate values.
type KeyspacesCellValueMemberListT struct {
	Value []KeyspacesCell

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberListT) isKeyspacesCellValue() {}

// A collection of key-value pairs where each key is unique.
type KeyspacesCellValueMemberMapT struct {
	Value []KeyspacesCellMapDefinition

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberMapT) isKeyspacesCellValue() {}

// An unordered collection of unique elements.
type KeyspacesCellValueMemberSetT struct {
	Value []KeyspacesCell

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberSetT) isKeyspacesCellValue() {}

// A 16-bit signed integer value.
type KeyspacesCellValueMemberSmallintT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberSmallintT) isKeyspacesCellValue() {}

// A UTF-8 encoded string value.
type KeyspacesCellValueMemberTextT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTextT) isKeyspacesCellValue() {}

// A timestamp value representing date and time with millisecond precision.
type KeyspacesCellValueMemberTimestampT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTimestampT) isKeyspacesCellValue() {}

// A time value without a date component, with nanosecond precision.
type KeyspacesCellValueMemberTimeT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTimeT) isKeyspacesCellValue() {}

// A universally unique identifier (UUID) that includes a timestamp component,
// ensuring both uniqueness and time ordering.
type KeyspacesCellValueMemberTimeuuidT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTimeuuidT) isKeyspacesCellValue() {}

// An 8-bit signed integer value.
type KeyspacesCellValueMemberTinyintT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTinyintT) isKeyspacesCellValue() {}

// A fixed-length ordered list of elements, where each element can be of a
// different data type.
type KeyspacesCellValueMemberTupleT struct {
	Value []KeyspacesCell

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberTupleT) isKeyspacesCellValue() {}

// A user-defined type (UDT) value consisting of named fields, each with its own
// data type.
type KeyspacesCellValueMemberUdtT struct {
	Value map[string]KeyspacesCell

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberUdtT) isKeyspacesCellValue() {}

// A universally unique identifier (UUID) value.
type KeyspacesCellValueMemberUuidT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberUuidT) isKeyspacesCellValue() {}

// A UTF-8 encoded string value, functionally equivalent to text type.
type KeyspacesCellValueMemberVarcharT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberVarcharT) isKeyspacesCellValue() {}

// A variable precision integer value with arbitrary length.
type KeyspacesCellValueMemberVarintT struct {
	Value string

	noSmithyDocumentSerde
}

func (*KeyspacesCellValueMemberVarintT) isKeyspacesCellValue() {}

// Contains metadata information associated with Amazon Keyspaces cells and rows.
type KeyspacesMetadata struct {

	// The time at which the associated data will expire, based on the time-to-live
	// (TTL) setting.
	ExpirationTime *string

	// The timestamp at which the associated data was written to the database.
	WriteTime *string

	noSmithyDocumentSerde
}

// Represents a row in an Amazon Keyspaces table, containing regular column
// values, static column values, and row-level metadata.
type KeyspacesRow struct {

	// Metadata that applies to the entire row, such as timestamps and TTL information.
	RowMetadata *KeyspacesMetadata

	// A map of static column cells shared by all rows with the same partition key,
	// where keys are column names and values are the corresponding cells.
	StaticCells map[string]KeyspacesCell

	// A map of regular (non-static) column cells in the row, where keys are column
	// names and values are the corresponding cells.
	ValueCells map[string]KeyspacesCell

	noSmithyDocumentSerde
}

// Represents a change data capture record for a row in an Amazon Keyspaces table,
// containing both the new and old states of the row.
type Record struct {

	// The clustering key columns and their values for the affected row, which
	// determine the order of rows within a partition.
	ClusteringKeys map[string]KeyspacesCellValue

	// The timestamp indicating when this change data capture record was created.
	CreatedAt *time.Time

	// The version of the record format, used to track the evolution of the record
	// structure over time.
	EventVersion *string

	// The state of the row after the change operation that generated this record.
	NewImage *KeyspacesRow

	// The state of the row before the change operation that generated this record.
	OldImage *KeyspacesRow

	// The origin or source of this change data capture record.
	Origin OriginType

	// The partition key columns and their values for the affected row.
	PartitionKeys map[string]KeyspacesCellValue

	// A unique identifier assigned to this record within the shard, used for ordering
	// and tracking purposes.
	SequenceNumber *string

	noSmithyDocumentSerde
}

// Defines a range of sequence numbers within a change data capture stream's shard
// for Amazon Keyspaces.
type SequenceNumberRange struct {

	// The ending sequence number of the range, which may be null for open-ended
	// ranges.
	EndingSequenceNumber *string

	// The starting sequence number of the range.
	StartingSequenceNumber *string

	noSmithyDocumentSerde
}

// Represents a uniquely identified group of change records within a change data
// capture stream for Amazon Keyspaces.
type Shard struct {

	// The identifiers of parent shards that this shard evolved from, if this shard
	// was created through resharding.
	ParentShardIds []string

	// The range of sequence numbers contained within this shard.
	SequenceNumberRange *SequenceNumberRange

	// A unique identifier for this shard within the stream.
	ShardId *string

	noSmithyDocumentSerde
}

// A filter used to limit the shards returned by a GetStream operation.
type ShardFilter struct {

	// The identifier of a specific shard used to filter results based on the
	// specified filter type.
	ShardId *string

	// The type of shard filter to use, which determines how the shardId parameter is
	// interpreted.
	Type ShardFilterType

	noSmithyDocumentSerde
}

// Represents a change data capture stream for an Amazon Keyspaces table, which
// enables tracking and processing of data changes.
type Stream struct {

	// The name of the keyspace containing the table associated with this stream.
	//
	// This member is required.
	KeyspaceName *string

	// The Amazon Resource Name (ARN) that uniquely identifies this stream.
	//
	// This member is required.
	StreamArn *string

	// A unique identifier for this stream that can be used in stream operations.
	//
	// This member is required.
	StreamLabel *string

	// The name of the table associated with this stream.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isKeyspacesCellValue() {}
