// Code generated by smithy-go-codegen DO NOT EDIT.

package keyspacesstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/keyspacesstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a shard iterator that serves as a bookmark for reading data from a
// specific position in an Amazon Keyspaces data stream's shard. The shard iterator
// specifies the shard position from which to start reading data records
// sequentially. You can specify whether to begin reading at the latest record, the
// oldest record, or at a particular sequence number within the shard.
func (c *Client) GetShardIterator(ctx context.Context, params *GetShardIteratorInput, optFns ...func(*Options)) (*GetShardIteratorOutput, error) {
	if params == nil {
		params = &GetShardIteratorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetShardIterator", params, optFns, c.addOperationGetShardIteratorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetShardIteratorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetShardIteratorInput struct {

	//  The identifier of the shard within the stream. The shard ID uniquely
	// identifies a subset of the stream's data records that you want to access.
	//
	// This member is required.
	ShardId *string

	//  Determines how the shard iterator is positioned. Must be one of the following:
	//
	//   - TRIM_HORIZON - Start reading at the last untrimmed record in the shard,
	//   which is the oldest data record in the shard.
	//
	//   - AT_SEQUENCE_NUMBER - Start reading exactly from the specified sequence
	//   number.
	//
	//   - AFTER_SEQUENCE_NUMBER - Start reading right after the specified sequence
	//   number.
	//
	//   - LATEST - Start reading just after the most recent record in the shard, so
	//   that you always read the most recent data.
	//
	// This member is required.
	ShardIteratorType types.ShardIteratorType

	//  The Amazon Resource Name (ARN) of the stream for which to get the shard
	// iterator. The ARN uniquely identifies the stream within Amazon Keyspaces.
	//
	// This member is required.
	StreamArn *string

	//  The sequence number of the data record in the shard from which to start
	// reading. Required if ShardIteratorType is AT_SEQUENCE_NUMBER or
	// AFTER_SEQUENCE_NUMBER . This parameter is ignored for other iterator types.
	SequenceNumber *string

	noSmithyDocumentSerde
}

type GetShardIteratorOutput struct {

	//  The unique identifier for the shard iterator. This value is used in the
	// GetRecords operation to retrieve data records from the specified shard. Each
	// shard iterator expires 15 minutes after it is returned to the requester.
	ShardIterator *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetShardIteratorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetShardIterator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetShardIterator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetShardIterator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetShardIteratorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetShardIterator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetShardIterator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetShardIterator",
	}
}
