// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all distinct resources that are resolved from the executed actions of the
// computation model.
func (c *Client) ListComputationModelResolveToResources(ctx context.Context, params *ListComputationModelResolveToResourcesInput, optFns ...func(*Options)) (*ListComputationModelResolveToResourcesOutput, error) {
	if params == nil {
		params = &ListComputationModelResolveToResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListComputationModelResolveToResources", params, optFns, c.addOperationListComputationModelResolveToResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListComputationModelResolveToResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListComputationModelResolveToResourcesInput struct {

	// The ID of the computation model for which to list resolved resources.
	//
	// This member is required.
	ComputationModelId *string

	// The maximum number of results returned for each paginated request.
	MaxResults *int32

	// The token used for the next set of paginated results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListComputationModelResolveToResourcesOutput struct {

	// A list of summaries describing the distinct resources that this computation
	// model resolves to when actions were executed.
	//
	// This member is required.
	ComputationModelResolveToResourceSummaries []types.ComputationModelResolveToResourceSummary

	// The token for the next set of paginated results, or null if there are no
	// additional results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListComputationModelResolveToResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListComputationModelResolveToResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListComputationModelResolveToResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListComputationModelResolveToResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListComputationModelResolveToResourcesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListComputationModelResolveToResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListComputationModelResolveToResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListComputationModelResolveToResourcesPaginatorOptions is the paginator options
// for ListComputationModelResolveToResources
type ListComputationModelResolveToResourcesPaginatorOptions struct {
	// The maximum number of results returned for each paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListComputationModelResolveToResourcesPaginator is a paginator for
// ListComputationModelResolveToResources
type ListComputationModelResolveToResourcesPaginator struct {
	options   ListComputationModelResolveToResourcesPaginatorOptions
	client    ListComputationModelResolveToResourcesAPIClient
	params    *ListComputationModelResolveToResourcesInput
	nextToken *string
	firstPage bool
}

// NewListComputationModelResolveToResourcesPaginator returns a new
// ListComputationModelResolveToResourcesPaginator
func NewListComputationModelResolveToResourcesPaginator(client ListComputationModelResolveToResourcesAPIClient, params *ListComputationModelResolveToResourcesInput, optFns ...func(*ListComputationModelResolveToResourcesPaginatorOptions)) *ListComputationModelResolveToResourcesPaginator {
	if params == nil {
		params = &ListComputationModelResolveToResourcesInput{}
	}

	options := ListComputationModelResolveToResourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListComputationModelResolveToResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListComputationModelResolveToResourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListComputationModelResolveToResources page.
func (p *ListComputationModelResolveToResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListComputationModelResolveToResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListComputationModelResolveToResources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opListComputationModelResolveToResourcesMiddleware struct {
}

func (*endpointPrefix_opListComputationModelResolveToResourcesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListComputationModelResolveToResourcesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListComputationModelResolveToResourcesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListComputationModelResolveToResourcesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListComputationModelResolveToResourcesAPIClient is a client that implements the
// ListComputationModelResolveToResources operation.
type ListComputationModelResolveToResourcesAPIClient interface {
	ListComputationModelResolveToResources(context.Context, *ListComputationModelResolveToResourcesInput, ...func(*Options)) (*ListComputationModelResolveToResourcesOutput, error)
}

var _ ListComputationModelResolveToResourcesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListComputationModelResolveToResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListComputationModelResolveToResources",
	}
}
