// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a computation model.
func (c *Client) DescribeComputationModel(ctx context.Context, params *DescribeComputationModelInput, optFns ...func(*Options)) (*DescribeComputationModelOutput, error) {
	if params == nil {
		params = &DescribeComputationModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeComputationModel", params, optFns, c.addOperationDescribeComputationModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeComputationModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeComputationModelInput struct {

	// The ID of the computation model.
	//
	// This member is required.
	ComputationModelId *string

	// The version of the computation model.
	ComputationModelVersion *string

	noSmithyDocumentSerde
}

type DescribeComputationModelOutput struct {

	// The available actions for this computation model.
	//
	// This member is required.
	ActionDefinitions []types.ActionDefinition

	// The [ARN] of the computation model, which has the following format.
	//
	//     arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	ComputationModelArn *string

	// The configuration for the computation model.
	//
	// This member is required.
	ComputationModelConfiguration *types.ComputationModelConfiguration

	// The model creation date, in Unix epoch time.
	//
	// This member is required.
	ComputationModelCreationDate *time.Time

	// The data binding for the computation model. Key is a variable name defined in
	// configuration. Value is a ComputationModelDataBindingValue referenced by the
	// variable.
	//
	// This member is required.
	ComputationModelDataBinding map[string]types.ComputationModelDataBindingValue

	// The ID of the computation model.
	//
	// This member is required.
	ComputationModelId *string

	// The date the model was last updated, in Unix epoch time.
	//
	// This member is required.
	ComputationModelLastUpdateDate *time.Time

	// The name of the computation model.
	//
	// This member is required.
	ComputationModelName *string

	// The current status of the asset model, which contains a state and an error
	// message if any.
	//
	// This member is required.
	ComputationModelStatus *types.ComputationModelStatus

	// The version of the computation model.
	//
	// This member is required.
	ComputationModelVersion *string

	// The description of the computation model.
	ComputationModelDescription *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeComputationModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeComputationModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeComputationModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeComputationModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opDescribeComputationModelMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeComputationModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeComputationModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opDescribeComputationModelMiddleware struct {
}

func (*endpointPrefix_opDescribeComputationModelMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opDescribeComputationModelMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opDescribeComputationModelMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opDescribeComputationModelMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opDescribeComputationModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeComputationModel",
	}
}
