// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	This API is used to start device discovery for hub-connected and
//
// third-party-connected devices. The authentication material (install code) is
// delivered as a message to the controller instructing it to start the discovery.
func (c *Client) StartDeviceDiscovery(ctx context.Context, params *StartDeviceDiscoveryInput, optFns ...func(*Options)) (*StartDeviceDiscoveryOutput, error) {
	if params == nil {
		params = &StartDeviceDiscoveryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDeviceDiscovery", params, optFns, c.addOperationStartDeviceDiscoveryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDeviceDiscoveryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDeviceDiscoveryInput struct {

	// The discovery type supporting the type of device to be discovered in the device
	// discovery task request.
	//
	// This member is required.
	DiscoveryType types.DiscoveryType

	// The identifier of the cloud-to-cloud account association to use for discovery
	// of third-party devices.
	AccountAssociationId *string

	// The authentication material required to start the local device discovery job
	// request.
	AuthenticationMaterial *string

	// The type of authentication material used for device discovery jobs.
	AuthenticationMaterialType types.DiscoveryAuthMaterialType

	// An idempotency token. If you retry a request that completed successfully
	// initially using the same client token and parameters, then the retry attempt
	// will succeed without performing any further actions.
	ClientToken *string

	// The id of the connector association.
	//
	// Deprecated: ConnectorAssociationIdentifier is deprecated
	ConnectorAssociationIdentifier *string

	// The id of the end-user's IoT hub.
	ControllerIdentifier *string

	// Additional protocol-specific details required for device discovery, which vary
	// based on the discovery type.
	//
	// For a DiscoveryType of CUSTOM , the string-to-string map must have a key value
	// of Name set to a non-empty-string.
	CustomProtocolDetail map[string]string

	// A set of key/value pairs that are used to manage the device discovery request.
	//
	// Deprecated: Tags have been deprecated from this api
	Tags map[string]string

	noSmithyDocumentSerde
}

type StartDeviceDiscoveryOutput struct {

	// The id of the device discovery job request.
	Id *string

	// The timestamp value for the start time of the device discovery.
	StartedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDeviceDiscoveryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDeviceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDeviceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDeviceDiscovery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartDeviceDiscoveryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDeviceDiscovery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDeviceDiscovery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDeviceDiscovery",
	}
}
